package fr.ifremer.tutti.ui.swing.content.referential;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.help.JAXXHelpUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class ManageTemporaryReferentialUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<TuttiUIContext, ManageTemporaryReferentialUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(ManageTemporaryReferentialUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton exportGearExampleButton;
    protected JButton exportPersonExampleButton;
    protected JButton exportSpeciesExampleButton;
    protected JButton exportVesselExampleButton;
    protected JLabel gearLabel;
    protected final ManageTemporaryReferentialUIHandler handler = new ManageTemporaryReferentialUIHandler();
    protected JButton importGearButton;
    protected JButton importPersonButton;
    protected JButton importSpeciesButton;
    protected JButton importVesselButton;
    protected ManageTemporaryReferentialUI manageTemporaryReferentialTopPanel = this;
    protected TuttiUIContext model;
    protected JLabel personLabel;
    protected JButton replaceGearButton;
    protected JButton replacePersonButton;
    protected JButton replaceSpeciesButton;
    protected JButton replaceVesselButton;
    protected JLabel speciesLabel;
    protected JLabel vesselLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JPanel $JPanel3;
    private JSeparator $JSeparator0;
    private JSeparator $JSeparator1;
    private JSeparator $JSeparator2;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ManageTemporaryReferentialUI(TuttiUI parentUI) {
        TuttiUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public ManageTemporaryReferentialUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ManageTemporaryReferentialUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ManageTemporaryReferentialUI() {
        $initialize();
    }

    public ManageTemporaryReferentialUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ManageTemporaryReferentialUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ManageTemporaryReferentialUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ManageTemporaryReferentialUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public ManageTemporaryReferentialUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getExportGearExampleButton() {
        return exportGearExampleButton;
    }

    public JButton getExportPersonExampleButton() {
        return exportPersonExampleButton;
    }

    public JButton getExportSpeciesExampleButton() {
        return exportSpeciesExampleButton;
    }

    public JButton getExportVesselExampleButton() {
        return exportVesselExampleButton;
    }

    public JLabel getGearLabel() {
        return gearLabel;
    }

    public ManageTemporaryReferentialUIHandler getHandler() {
        return handler;
    }

    public JButton getImportGearButton() {
        return importGearButton;
    }

    public JButton getImportPersonButton() {
        return importPersonButton;
    }

    public JButton getImportSpeciesButton() {
        return importSpeciesButton;
    }

    public JButton getImportVesselButton() {
        return importVesselButton;
    }

    public TuttiUIContext getModel() {
        return model;
    }

    public JLabel getPersonLabel() {
        return personLabel;
    }

    public JButton getReplaceGearButton() {
        return replaceGearButton;
    }

    public JButton getReplacePersonButton() {
        return replacePersonButton;
    }

    public JButton getReplaceSpeciesButton() {
        return replaceSpeciesButton;
    }

    public JButton getReplaceVesselButton() {
        return replaceVesselButton;
    }

    public JLabel getSpeciesLabel() {
        return speciesLabel;
    }

    public JLabel getVesselLabel() {
        return vesselLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JPanel get$JPanel3() {
        return $JPanel3;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    protected JSeparator get$JSeparator2() {
        return $JSeparator2;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToManageTemporaryReferentialTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.CENTER);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.manageTemporaryReferential.help"));
    }

    protected void createExportGearExampleButton() {
        $objectMap.put("exportGearExampleButton", exportGearExampleButton = new JButton());
        
        exportGearExampleButton.setName("exportGearExampleButton");
        exportGearExampleButton.setText(t("tutti.manageTemporaryReferential.action.exportTemporaryGearExample"));
        exportGearExampleButton.setToolTipText(t("tutti.manageTemporaryReferential.action.exportTemporaryGearExample.tip"));
        exportGearExampleButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ExportTemporaryGearExampleAction.class);
        exportGearExampleButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.exportTemporaryGearExample.help");
    }

    protected void createExportPersonExampleButton() {
        $objectMap.put("exportPersonExampleButton", exportPersonExampleButton = new JButton());
        
        exportPersonExampleButton.setName("exportPersonExampleButton");
        exportPersonExampleButton.setText(t("tutti.manageTemporaryReferential.action.exportTemporaryPersonExample"));
        exportPersonExampleButton.setToolTipText(t("tutti.manageTemporaryReferential.action.exportTemporaryPersonExample.tip"));
        exportPersonExampleButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ExportTemporaryPersonExampleAction.class);
        exportPersonExampleButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.exportTemporaryPersonExample.help");
    }

    protected void createExportSpeciesExampleButton() {
        $objectMap.put("exportSpeciesExampleButton", exportSpeciesExampleButton = new JButton());
        
        exportSpeciesExampleButton.setName("exportSpeciesExampleButton");
        exportSpeciesExampleButton.setText(t("tutti.manageTemporaryReferential.action.exportTemporarySpeciesExample"));
        exportSpeciesExampleButton.setToolTipText(t("tutti.manageTemporaryReferential.action.exportTemporarySpeciesExample.tip"));
        exportSpeciesExampleButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ExportTemporarySpeciesExampleAction.class);
        exportSpeciesExampleButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.exportTemporarySpeciesExample.help");
    }

    protected void createExportVesselExampleButton() {
        $objectMap.put("exportVesselExampleButton", exportVesselExampleButton = new JButton());
        
        exportVesselExampleButton.setName("exportVesselExampleButton");
        exportVesselExampleButton.setText(t("tutti.manageTemporaryReferential.action.exportTemporaryVesselExample"));
        exportVesselExampleButton.setToolTipText(t("tutti.manageTemporaryReferential.action.exportTemporaryVesselExample.tip"));
        exportVesselExampleButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ExportTemporaryVesselExampleAction.class);
        exportVesselExampleButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.exportTemporaryVesselExample.help");
    }

    protected void createGearLabel() {
        $objectMap.put("gearLabel", gearLabel = new JLabel());
        
        gearLabel.setName("gearLabel");
        gearLabel.setText(t("tutti.manageTemporaryReferential.field.gear"));
        gearLabel.setToolTipText(t("tutti.manageTemporaryReferential.field.gear.tip"));
    }

    protected void createImportGearButton() {
        $objectMap.put("importGearButton", importGearButton = new JButton());
        
        importGearButton.setName("importGearButton");
        importGearButton.setText(t("tutti.manageTemporaryReferential.action.importTemporaryGear"));
        importGearButton.setToolTipText(t("tutti.manageTemporaryReferential.action.importTemporaryGear.tip"));
        importGearButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ImportTemporaryGearAction.class);
        importGearButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.importTemporaryGear.help");
    }

    protected void createImportPersonButton() {
        $objectMap.put("importPersonButton", importPersonButton = new JButton());
        
        importPersonButton.setName("importPersonButton");
        importPersonButton.setText(t("tutti.manageTemporaryReferential.action.importTemporaryPerson"));
        importPersonButton.setToolTipText(t("tutti.manageTemporaryReferential.action.importTemporaryPerson.tip"));
        importPersonButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ImportTemporaryPersonAction.class);
        importPersonButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.importTemporaryPerson.help");
    }

    protected void createImportSpeciesButton() {
        $objectMap.put("importSpeciesButton", importSpeciesButton = new JButton());
        
        importSpeciesButton.setName("importSpeciesButton");
        importSpeciesButton.setText(t("tutti.manageTemporaryReferential.action.importTemporarySpecies"));
        importSpeciesButton.setToolTipText(t("tutti.manageTemporaryReferential.action.importTemporarySpecies.tip"));
        importSpeciesButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ImportTemporarySpeciesAction.class);
        importSpeciesButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.importTemporarySpecies.help");
    }

    protected void createImportVesselButton() {
        $objectMap.put("importVesselButton", importVesselButton = new JButton());
        
        importVesselButton.setName("importVesselButton");
        importVesselButton.setText(t("tutti.manageTemporaryReferential.action.importTemporaryVessel"));
        importVesselButton.setToolTipText(t("tutti.manageTemporaryReferential.action.importTemporaryVessel.tip"));
        importVesselButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ImportTemporaryVesselAction.class);
        importVesselButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.importTemporaryVessel.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(TuttiUIContext.class));
    }

    protected void createPersonLabel() {
        $objectMap.put("personLabel", personLabel = new JLabel());
        
        personLabel.setName("personLabel");
        personLabel.setText(t("tutti.manageTemporaryReferential.field.person"));
        personLabel.setToolTipText(t("tutti.manageTemporaryReferential.field.person.tip"));
    }

    protected void createReplaceGearButton() {
        $objectMap.put("replaceGearButton", replaceGearButton = new JButton());
        
        replaceGearButton.setName("replaceGearButton");
        replaceGearButton.setText(t("tutti.manageTemporaryReferential.action.replaceTemporaryGear"));
        replaceGearButton.setToolTipText(t("tutti.manageTemporaryReferential.action.replaceTemporaryGear.tip"));
        replaceGearButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.OpenReplaceTemporaryGearUIAction.class);
        replaceGearButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.replaceTemporaryGear.help");
    }

    protected void createReplacePersonButton() {
        $objectMap.put("replacePersonButton", replacePersonButton = new JButton());
        
        replacePersonButton.setName("replacePersonButton");
        replacePersonButton.setText(t("tutti.manageTemporaryReferential.action.replaceTemporaryPerson"));
        replacePersonButton.setToolTipText(t("tutti.manageTemporaryReferential.action.replaceTemporaryPerson.tip"));
        replacePersonButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.OpenReplaceTemporaryPersonUIAction.class);
        replacePersonButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.replaceTemporaryPerson.help");
    }

    protected void createReplaceSpeciesButton() {
        $objectMap.put("replaceSpeciesButton", replaceSpeciesButton = new JButton());
        
        replaceSpeciesButton.setName("replaceSpeciesButton");
        replaceSpeciesButton.setText(t("tutti.manageTemporaryReferential.action.replaceTemporarySpecies"));
        replaceSpeciesButton.setToolTipText(t("tutti.manageTemporaryReferential.action.replaceTemporarySpecies.tip"));
        replaceSpeciesButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.OpenReplaceTemporarySpeciesUIAction.class);
        replaceSpeciesButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.replaceTemporarySpecies.help");
    }

    protected void createReplaceVesselButton() {
        $objectMap.put("replaceVesselButton", replaceVesselButton = new JButton());
        
        replaceVesselButton.setName("replaceVesselButton");
        replaceVesselButton.setText(t("tutti.manageTemporaryReferential.action.replaceTemporaryVessel"));
        replaceVesselButton.setToolTipText(t("tutti.manageTemporaryReferential.action.replaceTemporaryVessel.tip"));
        replaceVesselButton.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.OpenReplaceTemporaryVesselUIAction.class);
        replaceVesselButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.replaceTemporaryVessel.help");
    }

    protected void createSpeciesLabel() {
        $objectMap.put("speciesLabel", speciesLabel = new JLabel());
        
        speciesLabel.setName("speciesLabel");
        speciesLabel.setText(t("tutti.manageTemporaryReferential.field.species"));
        speciesLabel.setToolTipText(t("tutti.manageTemporaryReferential.field.species.tip"));
    }

    protected void createVesselLabel() {
        $objectMap.put("vesselLabel", vesselLabel = new JLabel());
        
        vesselLabel.setName("vesselLabel");
        vesselLabel.setText(t("tutti.manageTemporaryReferential.field.vessel"));
        vesselLabel.setToolTipText(t("tutti.manageTemporaryReferential.field.vessel.tip"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToManageTemporaryReferentialTopPanel();
        // inline complete setup of $Table0
        $Table0.add(speciesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JSeparator0, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(vesselLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JSeparator1, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(gearLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel2, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JSeparator2, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(personLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel3, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(exportSpeciesExampleButton);
        $JPanel0.add(importSpeciesButton);
        $JPanel0.add(replaceSpeciesButton);
        // inline complete setup of $JPanel1
        $JPanel1.add(exportVesselExampleButton);
        $JPanel1.add(importVesselButton);
        $JPanel1.add(replaceVesselButton);
        // inline complete setup of $JPanel2
        $JPanel2.add(exportGearExampleButton);
        $JPanel2.add(importGearButton);
        $JPanel2.add(replaceGearButton);
        // inline complete setup of $JPanel3
        $JPanel3.add(exportPersonExampleButton);
        $JPanel3.add(importPersonButton);
        $JPanel3.add(replacePersonButton);
        
        // apply 21 property setters
        speciesLabel.setIcon(SwingUtil.createImageIcon("action-species.gif"));
        exportSpeciesExampleButton.setIcon(SwingUtil.createActionIcon("export"));
        importSpeciesButton.setIcon(SwingUtil.createActionIcon("import"));
        replaceSpeciesButton.setIcon(SwingUtil.createActionIcon("replace"));
        vesselLabel.setIcon(SwingUtil.createActionIcon("vessel"));
        exportVesselExampleButton.setIcon(SwingUtil.createActionIcon("export"));
        importVesselButton.setIcon(SwingUtil.createActionIcon("import"));
        replaceVesselButton.setIcon(SwingUtil.createActionIcon("replace"));
        gearLabel.setIcon(SwingUtil.createActionIcon("gear"));
        exportGearExampleButton.setIcon(SwingUtil.createActionIcon("export"));
        importGearButton.setIcon(SwingUtil.createActionIcon("import"));
        replaceGearButton.setIcon(SwingUtil.createActionIcon("replace"));
        personLabel.setIcon(SwingUtil.createActionIcon("person"));
        exportPersonExampleButton.setIcon(SwingUtil.createActionIcon("export"));
        importPersonButton.setIcon(SwingUtil.createActionIcon("import"));
        replacePersonButton.setIcon(SwingUtil.createActionIcon("replace"));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, manageTemporaryReferentialTopPanel, "tutti.manageTemporaryReferential.help");
        registerHelpId(_broker, exportSpeciesExampleButton, "tutti.manageTemporaryReferential.action.exportTemporarySpeciesExample.help");
        registerHelpId(_broker, importSpeciesButton, "tutti.manageTemporaryReferential.action.importTemporarySpecies.help");
        registerHelpId(_broker, replaceSpeciesButton, "tutti.manageTemporaryReferential.action.replaceTemporarySpecies.help");
        registerHelpId(_broker, exportVesselExampleButton, "tutti.manageTemporaryReferential.action.exportTemporaryVesselExample.help");
        registerHelpId(_broker, importVesselButton, "tutti.manageTemporaryReferential.action.importTemporaryVessel.help");
        registerHelpId(_broker, replaceVesselButton, "tutti.manageTemporaryReferential.action.replaceTemporaryVessel.help");
        registerHelpId(_broker, exportGearExampleButton, "tutti.manageTemporaryReferential.action.exportTemporaryGearExample.help");
        registerHelpId(_broker, importGearButton, "tutti.manageTemporaryReferential.action.importTemporaryGear.help");
        registerHelpId(_broker, replaceGearButton, "tutti.manageTemporaryReferential.action.replaceTemporaryGear.help");
        registerHelpId(_broker, exportPersonExampleButton, "tutti.manageTemporaryReferential.action.exportTemporaryPersonExample.help");
        registerHelpId(_broker, importPersonButton, "tutti.manageTemporaryReferential.action.importTemporaryPerson.help");
        registerHelpId(_broker, replacePersonButton, "tutti.manageTemporaryReferential.action.replaceTemporaryPerson.help");
        _broker.prepareUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("manageTemporaryReferentialTopPanel", manageTemporaryReferentialTopPanel);
        createModel();
        createBroker();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createSpeciesLabel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createExportSpeciesExampleButton();
        createImportSpeciesButton();
        createReplaceSpeciesButton();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createVesselLabel();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,0));
        createExportVesselExampleButton();
        createImportVesselButton();
        createReplaceVesselButton();
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new JSeparator());
        
        $JSeparator1.setName("$JSeparator1");
        createGearLabel();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1,0));
        createExportGearExampleButton();
        createImportGearButton();
        createReplaceGearButton();
        // inline creation of $JSeparator2
        $objectMap.put("$JSeparator2", $JSeparator2 = new JSeparator());
        
        $JSeparator2.setName("$JSeparator2");
        createPersonLabel();
        // inline creation of $JPanel3
        $objectMap.put("$JPanel3", $JPanel3 = new JPanel());
        
        $JPanel3.setName("$JPanel3");
        $JPanel3.setLayout(new GridLayout(1,0));
        createExportPersonExampleButton();
        createImportPersonButton();
        createReplacePersonButton();
        // inline creation of manageTemporaryReferentialTopPanel
        setName("manageTemporaryReferentialTopPanel");
        setLayout(new BorderLayout());
        manageTemporaryReferentialTopPanel.putClientProperty("help", "tutti.manageTemporaryReferential.help");
        
        $completeSetup();
        handler.afterInit(this);
    }

}