// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.referential.taxon;

import fr.ifremer.adagio.core.dao.referential.Status;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;

/**
 * Deux éléments sont à distinguer dans l'autorité de classification d’un taxon :
 * - La publication qui fait état de la description et de la nomenclature du taxon.
 * - La citation, associée au nom du taxon, pour faire référence à la publication d'origine du
 * taxon. Les règles de nomenclature des taxons et de leurs auteurs sont définies dans The
 * International Code of Zoological Nomenclature (ICZN : http://www.iczn.org/iczn/index.jsp ) pour
 * la faune, et dans The International Code of Botanical Nomenclature (ICBN :
 * http://www.bgbm.fu-berlin.de/iapt/nomenclature/CODE/SaintLouis/0000St.Luistitle.htm) pour la
 * flore.
 * Chaque taxon ne possède qu'une seule publication, et une seule citation. Une publication peut
 * correspondre à plusieurs taxons, et une citation peut être identique pour plusieurs taxons.
 */
// HibernateEntity.vsl annotations merge-point
public abstract class Citation
    implements Serializable, Comparable<Citation>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -1396517268586088144L;

    // Generate 4 attributes
    private Integer id;

    /**
     * Identifiant unique de la citation.Généré par le système.
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * Identifiant unique de la citation.Généré par le système.
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private String name;

    /**
     * Libellé de la citation. Elle comprend toujours au moins un auteur et une date.
     * @return this.name String
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * Libellé de la citation. Elle comprend toujours au moins un auteur et une date.
     * @param nameIn String
     */
    public void setName(String nameIn)
    {
        this.name = nameIn;
    }

    private Date creationDate;

    /**
     * Date de création de la citation. Renseigné automatiquement par le système.
     * @return this.creationDate Date
     */
    public Date getCreationDate()
    {
        return this.creationDate;
    }

    /**
     * Date de création de la citation. Renseigné automatiquement par le système.
     * @param creationDateIn Date
     */
    public void setCreationDate(Date creationDateIn)
    {
        this.creationDate = creationDateIn;
    }

    private Timestamp updateDate;

    /**
     * Date de mise à jour de la citation. Renseigné automatiquement par le système.
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * Date de mise à jour de la citation. Renseigné automatiquement par le système.
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    // Generate 3 associations
    private Status status;

    /**
     * Pour les données du référentiel, information permettant de déterminer si une donnée est
     * valide,
     * obsolète ou temporaire.
     * - obsolète (=inactif) : '0'
     * - valide (=actif) : '1'
     * - temporaire : '2'
     * note : on a préfère ici 'valide' au terme 'actif' (utilisé dans Harmonie), pour ne pas
     * confondre
     * avec par exemple l'activité d'un navire sur un mois.
     * @return this.status Status
     */
    public Status getStatus()
    {
        return this.status;
    }

    /**
     * Pour les données du référentiel, information permettant de déterminer si une donnée est
     * valide,
     * obsolète ou temporaire.
     * - obsolète (=inactif) : '0'
     * - valide (=actif) : '1'
     * - temporaire : '2'
     * note : on a préfère ici 'valide' au terme 'actif' (utilisé dans Harmonie), pour ne pas
     * confondre
     * avec par exemple l'activité d'un navire sur un mois.
     * @param statusIn Status
     */
    public void setStatus(Status statusIn)
    {
        this.status = statusIn;
    }

    /**
     * Returns <code>true</code> if the argument is an Citation instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof Citation))
        {
            return false;
        }
        final Citation that = (Citation)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link Citation}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link Citation}.
         * @return new CitationImpl()
         */
        public static Citation newInstance()
        {
            return new CitationImpl();
        }

        /**
         * Constructs a new instance of {@link Citation}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param name String
         * @param creationDate Date
         * @param status Status
         * @return newInstance
         */
        public static Citation newInstance(String name, Date creationDate, Status status)
        {
            final Citation entity = new CitationImpl();
            entity.setName(name);
            entity.setCreationDate(creationDate);
            entity.setStatus(status);
            return entity;
        }

        /**
         * Constructs a new instance of {@link Citation}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param name String
         * @param creationDate Date
         * @param updateDate Timestamp
         * @param status Status
         * @return newInstance Citation
         */
        public static Citation newInstance(String name, Date creationDate, Timestamp updateDate, Status status)
        {
            final Citation entity = new CitationImpl();
            entity.setName(name);
            entity.setCreationDate(creationDate);
            entity.setUpdateDate(updateDate);
            entity.setStatus(status);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(Citation o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getName() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getName().compareTo(o.getName()));
            }
            if (this.getCreationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getCreationDate().compareTo(o.getCreationDate()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// Citation.java merge-point
}