/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.dao;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.synchro.SynchroTechnicalException;
import fr.ifremer.adagio.synchro.config.SynchroConfiguration;
import fr.ifremer.adagio.synchro.dao.DaoUtils;
import fr.ifremer.adagio.synchro.dao.SynchroTableDao;
import fr.ifremer.adagio.synchro.intercept.SynchroInterceptor;
import fr.ifremer.adagio.synchro.intercept.SynchroInterceptorBase;
import fr.ifremer.adagio.synchro.intercept.SynchroInterceptorUtils;
import fr.ifremer.adagio.synchro.intercept.SynchroWriteBuffer;
import fr.ifremer.adagio.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroTableMetadata;
import fr.ifremer.adagio.synchro.service.SynchroContext;
import fr.ifremer.adagio.synchro.service.SynchroPendingOperationBuffer;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SynchroTableDaoImpl
implements SynchroTableDao {
    private static final Log log = LogFactory.getLog(SynchroTableDaoImpl.class);
    public static final String TABLE_TEMP_QUERY_PARAMETER = "temp_query_parameter";
    protected final Connection connection;
    protected final SynchroDatabaseMetadata dbMeta;
    protected final SynchroTableMetadata table;
    protected final PreparedStatement insertStatement;
    protected final PreparedStatement insertQueryParameterStatement;
    protected final PreparedStatement updateStatement;
    protected final List<PreparedStatement> selectStatements;
    protected final boolean insertStrategyGenerateIdFirst;
    protected final int columnCount;
    protected final int batchSize;
    protected final String tableName;
    protected boolean debug;
    protected int insertCount = 0;
    protected int updateCount = 0;
    protected final int idColumnIndex;
    protected final SynchroInterceptor readInterceptor;
    protected final SynchroInterceptor writeInterceptor;
    protected SynchroPendingOperationBuffer pendingOperationBuffer;

    public SynchroTableDaoImpl(Connection connection, SynchroTableMetadata table, boolean enableWriteStatements) throws SQLException {
        this.connection = connection;
        this.table = table;
        this.dbMeta = table.getDatabaseMetadata();
        this.columnCount = table.getColumnsCount();
        this.selectStatements = Lists.newArrayList();
        this.tableName = table.getName();
        this.batchSize = SynchroConfiguration.getInstance().getImportJdbcBatchSize();
        Preconditions.checkArgument((this.batchSize > 0 ? 1 : 0) != 0);
        this.debug = log.isTraceEnabled();
        this.idColumnIndex = table.isWithIdColumn() ? table.getColumnIndex("id") + 1 : -1;
        if (enableWriteStatements) {
            String insertSql = table.getUpdateQuery();
            this.insertStatement = connection.prepareStatement(insertSql);
            this.insertStrategyGenerateIdFirst = table.getInsertStrategy() == SynchroTableMetadata.TableInsertStrategy.GENERATE_ID_FIRST;
            String updateSql = table.getUpdateQuery();
            this.updateStatement = connection.prepareStatement(updateSql);
            this.writeInterceptor = this.initWriteInterceptor(table.getInterceptors());
        } else {
            this.insertStatement = null;
            this.updateStatement = null;
            this.insertStrategyGenerateIdFirst = false;
            this.writeInterceptor = null;
        }
        String insertQueryParameterSql = this.createTempQueryParameterQuery(table);
        this.insertQueryParameterStatement = insertQueryParameterSql != null ? this.getConnection().prepareStatement(insertQueryParameterSql) : null;
        this.readInterceptor = this.initReadInterceptor(table.getInterceptors());
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public SynchroTableMetadata getTable() {
        return this.table;
    }

    @Override
    public void setPendingOperationBuffer(SynchroPendingOperationBuffer pendingChangesBuffer) {
        this.pendingOperationBuffer = pendingChangesBuffer;
    }

    @Override
    public SynchroPendingOperationBuffer getPendingOperationBuffer() {
        return this.pendingOperationBuffer;
    }

    @Override
    public int getInsertCount() {
        return this.insertCount;
    }

    @Override
    public int getUpdateCount() {
        return this.updateCount;
    }

    @Override
    public void flush() throws SQLException {
        if (!this.debug) {
            if (this.insertCount > 0 && this.insertCount % this.batchSize != 0) {
                this.insertStatement.executeBatch();
            }
            if (this.updateCount > 0 && this.updateCount % this.batchSize != 0) {
                this.updateStatement.executeBatch();
            }
        }
    }

    @Override
    public void close() throws IOException {
        DaoUtils.closeSilently(this.insertStatement);
        DaoUtils.closeSilently(this.updateStatement);
        DaoUtils.closeSilently(this.insertQueryParameterStatement);
        this.closeSelectStatements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getLastUpdateDate() throws SQLException {
        if (!this.table.isWithUpdateDateColumn()) {
            return null;
        }
        String sql = this.table.getSelectMaxUpdateDateQuery();
        if (sql == null) {
            return null;
        }
        PreparedStatement statement = this.getConnection().prepareStatement(sql);
        try {
            Timestamp result;
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                Timestamp timestamp = null;
                return timestamp;
            }
            Timestamp timestamp = result = resultSet.getTimestamp(1);
            return timestamp;
        }
        finally {
            DaoUtils.closeSilently(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count() throws SQLException {
        String sql = this.table.getCountQuery();
        PreparedStatement statement = this.getConnection().prepareStatement(sql);
        try {
            long result;
            ResultSet resultSet = statement.executeQuery();
            resultSet.next();
            long l = result = resultSet.getLong(1);
            return l;
        }
        finally {
            DaoUtils.closeSilently(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long countDataToUpdate(Date fromDate) throws SQLException {
        String sql = this.table.getCountDataToUpdateQuery(fromDate);
        PreparedStatement statement = this.getConnection().prepareStatement(sql);
        log.debug((Object)sql);
        try {
            long result;
            if (this.table.isWithUpdateDateColumn() && fromDate != null) {
                Timestamp updateDateValue = new Timestamp(fromDate.getTime());
                for (int i = 1; i <= statement.getParameterMetaData().getParameterCount(); ++i) {
                    statement.setTimestamp(i, updateDateValue);
                }
            }
            ResultSet queryResult = statement.executeQuery();
            queryResult.next();
            long l = result = queryResult.getLong(1);
            return l;
        }
        finally {
            DaoUtils.closeSilently(statement);
        }
    }

    @Override
    public ResultSet getDataToUpdate(Date fromDate) throws SQLException {
        String sql = this.table.getSelectDataToUpdateQuery(fromDate);
        PreparedStatement statement = this.getConnection().prepareStatement(sql);
        this.selectStatements.add(statement);
        if (this.table.isWithUpdateDateColumn() && fromDate != null) {
            statement.setTimestamp(1, new Timestamp(fromDate.getTime()));
            if (statement.getParameterMetaData().getParameterCount() > 1) {
                statement.setTimestamp(2, new Timestamp(fromDate.getTime()));
            }
        }
        statement.setFetchSize(this.batchSize);
        ResultSet result = statement.executeQuery();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAll() throws SQLException {
        PreparedStatement deleteStatement = this.getConnection().prepareStatement("DELETE FROM " + this.table.getName());
        try {
            deleteStatement.execute();
        }
        finally {
            DaoUtils.closeSilently(deleteStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] findByPk(List<Object> pk) throws SQLException {
        String selectDataSql = this.table.getSelectDataQueryFromPk();
        PreparedStatement selectStatement = this.getConnection().prepareStatement(selectDataSql);
        int columnCountIndex = 1;
        for (Object pkColumn : pk) {
            selectStatement.setObject(columnCountIndex++, pkColumn);
        }
        int columnsCount = this.table.getColumnsCount();
        try {
            ResultSet resultSet = selectStatement.executeQuery();
            resultSet.next();
            Object[] result = new Object[columnsCount];
            for (int i = 1; i <= columnsCount; ++i) {
                result[i - 1] = resultSet.getObject(i);
            }
            Object[] objectArray = result;
            return objectArray;
        }
        finally {
            DaoUtils.closeSilently(selectStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getExistingPrimaryKeys() throws SQLException {
        HashSet result = Sets.newHashSet();
        if (this.table.isSelectPrimaryKeysAsStringQueryEnable()) {
            String sql = this.table.getSelectPrimaryKeysAsStringQuery();
            PreparedStatement statement = this.getConnection().prepareStatement(sql);
            try {
                ResultSet resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    String pk = resultSet.getString(1);
                    result.add(pk);
                }
            }
            finally {
                DaoUtils.closeSilently(statement);
            }
        }
        String sql = this.table.getSelectPrimaryKeysQuery();
        PreparedStatement statement = this.getConnection().prepareStatement(sql);
        try {
            ResultSet resultSet = statement.executeQuery();
            int columnCount = this.table.getPkNames().size();
            ArrayList pks = Lists.newArrayListWithCapacity((int)columnCount);
            while (resultSet.next()) {
                for (int i = 1; i <= columnCount; ++i) {
                    Object pk = resultSet.getObject(i);
                    pks.add(pk);
                }
                result.add(this.table.toPkStr(pks));
                pks.clear();
            }
        }
        finally {
            DaoUtils.closeSilently(statement);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer generateNewId() throws SQLException {
        String sql = this.table.getSequenceNextValString();
        Preconditions.checkNotNull((Object)sql);
        if (sql == null) {
            return null;
        }
        PreparedStatement statement = this.getConnection().prepareStatement(sql);
        try {
            Integer result;
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                Integer n = null;
                return n;
            }
            Integer n = result = Integer.valueOf(resultSet.getInt(1));
            return n;
        }
        finally {
            DaoUtils.closeSilently(statement);
        }
    }

    @Override
    public void executeInsert(ResultSet incomingData) throws SQLException {
        Preconditions.checkArgument((!this.insertStrategyGenerateIdFirst ? 1 : 0) != 0);
        ArrayList params = null;
        if (this.debug) {
            params = Lists.newArrayList();
        }
        if (this.writeInterceptor != null) {
            this.transformAndSetData(this.insertStatement, incomingData, (SynchroWriteBuffer)this.pendingOperationBuffer, this.writeInterceptor, (List<Object>)params);
        } else {
            this.setData(this.insertStatement, incomingData, (List<Object>)params);
        }
        ++this.insertCount;
        if (this.debug) {
            List<Object> pk = this.table.getPk(incomingData);
            log.debug((Object)String.format("%s Execute insert query (pk:%s), params: %s", this.tableName, this.table.toPkStr(pk), params));
            this.insertStatement.executeUpdate();
        } else {
            this.insertStatement.addBatch();
            if (this.insertCount > 0 && this.insertCount % this.batchSize == 0) {
                this.insertStatement.executeBatch();
                this.insertStatement.clearBatch();
            }
        }
    }

    @Override
    public void executeInsert(Object[] incomingData) throws SQLException {
        Preconditions.checkArgument((!this.insertStrategyGenerateIdFirst ? 1 : 0) != 0);
        ArrayList params = null;
        if (this.debug) {
            params = Lists.newArrayList();
        }
        if (this.writeInterceptor != null) {
            this.transformAndSetData(this.insertStatement, incomingData, (SynchroWriteBuffer)this.pendingOperationBuffer, this.writeInterceptor, (List<Object>)params);
        } else {
            this.setData(this.insertStatement, incomingData, (List<Object>)params);
        }
        ++this.insertCount;
        if (this.debug) {
            List<Object> pk = this.table.getPk(incomingData);
            log.debug((Object)String.format("%s Execute insert query (pk:%s), params: %s", this.tableName, this.table.toPkStr(pk), params));
            this.insertStatement.executeUpdate();
        } else {
            this.insertStatement.addBatch();
            if (this.insertCount > 0 && this.insertCount % this.batchSize == 0) {
                this.insertStatement.executeBatch();
                this.insertStatement.clearBatch();
            }
        }
    }

    @Override
    public Integer executeInsertAndReturnId(ResultSet incomingData) throws SQLException {
        Preconditions.checkArgument((boolean)this.insertStrategyGenerateIdFirst);
        Integer id = this.generateNewId();
        ArrayList params = null;
        if (this.debug) {
            params = Lists.newArrayList();
        }
        if (this.writeInterceptor != null) {
            this.transformAndSetData(this.insertStatement, incomingData, (SynchroWriteBuffer)this.pendingOperationBuffer, this.writeInterceptor, (List<Object>)params);
        } else {
            this.setData(this.insertStatement, incomingData, (List<Object>)params);
        }
        this.insertStatement.setObject(this.columnCount + 1, id);
        ++this.insertCount;
        if (this.debug) {
            log.debug((Object)String.format("%s Execute insert query (pk:%s), params: %s", this.tableName, id, params));
            this.insertStatement.executeUpdate();
        } else {
            this.insertStatement.addBatch();
            if (this.insertCount > 0 && this.insertCount % this.batchSize == 0) {
                this.insertStatement.executeBatch();
                this.insertStatement.clearBatch();
            }
        }
        return id;
    }

    @Override
    public void executeUpdate(List<Object> pk, ResultSet incomingData) throws SQLException {
        ArrayList params = null;
        if (this.debug) {
            params = Lists.newArrayList();
        }
        if (this.writeInterceptor != null) {
            this.transformAndSetData(this.updateStatement, incomingData, (SynchroWriteBuffer)this.pendingOperationBuffer, this.writeInterceptor, (List<Object>)params);
        } else {
            this.setData(this.updateStatement, incomingData, (List<Object>)params);
        }
        int columnCountIndex = this.columnCount + 1;
        for (Object pkColumn : pk) {
            this.updateStatement.setObject(columnCountIndex++, pkColumn);
        }
        ++this.updateCount;
        if (this.debug) {
            log.debug((Object)String.format("%s Execute update query (pk:%s), params: %s", this.tableName, pk, params));
            int nbRowUpdated = this.updateStatement.executeUpdate();
            Preconditions.checkArgument((nbRowUpdated == 1 ? 1 : 0) != 0, (Object)String.format("%s rows has been updated, but expected 1 row.", nbRowUpdated));
        } else {
            this.updateStatement.addBatch();
            if (this.updateCount > 0 && this.updateCount % this.batchSize == 0) {
                this.updateStatement.executeBatch();
                this.updateStatement.clearBatch();
            }
        }
    }

    @Override
    public void executeUpdate(List<Object> pk, Object[] row) throws SQLException {
        ArrayList params = null;
        if (this.debug) {
            params = Lists.newArrayList();
        }
        if (this.writeInterceptor != null) {
            this.transformAndSetData(this.updateStatement, row, (SynchroWriteBuffer)this.pendingOperationBuffer, this.writeInterceptor, (List<Object>)params);
        } else {
            this.setData(this.updateStatement, row, (List<Object>)params);
        }
        int columnCountIndex = this.columnCount + 1;
        for (Object pkColumn : pk) {
            this.updateStatement.setObject(columnCountIndex++, pkColumn);
        }
        ++this.updateCount;
        if (this.debug) {
            log.debug((Object)String.format("%s Execute update query (pk:%s), params: %s", this.tableName, pk, params));
            int nbRowUpdated = this.updateStatement.executeUpdate();
            Preconditions.checkArgument((nbRowUpdated == 1 ? 1 : 0) != 0, (Object)String.format("%s rows has been updated, but expected 1 row.", nbRowUpdated));
        } else {
            this.updateStatement.addBatch();
            if (this.updateCount > 0 && this.updateCount % this.batchSize == 0) {
                this.updateStatement.executeBatch();
                this.updateStatement.clearBatch();
            }
        }
    }

    @Override
    public ResultSet getDataByFk(String fkColumnName, Set<Integer> fkValues) throws SQLException {
        boolean insertUsingTempQueryParameter;
        boolean bl = insertUsingTempQueryParameter = this.isTempQueryParameterEnable() && fkValues.size() > this.dbMeta.getInExpressionCountLimit();
        if (insertUsingTempQueryParameter) {
            return this.getDataByFkUsingTempParameterTable(fkColumnName, fkValues);
        }
        return this.getDataByFkWithInOperator(fkColumnName, fkValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getIdFromRemoteId(String tableName, Integer remoteId) throws SQLException {
        String sql = this.getTable().getSelectIdFromRemoteIdQuery(tableName);
        if (sql == null) {
            return null;
        }
        PreparedStatement statement = this.getConnection().prepareStatement(sql);
        statement.setInt(1, remoteId);
        try {
            Integer result;
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                Integer n = null;
                return n;
            }
            Integer n = result = Integer.valueOf(resultSet.getInt(1));
            return n;
        }
        finally {
            DaoUtils.closeSilently(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Integer, Integer> getExistingRemoteIdsMap() throws SQLException {
        String sql = this.getTable().getSelectRemoteIdsQuery();
        PreparedStatement statement = this.getConnection().prepareStatement(sql);
        HashMap result = Maps.newHashMap();
        try {
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                int id = resultSet.getInt(1);
                int remoteId = resultSet.getInt(2);
                result.put(remoteId, id);
            }
            statement.close();
            HashMap hashMap = result;
            return hashMap;
        }
        finally {
            DaoUtils.closeSilently(statement);
        }
    }

    public List<Object> getPk(ResultSet incomingData, SynchroWriteBuffer transformResult) throws SQLException {
        List<Object> result;
        if (this.readInterceptor != null) {
            Object[] data = this.transformData(incomingData, this.readInterceptor, transformResult);
            result = this.getTable().getPk(data);
        } else {
            result = this.getTable().getPk(incomingData);
        }
        return result;
    }

    public boolean isTempQueryParameterEnable() {
        return this.insertQueryParameterStatement != null;
    }

    public void clearCounts() {
        this.insertCount = 0;
        this.updateCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertValuesIntoTempQueryParameter(Set<Integer> parameterValues, String queryParameterName, int queryPersonId) throws SQLException {
        Preconditions.checkNotNull((Object)this.insertQueryParameterStatement);
        if (this.debug) {
            log.debug((Object)String.format("%s Setting query parameters into %s", this.tableName, TABLE_TEMP_QUERY_PARAMETER.toUpperCase()));
        }
        Statement stm = this.getConnection().createStatement();
        try {
            stm.executeUpdate(String.format("DELETE FROM %", TABLE_TEMP_QUERY_PARAMETER));
        }
        finally {
            DaoUtils.closeSilently(stm);
        }
        int i = 1;
        for (Integer parameterValue : parameterValues) {
            this.insertQueryParameterStatement.setInt(1, i++);
            this.insertQueryParameterStatement.setString(2, queryParameterName);
            this.insertQueryParameterStatement.setInt(3, parameterValue);
            this.insertQueryParameterStatement.setNull(4, 12);
            this.insertQueryParameterStatement.setInt(5, queryPersonId);
            this.insertQueryParameterStatement.addBatch();
        }
        this.insertQueryParameterStatement.executeBatch();
        this.insertQueryParameterStatement.clearBatch();
    }

    protected String createTempQueryParameterQuery(SynchroTableMetadata table) {
        SynchroDatabaseMetadata dbMeta = table.getDatabaseMetadata();
        if (dbMeta.getTable(TABLE_TEMP_QUERY_PARAMETER) == null) {
            return null;
        }
        return String.format("INSERT INTO %s (ID, PARAMETER_NAME, NUMERICAL_VALUE, ALPHANUMERICAL_VALUE, PERSON_FK) VALUES (?, ?, ?, ?, ?)", TABLE_TEMP_QUERY_PARAMETER);
    }

    protected void closeSelectStatements() {
        if (CollectionUtils.isNotEmpty(this.selectStatements)) {
            for (PreparedStatement statement : this.selectStatements) {
                DaoUtils.closeSilently(statement);
            }
        }
        this.selectStatements.clear();
    }

    protected void closePreviousSelectStatements(PreparedStatement newStatement) {
        this.closeSelectStatements();
        this.selectStatements.add(newStatement);
    }

    protected void setData(PreparedStatement statement, Object[] values, List<Object> debugParams) throws SQLException {
        for (int c = 1; c <= this.columnCount; ++c) {
            Object object = values[c - 1];
            statement.setObject(c, object);
            if (!this.debug) continue;
            debugParams.add(object);
        }
    }

    protected void setData(PreparedStatement statement, ResultSet incomingData, List<Object> debugParams) throws SQLException {
        for (int c = 1; c <= this.columnCount; ++c) {
            Object object = incomingData.getObject(c);
            statement.setObject(c, object);
            if (!this.debug) continue;
            debugParams.add(object);
        }
    }

    protected void transformAndSetData(PreparedStatement statement, ResultSet incomingData, SynchroWriteBuffer transformBuffer, SynchroInterceptor interceptor, List<Object> debugParams) throws SQLException {
        Preconditions.checkNotNull((Object)transformBuffer);
        Object[] row = this.transformData(incomingData, interceptor, transformBuffer);
        this.setData(statement, row, debugParams);
    }

    protected void transformAndSetData(PreparedStatement statement, Object[] incomingData, SynchroWriteBuffer transformBuffer, SynchroInterceptor interceptor, List<Object> debugParams) throws SQLException {
        Preconditions.checkNotNull((Object)transformBuffer);
        Object[] row = this.transformData(incomingData, interceptor, transformBuffer);
        this.setData(statement, row, debugParams);
    }

    protected Object[] transformData(ResultSet incomingData, SynchroInterceptor interceptor, SynchroWriteBuffer buffer) throws SQLException {
        Preconditions.checkNotNull((Object)interceptor);
        Object[] result = this.table.getData(incomingData);
        try {
            interceptor.onWrite(result, this, buffer);
        }
        catch (Exception e) {
            throw new SynchroTechnicalException(String.format("Error while transform row, for table %s", this.table.getName()), e);
        }
        return result;
    }

    protected Object[] transformData(Object[] incomingData, SynchroInterceptor interceptor, SynchroWriteBuffer buffer) throws SQLException {
        Preconditions.checkNotNull((Object)interceptor);
        try {
            interceptor.onWrite(incomingData, this, buffer);
        }
        catch (Exception e) {
            throw new SynchroTechnicalException(String.format("Error while transform row, for table %s", this.table.getName()), e);
        }
        return incomingData;
    }

    protected ResultSet getDataByFkWithInOperator(String fkColumnName, Set<Integer> fkValues) throws SQLException {
        String sql = this.table.getSelectDataFromFkQuery(fkColumnName, fkValues.size());
        Preconditions.checkNotNull((Object)sql, (Object)String.format("Columns %s is not referenced for table %s", fkColumnName, this.table.getName()));
        PreparedStatement statement = this.getConnection().prepareStatement(sql);
        this.closePreviousSelectStatements(statement);
        int paramIndex = 1;
        for (Integer value : fkValues) {
            statement.setObject(paramIndex, value);
            ++paramIndex;
        }
        statement.setFetchSize(this.batchSize);
        ResultSet result = statement.executeQuery();
        return result;
    }

    protected ResultSet getDataByFkUsingTempParameterTable(String fkColumnName, Set<Integer> fkValues) throws SQLException {
        String sql = this.table.getSelectDataFromFkQueryBigParams(fkColumnName);
        Preconditions.checkNotNull((Object)sql);
        PreparedStatement statement = this.getConnection().prepareStatement(sql);
        this.closePreviousSelectStatements(statement);
        String queryParameterName = "remoteIds";
        int personFk = -1;
        this.insertValuesIntoTempQueryParameter(fkValues, queryParameterName, personFk);
        statement.setString(1, queryParameterName);
        statement.setInt(2, personFk);
        statement.setFetchSize(this.batchSize);
        ResultSet result = statement.executeQuery();
        return result;
    }

    @Override
    public List<Object> getPk(ResultSet incomingData) throws SQLException {
        return this.table.getPk(incomingData);
    }

    private SynchroInterceptor initReadInterceptor(List<SynchroInterceptor> interceptors) {
        if (CollectionUtils.isEmpty(interceptors)) {
            return null;
        }
        SynchroContext context = this.table.getDatabaseMetadata().getContext();
        ArrayList readInterceptors = Lists.newArrayList();
        try {
            for (SynchroInterceptor interceptor : interceptors) {
                if (!interceptor.enableOnRead()) continue;
                SynchroInterceptor newInterceptor = (SynchroInterceptor)interceptor.getClass().newInstance();
                newInterceptor.setContext(context);
                readInterceptors.add(interceptor);
            }
        }
        catch (Exception e) {
            throw new SynchroTechnicalException("Could not initialize DAO read interceptors.", e);
        }
        if (CollectionUtils.isEmpty((Collection)readInterceptors)) {
            return null;
        }
        return SynchroInterceptorUtils.chain(readInterceptors, SynchroInterceptorBase.class);
    }

    private SynchroInterceptor initWriteInterceptor(List<SynchroInterceptor> interceptors) {
        if (CollectionUtils.isEmpty(interceptors)) {
            return null;
        }
        SynchroContext context = this.table.getDatabaseMetadata().getContext();
        ArrayList writeInterceptors = Lists.newArrayList();
        try {
            for (SynchroInterceptor interceptor : interceptors) {
                if (!interceptor.enableOnWrite()) continue;
                SynchroInterceptor newInterceptor = (SynchroInterceptor)interceptor.getClass().newInstance();
                newInterceptor.setContext(context);
                writeInterceptors.add(interceptor);
            }
        }
        catch (Exception e) {
            throw new SynchroTechnicalException("Could not initialize DAO read interceptors.", e);
        }
        if (CollectionUtils.isEmpty((Collection)writeInterceptors)) {
            return null;
        }
        return SynchroInterceptorUtils.chain(writeInterceptors, SynchroInterceptorBase.class);
    }
}

