/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import liquibase.change.AbstractChange;
import liquibase.change.AddColumnConfig;
import liquibase.change.Change;
import liquibase.change.ChangeWithColumns;
import liquibase.change.ColumnConfig;
import liquibase.change.ConstraintsConfig;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.DropColumnChange;
import liquibase.change.core.DropDefaultValueChange;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.FirebirdDatabase;
import liquibase.database.core.H2Database;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.AbstractSqlStatement;
import liquibase.statement.AutoIncrementConstraint;
import liquibase.statement.ColumnConstraint;
import liquibase.statement.ForeignKeyConstraint;
import liquibase.statement.NotNullConstraint;
import liquibase.statement.PrimaryKeyConstraint;
import liquibase.statement.SqlStatement;
import liquibase.statement.UniqueConstraint;
import liquibase.statement.core.AddColumnStatement;
import liquibase.statement.core.ReorganizeTableStatement;
import liquibase.statement.core.SetColumnRemarksStatement;
import liquibase.statement.core.UpdateStatement;
import liquibase.util.StringUtils;

@DatabaseChange(name="addColumn", description="Adds a new column to an existing table", priority=1, appliesTo={"table"})
public class AddColumnChange
extends AbstractChange
implements ChangeWithColumns<AddColumnConfig> {
    private String catalogName;
    private String schemaName;
    private String tableName;
    private List<AddColumnConfig> columns = new ArrayList<AddColumnConfig>();

    @DatabaseChangeProperty(mustEqualExisting="relation.catalog", since="3.0")
    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @DatabaseChangeProperty(mustEqualExisting="relation.schema")
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @DatabaseChangeProperty(mustEqualExisting="table", description="Name of the table to add the column to")
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    @DatabaseChangeProperty(description="Column constraint and foreign key information. Setting the \"defaultValue\" attribute will specify a default value for the column. Setting the \"value\" attribute will set all rows existing to the specified value without modifying the column default.", requiredForDatabase={"all"})
    public List<AddColumnConfig> getColumns() {
        return this.columns;
    }

    @Override
    public void setColumns(List<AddColumnConfig> columns) {
        this.columns = columns;
    }

    @Override
    public void addColumn(AddColumnConfig column) {
        this.columns.add(column);
    }

    public void removeColumn(ColumnConfig column) {
        this.columns.remove(column);
    }

    @Override
    public SqlStatement[] generateStatements(Database database) {
        ArrayList<AbstractSqlStatement> sql = new ArrayList<AbstractSqlStatement>();
        if (this.getColumns().size() == 0) {
            return new SqlStatement[]{new AddColumnStatement(this.catalogName, this.schemaName, this.tableName, null, null, null, new ColumnConstraint[0])};
        }
        for (AddColumnConfig addColumnConfig : this.getColumns()) {
            HashSet<ColumnConstraint> constraints = new HashSet<ColumnConstraint>();
            ConstraintsConfig constraintsConfig = addColumnConfig.getConstraints();
            if (constraintsConfig != null) {
                if (constraintsConfig.isNullable() != null && !constraintsConfig.isNullable().booleanValue()) {
                    constraints.add(new NotNullConstraint());
                }
                if (constraintsConfig.isUnique() != null && constraintsConfig.isUnique().booleanValue()) {
                    constraints.add(new UniqueConstraint());
                }
                if (constraintsConfig.isPrimaryKey() != null && constraintsConfig.isPrimaryKey().booleanValue()) {
                    constraints.add(new PrimaryKeyConstraint(constraintsConfig.getPrimaryKeyName()));
                }
                if (constraintsConfig.getReferences() != null || constraintsConfig.getReferencedColumnNames() != null && constraintsConfig.getReferencedTableName() != null) {
                    constraints.add(new ForeignKeyConstraint(constraintsConfig.getForeignKeyName(), constraintsConfig.getReferences(), constraintsConfig.getReferencedTableName(), constraintsConfig.getReferencedColumnNames()));
                }
            }
            if (addColumnConfig.isAutoIncrement() != null && addColumnConfig.isAutoIncrement().booleanValue()) {
                constraints.add(new AutoIncrementConstraint(addColumnConfig.getName(), addColumnConfig.getStartWith(), addColumnConfig.getIncrementBy()));
            }
            AddColumnStatement addColumnStatement = new AddColumnStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName(), addColumnConfig.getName(), addColumnConfig.getType(), addColumnConfig.getDefaultValueObject(), addColumnConfig.getRemarks(), constraints.toArray(new ColumnConstraint[constraints.size()]));
            if (database instanceof MySQLDatabase && addColumnConfig.getAfterColumn() != null) {
                addColumnStatement.setAddAfterColumn(addColumnConfig.getAfterColumn());
            } else if ((database instanceof HsqlDatabase || database instanceof H2Database) && addColumnConfig.getBeforeColumn() != null) {
                addColumnStatement.setAddBeforeColumn(addColumnConfig.getBeforeColumn());
            } else if (database instanceof FirebirdDatabase && addColumnConfig.getPosition() != null) {
                addColumnStatement.setAddAtPosition(addColumnConfig.getPosition());
            }
            sql.add(addColumnStatement);
            if (database instanceof DB2Database) {
                sql.add(new ReorganizeTableStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName()));
            }
            if (addColumnConfig.getValueObject() == null) continue;
            UpdateStatement updateStatement = new UpdateStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName());
            updateStatement.addNewColumnValue(addColumnConfig.getName(), addColumnConfig.getValueObject());
            sql.add(updateStatement);
        }
        for (ColumnConfig columnConfig : this.getColumns()) {
            String columnRemarks = StringUtils.trimToNull(columnConfig.getRemarks());
            if (columnRemarks == null) continue;
            SetColumnRemarksStatement remarksStatement = new SetColumnRemarksStatement(this.catalogName, this.schemaName, this.tableName, columnConfig.getName(), columnRemarks);
            if (!SqlGeneratorFactory.getInstance().supports(remarksStatement, database)) continue;
            sql.add(remarksStatement);
        }
        return sql.toArray(new SqlStatement[sql.size()]);
    }

    @Override
    protected Change[] createInverses() {
        ArrayList<AbstractChange> inverses = new ArrayList<AbstractChange>();
        for (ColumnConfig columnConfig : this.columns) {
            if (columnConfig.hasDefaultValue()) {
                DropDefaultValueChange dropChange = new DropDefaultValueChange();
                dropChange.setTableName(this.getTableName());
                dropChange.setColumnName(columnConfig.getName());
                dropChange.setSchemaName(this.getSchemaName());
                inverses.add(dropChange);
            }
            DropColumnChange inverse = new DropColumnChange();
            inverse.setSchemaName(this.getSchemaName());
            inverse.setColumnName(columnConfig.getName());
            inverse.setTableName(this.getTableName());
            inverses.add(inverse);
        }
        return inverses.toArray(new Change[inverses.size()]);
    }

    @Override
    public String getConfirmationMessage() {
        ArrayList<String> names = new ArrayList<String>(this.columns.size());
        for (ColumnConfig columnConfig : this.columns) {
            names.add(String.valueOf(columnConfig.getName()) + "(" + columnConfig.getType() + ")");
        }
        return "Columns " + StringUtils.join(names, ",") + " added to " + this.tableName;
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog";
    }
}

