/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.application.swing.util;

import java.awt.Color;
import java.awt.Desktop;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JTable;
import jaxx.runtime.JAXXObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.jaxx.application.swing.ApplicationUIContext;
import org.nuiton.jaxx.application.swing.util.ApplicationColorHighlighter;

public class ApplicationUIUtil {
    private static final Log log = LogFactory.getLog(ApplicationUIUtil.class);

    protected ApplicationUIUtil() {
    }

    public static void setApplicationContext(JAXXObject ui, ApplicationUIContext context) {
        ui.setContextValue((Object)context, "applicationContext");
    }

    public static ApplicationUIContext getApplicationContext(JAXXObject ui) {
        return (ApplicationUIContext)ui.getContextValue(ApplicationUIContext.class, "applicationContext");
    }

    public static Highlighter newBackgroundColorHighlighter(HighlightPredicate predicate, Color color) {
        return new ApplicationColorHighlighter(predicate, color, false);
    }

    public static Highlighter newForegroundColorHighlighter(HighlightPredicate predicate, Color color) {
        return new ApplicationColorHighlighter(predicate, color, true);
    }

    public static void openLink(URL url) {
        try {
            ApplicationUIUtil.openLink(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new ApplicationTechnicalException(I18n.t((String)"jaxx.application.error.cannot.open.link", (Object[])new Object[]{url}), (Throwable)e);
        }
    }

    public static Desktop getDesktopForBrowse() {
        if (!Desktop.isDesktopSupported()) {
            throw new ApplicationTechnicalException(I18n.t((String)"jaxx.application.error.desktop.not.supported", (Object[])new Object[0]));
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.BROWSE)) {
            throw new ApplicationTechnicalException(I18n.t((String)"jaxx.application.error.desktop.browse.not.supported", (Object[])new Object[0]));
        }
        return desktop;
    }

    public static void openLink(URI uri) {
        Desktop desktop = ApplicationUIUtil.getDesktopForBrowse();
        try {
            desktop.browse(uri);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"jaxx.application.error.cannot.open.link", (Object[])new Object[]{uri}), (Throwable)e);
        }
    }

    public static Desktop getDesktopForMail() {
        if (!Desktop.isDesktopSupported()) {
            throw new ApplicationTechnicalException(I18n.t((String)"jaxx.application.error.desktop.not.supported", (Object[])new Object[0]));
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.MAIL)) {
            throw new ApplicationTechnicalException(I18n.t((String)"jaxx.application.error.desktop.mail.not.supported", (Object[])new Object[0]));
        }
        return desktop;
    }

    public static void mail(String subject, String body) {
        Desktop desktop = ApplicationUIUtil.getDesktopForMail();
        try {
            URI mailtoURI = new URI("mailto", null, null, "subject=" + subject + "&body=" + body, null);
            desktop.mail(mailtoURI);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"jaxx.application.error.cannot.mail", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public static void selectFirstCellOnFirstRowAndStopEditing(JXTable table) {
        ApplicationUIUtil.doSelectCell((JTable)table, 0, 0);
        if (table.isEditing()) {
            table.getCellEditor().stopCellEditing();
        }
    }

    public static void selectFirstCellOnLastRow(JXTable table) {
        ApplicationUIUtil.doSelectCell((JTable)table, table.getRowCount() - 1, 0);
    }

    public static void selectFirstCellOnRow(JXTable table, int row, boolean stopEdit) {
        ApplicationUIUtil.doSelectCell((JTable)table, row, 0);
        if (stopEdit && table.isEditing()) {
            table.getCellEditor().stopCellEditing();
        }
    }

    public static void doSelectCell(JTable table, int rowIndex, int columnIndex) {
        int rowCount = table.getRowCount();
        if (rowCount == 0) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"No row in table, can not select any cell");
            }
            return;
        }
        int columnCount = table.getColumnCount();
        if (columnCount == 0) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"No column in table, can not select any cell");
            }
            return;
        }
        if (columnIndex > columnCount) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("ColumnIndex: %s is more than columnCount %s", columnIndex, columnCount));
            }
            columnIndex = columnCount - 1;
        }
        if (columnIndex < 0) {
            columnIndex = 0;
        }
        if (rowIndex >= rowCount) {
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("RowIndex: %s is more than rowCount %s", rowIndex, rowCount));
            }
            rowIndex = rowCount - 1;
        }
        if (rowIndex < 0) {
            rowIndex = 0;
        }
        table.setColumnSelectionInterval(columnIndex, columnIndex);
        table.setRowSelectionInterval(rowIndex, rowIndex);
        table.editCellAt(rowIndex, columnIndex);
    }
}

