/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.service.technical.synchro;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.service.technical.synchro.ReferentialSynchroTable;
import fr.ifremer.adagio.core.service.technical.synchro.ReferentialSynchroTableMetadata;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.Table;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.TableMetadata;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ReferentialSynchroDatabaseMetadata {
    private static final Log log = LogFactory.getLog(ReferentialSynchroDatabaseMetadata.class);
    protected final DatabaseMetadata delegate;
    protected final Map<String, ReferentialSynchroTableMetadata> tables;
    protected final DatabaseMetaData meta;

    public static ReferentialSynchroDatabaseMetadata loadDatabaseMetadata(Connection connection, Dialect dialect) {
        ReferentialSynchroDatabaseMetadata result = new ReferentialSynchroDatabaseMetadata(connection, dialect);
        for (ReferentialSynchroTable tuttiTable : ReferentialSynchroTable.values()) {
            String tableName = tuttiTable.name();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Load metas of table: " + tableName));
            }
            result.getTable(tableName);
        }
        return result;
    }

    public ReferentialSynchroDatabaseMetadata(Connection connection, Dialect dialect) {
        Preconditions.checkNotNull((Object)connection);
        Preconditions.checkNotNull((Object)dialect);
        try {
            this.delegate = new DatabaseMetadata(connection, dialect, true);
            this.meta = connection.getMetaData();
        }
        catch (SQLException e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.persistence.dbMetadata.instanciation.error", (Object[])new Object[]{connection}), (Throwable)e);
        }
        this.tables = Maps.newTreeMap();
    }

    public ReferentialSynchroTableMetadata getTable(String name) throws HibernateException {
        return this.getTable(name, "PUBLIC", null, false);
    }

    public int getTableCount() {
        return this.tables.size();
    }

    public Set<String> getTableNames() {
        HashSet result = Sets.newHashSet();
        for (ReferentialSynchroTableMetadata tableMetadata : this.tables.values()) {
            result.add(tableMetadata.getName());
        }
        return result;
    }

    protected ReferentialSynchroTableMetadata getTable(String name, String schema, String catalog, boolean isQuoted) throws HibernateException {
        String key = Table.qualify((String)catalog, (String)schema, (String)name);
        ReferentialSynchroTableMetadata tuttiTableMetadata = this.tables.get(key);
        if (tuttiTableMetadata == null) {
            TableMetadata tableMetadata = this.delegate.getTableMetadata(name, schema, catalog, isQuoted);
            Preconditions.checkNotNull((Object)tableMetadata, (Object)("Could not find db table " + name));
            ReferentialSynchroTable tuttiTable = ReferentialSynchroTable.valueOf(name);
            Preconditions.checkNotNull((Object)((Object)tuttiTable), (Object)("Could not find db table " + (Object)((Object)tuttiTable)));
            tuttiTableMetadata = new ReferentialSynchroTableMetadata(tableMetadata, this.meta);
            Preconditions.checkNotNull((Object)tuttiTableMetadata, (Object)("Could not find db table " + name));
            this.tables.put(key, tuttiTableMetadata);
        }
        return tuttiTableMetadata;
    }
}

