/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.psionimport;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.Attachments;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequencys;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchs;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.service.TuttiEnumerationFile;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.psionimport.PsionImportBatchModel;
import fr.ifremer.tutti.service.psionimport.PsionImportModel;
import fr.ifremer.tutti.service.psionimport.PsionImportResult;
import fr.ifremer.tutti.type.WeightUnit;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;

public class PsionImportService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(PsionImportService.class);
    protected static final Set<String> SEX_VALUES = Sets.newHashSet((Object[])new String[]{"I", "i", "F", "f", "M", "m"});
    protected static final Set<String> MATURITY_VALUES = Sets.newHashSet((Object[])new String[]{"1", "2", "3", "4", "5"});
    protected PersistenceService persistenceService;
    protected TuttiEnumerationFile enumerationFile;
    protected CaracteristicQualitativeValue sortedCaracteristic;
    protected CaracteristicQualitativeValue unsortedCaracteristic;
    protected Map<String, CaracteristicQualitativeValue> sexCaracteristicValues;
    protected Map<String, CaracteristicQualitativeValue> maturityCaracteristicValues;
    protected final DateFormat df = new SimpleDateFormat("MM-dd-yyyy");

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.enumerationFile = this.persistenceService.getEnumerationFile();
        Caracteristic caracteristic = this.persistenceService.getSortedUnsortedCaracteristic();
        this.sortedCaracteristic = TuttiEntities.getQualitativeValue((Caracteristic)caracteristic, (Integer)this.enumerationFile.QUALITATIVE_VRAC_ID);
        this.unsortedCaracteristic = TuttiEntities.getQualitativeValue((Caracteristic)caracteristic, (Integer)this.enumerationFile.QUALITATIVE_HORS_VRAC_ID);
        this.sexCaracteristicValues = Maps.newTreeMap();
        caracteristic = this.persistenceService.getSexCaracteristic();
        List qualitativeValues = caracteristic.getQualitativeValue();
        Map sexById = TuttiEntities.splitByIdAsInt((Iterable)qualitativeValues);
        CaracteristicQualitativeValue femaleCaracteristic = (CaracteristicQualitativeValue)sexById.get(this.enumerationFile.QUALITATIVE_SEX_FEMALE_ID);
        this.sexCaracteristicValues.put("F", femaleCaracteristic);
        this.sexCaracteristicValues.put("f", femaleCaracteristic);
        CaracteristicQualitativeValue maleCaracteristic = (CaracteristicQualitativeValue)sexById.get(this.enumerationFile.QUALITATIVE_SEX_MALE_ID);
        this.sexCaracteristicValues.put("M", maleCaracteristic);
        this.sexCaracteristicValues.put("m", maleCaracteristic);
        CaracteristicQualitativeValue unkownCaracteristic = (CaracteristicQualitativeValue)sexById.get(this.enumerationFile.QUALITATIVE_SEX_UNDEFINED_ID);
        this.sexCaracteristicValues.put("I", unkownCaracteristic);
        this.sexCaracteristicValues.put("i", unkownCaracteristic);
        this.maturityCaracteristicValues = Maps.newTreeMap();
        caracteristic = this.persistenceService.getMaturityCaracteristic();
        qualitativeValues = caracteristic.getQualitativeValue();
        Map byIds = TuttiEntities.splitByIdAsInt((Iterable)qualitativeValues);
        this.maturityCaracteristicValues.put("1", (CaracteristicQualitativeValue)byIds.get(this.enumerationFile.QUALITATIVE_MATURITY_1_ID));
        this.maturityCaracteristicValues.put("2", (CaracteristicQualitativeValue)byIds.get(this.enumerationFile.QUALITATIVE_MATURITY_2_ID));
        this.maturityCaracteristicValues.put("3", (CaracteristicQualitativeValue)byIds.get(this.enumerationFile.QUALITATIVE_MATURITY_3_ID));
        this.maturityCaracteristicValues.put("4", (CaracteristicQualitativeValue)byIds.get(this.enumerationFile.QUALITATIVE_MATURITY_4_ID));
        this.maturityCaracteristicValues.put("5", (CaracteristicQualitativeValue)byIds.get(this.enumerationFile.QUALITATIVE_MATURITY_5_ID));
    }

    public PsionImportResult importFile(File psionFile, FishingOperation operation, CatchBatch catchBatch) {
        Preconditions.checkNotNull((Object)psionFile);
        Preconditions.checkArgument((boolean)psionFile.exists(), (Object)("Psion file " + psionFile + " does not exist."));
        TuttiProtocol protocol = this.persistenceService.getProtocol();
        if (protocol == null) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.psionimport.error.no.protocol", (Object[])new Object[0]));
        }
        List<Species> allReferentSpecies = this.persistenceService.getAllReferentSpecies();
        List<Species> allSpeciesWithSurveyCode = this.persistenceService.getReferentSpeciesWithSurveyCode(allReferentSpecies);
        TreeMap speciesBySurveyCode = Maps.newTreeMap();
        for (Species species : allSpeciesWithSurveyCode) {
            if (species.getSurveyCode() == null) continue;
            speciesBySurveyCode.put(species.getSurveyCode(), species);
        }
        TreeMap speciesProtocolBySurveyCode = Maps.newTreeMap();
        for (SpeciesProtocol speciesProtocol : protocol.getSpecies()) {
            if (speciesProtocol.getSpeciesSurveyCode() == null) continue;
            speciesProtocolBySurveyCode.put(speciesProtocol.getSpeciesSurveyCode(), speciesProtocol);
        }
        BatchContainer<SpeciesBatch> rootSpeciesBatch = this.persistenceService.getRootSpeciesBatch(operation.getId(), null);
        HashSet alreadyUsedSpecies = Sets.newHashSet();
        for (SpeciesBatch speciesBatch : rootSpeciesBatch.getChildren()) {
            alreadyUsedSpecies.add(speciesBatch.getSpecies());
        }
        PsionImportModel importModel = new PsionImportModel();
        try {
            this.readImportFile(importModel, psionFile, operation, speciesBySurveyCode, speciesProtocolBySurveyCode, alreadyUsedSpecies);
        }
        catch (IOException e) {
            importModel.addError(e.getMessage());
        }
        PsionImportResult result = new PsionImportResult(psionFile, importModel.getErrors());
        if (importModel.withErrors()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Won't import psion file, errors detected.");
            }
        } else {
            SampleCategoryModel sampleCategoryModel = this.context.getSampleCategoryModel();
            Set<Integer> sampleCategoryIdUsed = importModel.getSampleCategoryIdUsed();
            ArrayList missingCategories = Lists.newArrayList();
            for (Integer categoryId : sampleCategoryIdUsed) {
                if (sampleCategoryModel.containsCategoryId(categoryId)) continue;
                missingCategories.add("<li>" + categoryId + "</li>");
            }
            if (!missingCategories.isEmpty()) {
                result.addError(I18n.t((String)"tutti.service.psionimport.error.invalidSampleCategoryModel.message", (Object[])new Object[]{Joiner.on((String)"").join((Iterable)missingCategories)}));
            } else {
                this.persist(result, importModel, operation, catchBatch);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readImportFile(PsionImportModel importModel, File importFile, FishingOperation operation, Map<String, Species> speciesBySurveyCode, Map<String, SpeciesProtocol> speciesProtocolBySurveyCode, Set<Species> alreadyUsedSpecies) throws IOException {
        BufferedReader reader = Files.newReader((File)importFile, (Charset)Charsets.UTF_8);
        try {
            String line;
            boolean correctOperation;
            Date operationDate;
            reader.readLine();
            String operationCode = reader.readLine();
            String operationDateStr = reader.readLine();
            try {
                operationDate = this.df.parse(operationDateStr);
            }
            catch (ParseException e) {
                throw new IOException(I18n.t((String)"tutti.service.psionimport.error.invalid.date.format", (Object[])new Object[0]));
            }
            boolean bl = correctOperation = Objects.equals(operationCode, operation.getStationNumber()) && Objects.equals(operationDate, operation.getGearShootingStartDate());
            if (!correctOperation) {
                throw new IOException(I18n.t((String)"tutti.service.psionimport.error.invalid.operation", (Object[])new Object[0]));
            }
            reader.readLine();
            reader.readLine();
            int lineNumber = 5;
            PsionImportBatchModel batch = null;
            String badSpecies = null;
            while ((line = reader.readLine()) != null) {
                PsionImportKeyword command;
                ++lineNumber;
                if (!line.contains(":")) {
                    throw new IOException(I18n.t((String)"tutti.service.psionimport.error.invalid.line.syntax", (Object[])new Object[]{lineNumber, line}));
                }
                int endIndex = line.indexOf(58);
                String commandStr = StringUtils.trim((String)line.substring(0, endIndex));
                try {
                    command = PsionImportKeyword.valueOf(commandStr);
                }
                catch (IllegalArgumentException e) {
                    throw new IOException(I18n.t((String)"tutti.service.psionimport.error.invalid.command.syntax", (Object[])new Object[]{commandStr, lineNumber}));
                }
                String value = StringUtils.trim((String)line.substring(endIndex + 1));
                if (PsionImportKeyword.ESPE.equals((Object)command)) {
                    String error;
                    Species species;
                    if (batch != null) {
                        importModel.addBatch(batch);
                    }
                    if ((species = speciesBySurveyCode.get(value)) == null) {
                        badSpecies = value;
                        batch = null;
                        error = I18n.t((String)"tutti.service.psionimport.error.species.not.found", (Object[])new Object[]{lineNumber, value});
                        if (log.isWarnEnabled()) {
                            log.warn((Object)error);
                        }
                        importModel.addError(error);
                        continue;
                    }
                    if (alreadyUsedSpecies.contains(species)) {
                        badSpecies = value;
                        batch = null;
                        error = I18n.t((String)"tutti.service.psionimport.error.species.already.used", (Object[])new Object[]{lineNumber, value});
                        if (log.isWarnEnabled()) {
                            log.warn((Object)error);
                        }
                        importModel.addError(error);
                        continue;
                    }
                    badSpecies = null;
                    SpeciesProtocol speciesProtocol = speciesProtocolBySurveyCode.get(value);
                    String lengthStepCaracteristicId = speciesProtocol.getLengthStepPmfmId();
                    if (StringUtils.isBlank((CharSequence)lengthStepCaracteristicId)) {
                        badSpecies = value;
                        batch = null;
                        String error2 = I18n.t((String)"tutti.service.psionimport.error.no.lengthClass.caracteristic", (Object[])new Object[]{lineNumber, value});
                        if (log.isWarnEnabled()) {
                            log.warn((Object)error2);
                        }
                        importModel.addError(error2);
                        continue;
                    }
                    batch = new PsionImportBatchModel(species, Integer.valueOf(lengthStepCaracteristicId));
                } else {
                    if (badSpecies != null) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Ligne " + lineNumber + " ignor\u00e9e car l'esp\u00e8ce " + badSpecies + " n'\u00e9tait pas reconnue"));
                        continue;
                    }
                    if (batch == null) {
                        throw new IOException(I18n.t((String)"tutti.service.psionimport.error.invalid.firstLine", (Object[])new Object[]{line, lineNumber}));
                    }
                    switch (command) {
                        case POID: {
                            Float weight = this.toFloat(value, lineNumber);
                            batch.setWeight(weight);
                            break;
                        }
                        case TAIL: {
                            Float sampleWeight = this.toFloat(value, lineNumber);
                            batch.setSampleWeight(sampleWeight);
                            break;
                        }
                        case CATE: {
                            if (StringUtils.isBlank((CharSequence)value)) {
                                badSpecies = batch.getSpecies().getSurveyCode();
                                batch = null;
                                String error = I18n.t((String)"tutti.service.psionimport.error.invalid.category.syntax", (Object[])new Object[]{lineNumber, value, badSpecies});
                                if (log.isWarnEnabled()) {
                                    log.warn((Object)error);
                                }
                                importModel.addError(error);
                                break;
                            }
                            if (!"n".equals(value) && !"N".equals(value)) {
                                int nbCategory = value.length();
                                for (int i = 0; i < nbCategory; ++i) {
                                    String categoryCode = value.substring(i, i + 1);
                                    PsionImportBatchModel.SampleCategory category = this.guessCategory(categoryCode);
                                    if (category == null) {
                                        badSpecies = batch.getSpecies().getSurveyCode();
                                        batch = null;
                                        String error = I18n.t((String)"tutti.service.psionimport.error.invalid.category.syntax", (Object[])new Object[]{lineNumber, categoryCode, badSpecies});
                                        if (log.isWarnEnabled()) {
                                            log.warn((Object)error);
                                        }
                                        importModel.addError(error);
                                        break;
                                    }
                                    batch.setCategory(category.getCategoryId(), category.getCategoryValue());
                                }
                                if (batch == null) break;
                            }
                            batch.setCategoryCode(value);
                            break;
                        }
                        case LONG: {
                            Float size = this.toFloat(value, lineNumber);
                            batch.addFrequency(size, 1);
                        }
                    }
                }
            }
            if (batch != null) {
                importModel.addBatch(batch);
            }
            reader.close();
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    protected void persist(PsionImportResult result, PsionImportModel importModel, FishingOperation operation, CatchBatch catchBatch) {
        if (catchBatch != null) {
            this.addFileAsAttachment(result.getImportFile(), catchBatch);
        }
        TuttiEnumerationFile enumerationFile = this.persistenceService.getEnumerationFile();
        Set<Species> species = importModel.getSpecies();
        for (Species specy : species) {
            List<PsionImportBatchModel> batchs = importModel.getBatchs(specy);
            if (batchs.size() == 1 && !batchs.get(0).withCategories()) {
                PsionImportBatchModel batchModel = batchs.get(0);
                SpeciesBatch batch = this.createSpeciesBatch(operation, batchModel.getSpecies(), batchModel.getWeight(), batchModel.getSampleWeight(), enumerationFile.PMFM_ID_SORTED_UNSORTED, (Serializable)this.sortedCaracteristic);
                batch = this.persistenceService.createSpeciesBatch(batch, null);
                this.persistFrequencies(batch, batchModel);
            } else {
                SpeciesBatch rootBatch = this.createSpeciesBatch(operation, specy, null, null, enumerationFile.PMFM_ID_SORTED_UNSORTED, (Serializable)this.sortedCaracteristic);
                rootBatch = this.persistenceService.createSpeciesBatch(rootBatch, null);
                for (PsionImportBatchModel batchModel : batchs) {
                    SpeciesBatch parentBatch = rootBatch;
                    SpeciesBatch childBatch = null;
                    Iterator<PsionImportBatchModel.SampleCategory> categoryIterator = batchModel.getCategoryIterator();
                    while (categoryIterator.hasNext()) {
                        PsionImportBatchModel.SampleCategory sampleCategory = categoryIterator.next();
                        boolean lastCategory = !categoryIterator.hasNext();
                        Integer categoryId = sampleCategory.getCategoryId();
                        Serializable categoryValue = sampleCategory.getCategoryValue();
                        if (lastCategory) {
                            childBatch = this.createSpeciesBatch(operation, specy, batchModel.getWeight(), batchModel.getSampleWeight(), categoryId, categoryValue);
                        } else {
                            childBatch = null;
                            for (SpeciesBatch speciesBatch : parentBatch.getChildBatchs()) {
                                if (!speciesBatch.getSampleCategoryId().equals(categoryId) || !speciesBatch.getSampleCategoryValue().equals(categoryValue)) continue;
                                childBatch = speciesBatch;
                                break;
                            }
                            if (childBatch == null) {
                                childBatch = this.createSpeciesBatch(operation, specy, null, null, categoryId, categoryValue);
                            }
                        }
                        if (TuttiEntities.isNew((TuttiEntity)childBatch)) {
                            childBatch = this.persistenceService.createSpeciesBatch(childBatch, parentBatch.getId());
                            parentBatch.addChildBatchs(childBatch);
                        }
                        parentBatch = childBatch;
                    }
                    this.persistFrequencies(childBatch, batchModel);
                }
            }
            result.incrementNbImported();
        }
        this.persistenceService.saveCatchBatch(catchBatch);
    }

    protected PsionImportBatchModel.SampleCategory guessCategory(String categoryCode) {
        PsionImportBatchModel.SampleCategory result = null;
        if (SEX_VALUES.contains(categoryCode)) {
            Integer caracteristicId = this.enumerationFile.PMFM_ID_SEX;
            CaracteristicQualitativeValue caracteristicQualitativeValue = this.sexCaracteristicValues.get(categoryCode);
            result = new PsionImportBatchModel.SampleCategory(caracteristicId, (Serializable)caracteristicQualitativeValue);
        } else if (MATURITY_VALUES.contains(categoryCode)) {
            Integer caracteristicId = this.enumerationFile.PMFM_ID_MATURITY;
            CaracteristicQualitativeValue caracteristicQualitativeValue = this.maturityCaracteristicValues.get(categoryCode);
            result = new PsionImportBatchModel.SampleCategory(caracteristicId, (Serializable)caracteristicQualitativeValue);
        }
        return result;
    }

    protected void persistFrequencies(SpeciesBatch batch, PsionImportBatchModel batchModel) {
        Integer lengthStepCaracteristicId = batchModel.getLengthStepCaracteristicId();
        Map<Float, MutableInt> frequencies = batchModel.getFrequencies();
        ArrayList toSave = Lists.newArrayList();
        Caracteristic lengthStepCaracteristic = this.persistenceService.getCaracteristic(lengthStepCaracteristicId);
        for (Map.Entry<Float, MutableInt> entry : frequencies.entrySet()) {
            Float size = entry.getKey();
            MutableInt number = entry.getValue();
            SpeciesBatchFrequency batchFrequency = SpeciesBatchFrequencys.newSpeciesBatchFrequency();
            batchFrequency.setBatch(batch);
            batchFrequency.setLengthStepCaracteristic(lengthStepCaracteristic);
            batchFrequency.setLengthStep(size);
            batchFrequency.setNumber(number.getValue());
            toSave.add(batchFrequency);
        }
        this.persistenceService.saveSpeciesBatchFrequency(batch.getId(), toSave);
    }

    protected SpeciesBatch createSpeciesBatch(FishingOperation operation, Species species, Float catchWeight, Float sampleWeight, Integer categoryId, Serializable cqv) {
        SpeciesBatch batch = SpeciesBatchs.newSpeciesBatch();
        batch.setFishingOperation(operation);
        batch.setSampleCategoryId(categoryId);
        batch.setSampleCategoryValue(cqv);
        batch.setSpecies(species);
        if (catchWeight != null) {
            catchWeight = Float.valueOf(TuttiEntities.roundKiloGram((float)WeightUnit.G.toEntity(catchWeight).floatValue()));
            batch.setSampleCategoryWeight(catchWeight);
        }
        if (sampleWeight != null) {
            sampleWeight = Float.valueOf(TuttiEntities.roundKiloGram((float)WeightUnit.G.toEntity(sampleWeight).floatValue()));
            batch.setWeight(sampleWeight);
        }
        batch.setChildBatchs((List)Lists.newArrayList());
        return batch;
    }

    protected void addFileAsAttachment(File f, CatchBatch catchBatch) {
        Attachment attachment = Attachments.newAttachment();
        attachment.setObjectType(AttachementObjectTypeEnum.CATCH_BATCH);
        attachment.setObjectId(Integer.valueOf(catchBatch.getId()));
        attachment.setName(f.getName());
        String date = DateFormat.getDateTimeInstance().format(this.context.currentDate());
        String comment = I18n.t((String)"tutti.service.psion.import.attachment.comment", (Object[])new Object[]{date});
        attachment.setComment(comment);
        this.persistenceService.createAttachment(attachment, f);
    }

    protected Float toFloat(String cell, int lineNumber) throws IOException {
        Float result = null;
        if (!cell.isEmpty()) {
            try {
                result = Float.valueOf(cell);
            }
            catch (NumberFormatException e) {
                throw new IOException("Format de la valeur [" + lineNumber + "] : " + cell + " incorrect, devrait \u00eatre un entier d\u00e9cimal");
            }
        }
        if (result == null) {
            throw new IOException("La valeur [" + lineNumber + "] est obligatoire mais n'est pas renseign\u00e9e");
        }
        return result;
    }

    public static enum PsionImportKeyword {
        ESPE,
        POID,
        TAIL,
        CATE,
        LONG;

    }
}

