/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.session;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JFrame;
import jaxx.runtime.swing.session.State;

public class WindowState
implements State {
    private static final String WINDOW_STATE_NORMAL_BOUNDS = "WindowState.normalBounds";
    protected Rectangle bounds;
    protected Rectangle gcBounds;
    protected int frameState = 0;

    public WindowState() {
    }

    public WindowState(Rectangle bounds, Rectangle gcBounds, int frameState) {
        this.bounds = new Rectangle(bounds);
        this.gcBounds = new Rectangle(gcBounds);
        this.frameState = frameState;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    public Rectangle getGcBounds() {
        return this.gcBounds;
    }

    public void setGcBounds(Rectangle gcBounds) {
        this.gcBounds = gcBounds;
    }

    public int getFrameState() {
        return this.frameState;
    }

    public void setFrameState(int frameState) {
        this.frameState = frameState;
    }

    protected Window checkComponent(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("null component");
        }
        if (!(o instanceof Window)) {
            throw new IllegalArgumentException("invalid component");
        }
        return (Window)o;
    }

    protected static boolean isResizable(Window window) {
        boolean resizable = true;
        if (window instanceof Frame) {
            resizable = ((Frame)window).isResizable();
        } else if (window instanceof Dialog) {
            resizable = ((Dialog)window).isResizable();
        }
        return resizable;
    }

    protected static Rectangle getWindowNormalBounds(Window window) {
        Object res;
        Rectangle result = null;
        if (window instanceof JFrame && (res = ((JFrame)window).getRootPane().getClientProperty(WINDOW_STATE_NORMAL_BOUNDS)) instanceof Rectangle) {
            result = (Rectangle)res;
        }
        return result;
    }

    public static Rectangle computeVirtualGraphicsBounds() {
        GraphicsDevice[] gs;
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gs = ge.getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            virtualBounds = virtualBounds.union(gc.getBounds());
        }
        return virtualBounds;
    }

    public static void putWindowNormalBounds(Window window, Rectangle bounds) {
        if (window instanceof JFrame) {
            ((JFrame)window).getRootPane().putClientProperty(WINDOW_STATE_NORMAL_BOUNDS, bounds);
        }
    }

    @Override
    public State getState(Object o) {
        GraphicsConfiguration gc;
        Window c = this.checkComponent(o);
        int frameState = 0;
        if (c instanceof Frame) {
            frameState = ((Frame)c).getExtendedState();
        }
        Rectangle gcBounds = (gc = c.getGraphicsConfiguration()) == null ? null : gc.getBounds();
        Rectangle frameBounds = c.getBounds();
        if (c instanceof JFrame && 0 != (frameState & 6)) {
            frameBounds = WindowState.getWindowNormalBounds(c);
        }
        WindowState result = null;
        if (frameBounds != null && !frameBounds.isEmpty()) {
            result = new WindowState();
            result.setBounds(frameBounds);
            result.setGcBounds(gcBounds);
            result.setFrameState(frameState);
        }
        return result;
    }

    @Override
    public void setState(Object o, State state) {
        Window w = this.checkComponent(o);
        if (state != null && !(state instanceof WindowState)) {
            throw new IllegalArgumentException("invalid state");
        }
        WindowState windowState = (WindowState)state;
        if (windowState.getBounds() != null) {
            Rectangle gcBounds0;
            WindowState.putWindowNormalBounds(w, windowState.getBounds());
            if (!w.isLocationByPlatform() && state != null && (gcBounds0 = windowState.getGcBounds()) != null && WindowState.isResizable(w)) {
                if (WindowState.computeVirtualGraphicsBounds().contains(gcBounds0.getLocation())) {
                    w.setBounds(windowState.getBounds());
                } else {
                    w.setSize(windowState.getBounds().getSize());
                }
            }
            if (w instanceof Frame) {
                ((Frame)w).setExtendedState(windowState.getFrameState());
            }
        }
    }
}

