/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.catches.WeightComputingService;
import fr.ifremer.tutti.service.genericformat.csv.AccidentalCatchRow;
import fr.ifremer.tutti.service.genericformat.csv.CatchRow;
import fr.ifremer.tutti.service.genericformat.csv.IndividualObservationRow;
import fr.ifremer.tutti.service.genericformat.csv.MarineLitterRow;
import fr.ifremer.tutti.service.genericformat.csv.OperationRow;
import fr.ifremer.tutti.service.genericformat.csv.ParameterRow;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenericFormatExportOperationContext {
    private static final Log log = LogFactory.getLog(GenericFormatExportOperationContext.class);
    private final Cruise cruise;
    private final FishingOperation operation;
    private final CatchBatch catchBatch;
    private BatchContainer<MarineLitterBatch> rootMarineLitterBatch;
    private BatchContainer<SpeciesBatch> rootSpeciesBatch;
    private BatchContainer<BenthosBatch> rootBenthosBatch;
    private List<IndividualObservationBatch> individualObservations;
    private List<AccidentalBatch> accidentalBatches;
    private boolean withCatchBatch;
    private final PersistenceService persistenceService;
    protected final Caracteristic weightMeasuredCaracteristic;
    protected final Caracteristic pmfmIdCaracteristic;
    protected final Caracteristic deadOrAliveCaracteristic;
    protected final Caracteristic genderCaracteristic;
    private final SampleCategoryModel sampleCategoryModel;
    private final String operationLabel;
    private OperationRow operationRow;
    private List<ParameterRow> parameterRows;
    private List<MarineLitterRow> marineLitterRows;
    private List<IndividualObservationRow> individualObservationRows;
    private List<AccidentalCatchRow> accidentalCatchRows;
    private List<CatchRow> catchRows;

    public GenericFormatExportOperationContext(Cruise cruise, FishingOperation operation, String operationLabel, PersistenceService persistenceService, WeightComputingService weightComputingService, SampleCategoryModel sampleCategoryModel, Caracteristic weightMeasuredCaracteristic, Caracteristic pmfmIdCaracteristic, Caracteristic deadOrAliveCaracteristic, Caracteristic genderCaracteristic) {
        this.cruise = cruise;
        this.operation = operation;
        this.operationLabel = operationLabel;
        this.sampleCategoryModel = sampleCategoryModel;
        this.persistenceService = persistenceService;
        this.weightMeasuredCaracteristic = weightMeasuredCaracteristic;
        this.pmfmIdCaracteristic = pmfmIdCaracteristic;
        this.deadOrAliveCaracteristic = deadOrAliveCaracteristic;
        this.genderCaracteristic = genderCaracteristic;
        String operationId = operation.getId();
        this.accidentalBatches = persistenceService.getAllAccidentalBatch(operation.getId());
        this.withCatchBatch = persistenceService.isFishingOperationWithCatchBatch(operationId);
        if (this.withCatchBatch) {
            this.catchBatch = persistenceService.getCatchBatchFromFishingOperation(operationId);
            boolean withError = false;
            try {
                this.rootSpeciesBatch = weightComputingService.getComputedSpeciesBatches(operationId);
            }
            catch (Exception e) {
                withError = true;
                this.rootSpeciesBatch = persistenceService.getRootSpeciesBatch(operationId, false);
            }
            try {
                this.rootBenthosBatch = weightComputingService.getComputedBenthosBatches(operationId);
            }
            catch (Exception e) {
                withError = true;
                this.rootBenthosBatch = persistenceService.getRootBenthosBatch(operationId, false);
            }
            try {
                this.rootMarineLitterBatch = weightComputingService.getComputedMarineLitterBatches(operationId, this.catchBatch.getMarineLitterTotalWeight());
            }
            catch (Exception e) {
                withError = true;
                this.rootMarineLitterBatch = persistenceService.getRootMarineLitterBatch(operationId);
            }
            if (!withError) {
                weightComputingService.computeCatchBatchWeights(this.catchBatch, this.rootSpeciesBatch, this.rootBenthosBatch, this.rootMarineLitterBatch);
            }
            this.individualObservations = persistenceService.getAllIndividualObservationBatch(operation.getId());
        } else {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Skip fishing operation " + operationId + " since no catchBatch associated."));
            }
            this.catchBatch = null;
            this.rootSpeciesBatch = null;
            this.rootBenthosBatch = null;
            this.rootMarineLitterBatch = null;
        }
    }

    public Cruise getCruise() {
        return this.cruise;
    }

    public FishingOperation getOperation() {
        return this.operation;
    }

    public CatchBatch getCatchBatch() {
        return this.catchBatch;
    }

    public BatchContainer<MarineLitterBatch> getRootMarineLitterBatch() {
        return this.rootMarineLitterBatch;
    }

    public BatchContainer<SpeciesBatch> getRootSpeciesBatch() {
        return this.rootSpeciesBatch;
    }

    public BatchContainer<BenthosBatch> getRootBenthosBatch() {
        return this.rootBenthosBatch;
    }

    public boolean isWithCatchBatch() {
        return this.withCatchBatch;
    }

    public List<IndividualObservationBatch> getIndividualObservations() {
        return this.individualObservations;
    }

    public Caracteristic getWeightMeasuredCaracteristic() {
        return this.weightMeasuredCaracteristic;
    }

    public Caracteristic getPmfmIdCaracteristic() {
        return this.pmfmIdCaracteristic;
    }

    public Caracteristic getDeadOrAliveCaracteristic() {
        return this.deadOrAliveCaracteristic;
    }

    public Caracteristic getGenderCaracteristic() {
        return this.genderCaracteristic;
    }

    public List<AccidentalBatch> getAccidentalBatches() {
        return this.accidentalBatches;
    }

    public boolean isVracBatch(SpeciesAbleBatch batch) {
        return this.persistenceService.isVracBatch(batch);
    }

    public List<BenthosBatchFrequency> getAllBenthosBatchFrequency(String id) {
        return this.persistenceService.getAllBenthosBatchFrequency(id);
    }

    public List<SpeciesBatchFrequency> getAllSpeciesBatchFrequency(String id) {
        return this.persistenceService.getAllSpeciesBatchFrequency(id);
    }

    public SampleCategoryModel getSampleCategoryModel() {
        return this.sampleCategoryModel;
    }

    public String getOperationLabel() {
        return this.operationLabel;
    }

    public void setOperationRow(OperationRow operationRow) {
        this.operationRow = operationRow;
    }

    public OperationRow getOperationRow() {
        return this.operationRow;
    }

    public void setParameterRows(List<ParameterRow> parameterRows) {
        this.parameterRows = parameterRows;
    }

    public List<ParameterRow> getParameterRows() {
        return this.parameterRows;
    }

    public void setMarineLitterRows(List<MarineLitterRow> marineLitterRows) {
        this.marineLitterRows = marineLitterRows;
    }

    public List<MarineLitterRow> getMarineLitterRows() {
        return this.marineLitterRows;
    }

    public void setIndividualObservationRows(List<IndividualObservationRow> individualObservationRows) {
        this.individualObservationRows = individualObservationRows;
    }

    public List<IndividualObservationRow> getIndividualObservationRows() {
        return this.individualObservationRows;
    }

    public void setAccidentalCatchRows(List<AccidentalCatchRow> accidentalCatchRows) {
        this.accidentalCatchRows = accidentalCatchRows;
    }

    public List<AccidentalCatchRow> getAccidentalCatchRows() {
        return this.accidentalCatchRows;
    }

    public void setCatchRows(List<CatchRow> catchRows) {
        this.catchRows = catchRows;
    }

    public List<CatchRow> getCatchRows() {
        return this.catchRows;
    }
}

