/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.entities.referential;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.entities.referential.AbstractVessels;
import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntities;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import java.util.List;
import java.util.Map;

public class Vessels
extends AbstractVessels {
    public static final Predicate<Vessel> IS_TEMPORARY = new Predicate<Vessel>(){

        public boolean apply(Vessel input) {
            return Vessels.isTemporary(input);
        }
    };
    public static Function<Vessel, String> GET_REGISTRATION_CODE_OR_INTERNATIONAL_REGISTRATION_CODE = new Function<Vessel, String>(){

        public String apply(Vessel input) {
            String result = input.getRegistrationCode();
            if (result == null) {
                result = input.getInternationalRegistrationCode();
            }
            return result;
        }
    };
    public static final Function<Vessel, String> GET_REGISTRATION_CODE = new Function<Vessel, String>(){

        public String apply(Vessel input) {
            return input.getRegistrationCode();
        }
    };
    public static final Function<Vessel, String> GET_INTERNAL_REGISTRATION_CODE = new Function<Vessel, String>(){

        public String apply(Vessel input) {
            return input.getInternationalRegistrationCode();
        }
    };

    public static Map<String, Vessel> splitByRegistrationCode(List<Vessel> programs) {
        return Maps.uniqueIndex(programs, GET_REGISTRATION_CODE);
    }

    public static Map<String, Vessel> splitByInternationalRegistrationCode(List<Vessel> programs) {
        return Maps.uniqueIndex(programs, GET_INTERNAL_REGISTRATION_CODE);
    }

    public static boolean isTemporary(Vessel vessel) {
        Preconditions.checkNotNull((Object)vessel);
        Preconditions.checkNotNull((Object)vessel.getId());
        return TuttiReferentialEntities.isStatusTemporary(vessel) && Vessels.isTemporaryId(vessel.getId());
    }

    public static boolean isTemporaryId(String id) {
        Preconditions.checkNotNull((Object)id);
        return id.startsWith("#TEMP\u00bf");
    }
}

