/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.ModelException;
import org.eclipse.birt.report.model.i18n.ModelMessages;

public class DesignFileException
extends ModelException {
    private static final long serialVersionUID = 8790341685615483274L;
    private List<Exception> exceptionList = new ArrayList<Exception>();
    protected String fileName = null;
    protected Exception e = null;
    public static final String DESIGN_EXCEPTION_SYNTAX_ERROR = "Error.DesignFileException.SYNTAX_ERROR";
    public static final String DESIGN_EXCEPTION_SEMANTIC_ERROR = "Error.DesignFileException.SEMANTIC_ERROR";
    public static final String DESIGN_EXCEPTION_SEMANTIC_WARNING = "Error.DesignFileException.SEMANTIC_WARNING";
    public static final String DESIGN_EXCEPTION_INVALID_XML = "Error.DesignFileException.INVALID_XML";

    public DesignFileException(String fileName, Exception e) {
        super(DESIGN_EXCEPTION_INVALID_XML, (String[])null, (Throwable)e);
        this.fileName = fileName;
        this.e = e;
        this.exceptionList.add(e);
    }

    public DesignFileException(String fileName, List<? extends Exception> errList) {
        super(DESIGN_EXCEPTION_SYNTAX_ERROR);
        this.fileName = fileName;
        this.exceptionList.addAll(errList);
    }

    public DesignFileException(String fileName, List<? extends Exception> errList, Exception ex) {
        super(DESIGN_EXCEPTION_INVALID_XML, (String[])null, (Throwable)ex);
        this.fileName = fileName;
        this.exceptionList.addAll(errList);
        this.exceptionList.add(ex);
    }

    public List<ErrorDetail> getErrorList() {
        ArrayList<ErrorDetail> errorList = new ArrayList<ErrorDetail>();
        for (Exception e : this.exceptionList) {
            errorList.add(new ErrorDetail(e));
        }
        return errorList;
    }

    public List<Exception> getExceptionList() {
        return this.exceptionList;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String getLocalizedMessage() {
        if (this.sResourceKey == null) {
            return "";
        }
        return ModelMessages.getMessage(this.sResourceKey);
    }

    @Override
    public String getMessage() {
        return this.getLocalizedMessage();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.sResourceKey);
        sb.append(" - ");
        if (this.sResourceKey == DESIGN_EXCEPTION_SYNTAX_ERROR || this.sResourceKey == DESIGN_EXCEPTION_INVALID_XML) {
            List<ErrorDetail> errorList = this.getErrorList();
            if (errorList != null) {
                sb.append(errorList.size());
                sb.append(" errors found! \n");
                int i = 1;
                for (ErrorDetail e : errorList) {
                    sb.append(i++);
                    sb.append(".) ");
                    sb.append(e);
                    sb.append("\n");
                }
            }
        } else {
            assert (false);
            return super.toString();
        }
        return sb.toString();
    }
}

