/*
 * Decompiled with CFR 0.152.
 */
package liquibase.executor.jvm;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import liquibase.exception.DatabaseException;
import liquibase.executor.jvm.PreparedStatementSetter;
import liquibase.executor.jvm.StatementCreatorUtils;

class ArgTypePreparedStatementSetter
implements PreparedStatementSetter {
    private final Object[] args;
    private final int[] argTypes;

    public ArgTypePreparedStatementSetter(Object[] args, int[] argTypes) throws DatabaseException {
        if (args != null && argTypes == null || args == null && argTypes != null || args != null && args.length != argTypes.length) {
            throw new DatabaseException("args and argTypes parameters must match");
        }
        this.args = args;
        this.argTypes = argTypes;
    }

    @Override
    public void setValues(PreparedStatement ps) throws SQLException {
        int argIndx = 1;
        if (this.args != null) {
            int i = 0;
            while (i < this.args.length) {
                Object arg = this.args[i];
                if (arg instanceof Collection && this.argTypes[i] != 2003) {
                    Collection entries = (Collection)arg;
                    for (Object entry : entries) {
                        StatementCreatorUtils.setParameterValue(ps, argIndx++, this.argTypes[i], entry);
                    }
                } else {
                    StatementCreatorUtils.setParameterValue(ps, argIndx++, this.argTypes[i], arg);
                }
                ++i;
            }
        }
    }
}

