/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export.generic;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.service.export.generic.ExportSampleCategory;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CatchExportRow
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CatchExportRow.class);
    public static final String FREQUENCY_LENGTH_STEP = "frequency.lengthStep";
    public static final String FREQUENCY_NUMBER = "frequency.number";
    public static final String FREQUENCY_WEIGHT = "frequency.weight";
    public static final String FREQUENCY_LENGTH_STEP_CARACTERISTIC = "frequency.lengthStepCaracteristic";
    public static final String FREQUENCY_RANK_ORDER = "frequency.rankOrder";
    public static final String SAMPLE_CATEGORY = "sampleCategory";
    public static final String REFERENCE_WEIGHT = "referenceWeight";
    public static final String RAISING_FACTOR = "raisingFactor";
    public static final String BATCH_NUMBER = "batchNumber";
    public static final String BATCH_WEIGHT_UNIT = "batchWeightUnit";
    protected Cruise cruise;
    protected FishingOperation fishingOperation;
    protected final List<ExportSampleCategory> sampleCategory = Lists.newLinkedList();
    protected SpeciesBatchFrequency speciesFrequency;
    protected BenthosBatchFrequency benthosFrequency;
    protected Species species;
    protected Float referenceWeight;
    protected float raisingFactor;
    protected Integer batchNumber;
    protected String batchWeightUnit;
    protected final List<String> comment = Lists.newArrayList();

    public void setCruise(Cruise cruise) {
        this.cruise = cruise;
    }

    public void setFishingOperation(FishingOperation fishingOperation) {
        this.fishingOperation = fishingOperation;
    }

    public void setReferenceWeight(Float referenceWeight) {
        this.referenceWeight = referenceWeight;
    }

    public void setRaisingFactor(float raisingFactor) {
        this.raisingFactor = raisingFactor;
    }

    public void setBatchNumber(Integer batchNumber) {
        this.batchNumber = batchNumber;
    }

    public void addSampleCategory(ExportSampleCategory sampleCategory) {
        int order = sampleCategory.getCategoryDef().getOrder();
        while (this.sampleCategory.size() <= order) {
            this.sampleCategory.add(null);
        }
        this.sampleCategory.set(order, sampleCategory);
    }

    public void setSpeciesFrequency(SpeciesBatchFrequency speciesFrequency) {
        Preconditions.checkNotNull((Object)speciesFrequency);
        this.speciesFrequency = speciesFrequency;
        this.batchNumber = speciesFrequency.getNumber();
    }

    public void setBenthosFrequency(BenthosBatchFrequency benthosFrequency) {
        Preconditions.checkNotNull((Object)benthosFrequency);
        this.benthosFrequency = benthosFrequency;
        this.batchNumber = benthosFrequency.getNumber();
    }

    public Date getBeginDate() {
        return this.cruise.getBeginDate();
    }

    public Program getProgram() {
        return this.cruise.getProgram();
    }

    public String getSurveyPart() {
        return this.cruise.getSurveyPart();
    }

    public Vessel getVessel() {
        return this.cruise.getVessel();
    }

    public String getStationNumber() {
        return this.fishingOperation.getStationNumber();
    }

    public Integer getFishingOperationNumber() {
        return this.fishingOperation.getFishingOperationNumber();
    }

    public Gear getGear() {
        return this.fishingOperation.getGear();
    }

    public String getMultirigAggregation() {
        return this.fishingOperation.getMultirigAggregation();
    }

    public Object getFrequency() {
        return this.speciesFrequency == null ? this.benthosFrequency : this.speciesFrequency;
    }

    public List<ExportSampleCategory> getSampleCategory() {
        return this.sampleCategory;
    }

    public Species getSpecies() {
        return this.species;
    }

    public void setSpecies(Species species) {
        this.species = species;
    }

    public Float getReferenceWeight() {
        return this.referenceWeight;
    }

    public float getRaisingFactor() {
        return this.raisingFactor;
    }

    public Integer getBatchNumber() {
        return this.batchNumber;
    }

    public String getBatchWeightUnit() {
        return this.batchWeightUnit;
    }

    public void setBatchWeightUnit(String batchWeightUnit) {
        this.batchWeightUnit = batchWeightUnit;
    }

    public CatchExportRow copy() {
        CatchExportRow result = new CatchExportRow();
        result.setCruise(this.cruise);
        result.setFishingOperation(this.fishingOperation);
        result.sampleCategory.addAll(this.sampleCategory);
        if (this.benthosFrequency != null) {
            result.setBenthosFrequency(this.benthosFrequency);
        }
        if (this.speciesFrequency != null) {
            result.setSpeciesFrequency(this.speciesFrequency);
        }
        result.setSpecies(this.species);
        result.setRaisingFactor(this.raisingFactor);
        result.setReferenceWeight(this.referenceWeight);
        result.setBatchNumber(this.batchNumber);
        result.setBatchWeightUnit(this.batchWeightUnit);
        result.comment.addAll(this.comment);
        return result;
    }

    public void addComment(String comment) {
        String safeComment;
        String string = safeComment = StringUtils.isEmpty((CharSequence)comment) ? "" : comment;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add comment: " + safeComment));
        }
        this.comment.add(safeComment);
    }

    public void popLastComment() {
        if (!this.comment.isEmpty()) {
            this.comment.remove(this.comment.size() - 1);
        }
    }

    public String getComment() {
        String result = this.comment.isEmpty() ? "" : Joiner.on((char)'|').join(this.comment);
        return result;
    }
}

