/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import fr.ifremer.shared.application.swing.action.AbstractApplicationAction;
import fr.ifremer.shared.application.swing.action.ApplicationActionUI;
import fr.ifremer.shared.application.type.ApplicationProgressionModel;
import fr.ifremer.tutti.TuttiConfiguration;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.service.TuttiDataContext;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.Component;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beans.AbstractBean;
import org.nuiton.util.StringUtil;

public abstract class AbstractTuttiAction<M extends AbstractBean, UI extends TuttiUI<M, ?>, H extends AbstractTuttiUIHandler<M, UI>>
extends AbstractApplicationAction<M, UI, H> {
    public abstract void doAction() throws Exception;

    protected AbstractTuttiAction(H handler, boolean hideBody) {
        super(handler, hideBody);
    }

    public TuttiUIContext getContext() {
        return ((AbstractTuttiUIHandler)this.handler).getContext();
    }

    public void setProgressionModel(ProgressionModel progressionModel) {
        super.setProgressionModel((ApplicationProgressionModel)progressionModel);
    }

    protected ProgressionModel getProgressionModel() {
        return (ProgressionModel)this.getContext().getActionUI().getModel().getProgressionModel();
    }

    public TuttiDataContext getDataContext() {
        return this.getContext().getDataContext();
    }

    protected TuttiConfiguration getConfig() {
        return this.getContext().getConfig();
    }

    protected void sendMessage(String message) {
        this.getContext().showInformationMessage(message);
    }

    protected void createProgressionModelIfRequired(int total) {
        ProgressionModel progressionModel = this.getProgressionModel();
        if (progressionModel == null) {
            progressionModel = new ProgressionModel();
            progressionModel.setTotal(total);
            progressionModel.setMessage("");
            progressionModel.setCurrent(0);
            this.setProgressionModel(progressionModel);
        } else {
            progressionModel.adaptTotal(total);
        }
    }

    protected boolean askAdminPassword(String askMessage, String askMessageTitle, String errorMessage, String errorMessageTitle) {
        String answer;
        boolean result;
        ApplicationActionUI container = this.getContext().getActionUI();
        do {
            if ((answer = JOptionPane.showInputDialog((Component)container, askMessage, askMessageTitle, 2)) != null) {
                String correctAnswer;
                String cryptedAnswer = StringUtil.encodeMD5((String)answer);
                result = StringUtils.equals((CharSequence)cryptedAnswer, (CharSequence)(correctAnswer = this.getConfig().getAdminPassword()));
                if (result) continue;
                JOptionPane.showMessageDialog((Component)container, errorMessage, errorMessageTitle, 0);
                continue;
            }
            result = false;
        } while (!result && answer != null);
        return result;
    }
}

