/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.event;

import org.eclipse.birt.chart.computation.Object3D;
import org.eclipse.birt.chart.computation.Vector;
import org.eclipse.birt.chart.event.I3DRenderEvent;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Location3D;

public final class Line3DRenderEvent
extends LineRenderEvent
implements I3DRenderEvent {
    private static final long serialVersionUID = 33812052466380930L;
    private transient Object3D object3D = new Object3D(2);
    private transient Object3D object3DParent;

    public Line3DRenderEvent(Object oSource) {
        super(oSource);
    }

    public void setStart3D(Location3D start) {
        this.object3D.getVectors()[0] = new Vector(start);
    }

    public void setStart3D(double x, double y, double z) {
        this.object3D.getVectors()[0] = new Vector(x, y, z, true);
    }

    public Location3D getStart3D() {
        return this.object3D.getLocation3D()[0];
    }

    public void setEnd3D(Location3D end) {
        this.object3D.getVectors()[1] = new Vector(end);
    }

    public void setEnd3D(double x, double y, double z) {
        this.object3D.getVectors()[1] = new Vector(x, y, z, true);
    }

    public Location3D getEnd3D() {
        return this.object3D.getLocation3D()[1];
    }

    @Override
    public PrimitiveRenderEvent copy() {
        Line3DRenderEvent lre = new Line3DRenderEvent(this.source);
        lre.setLineAttributes(goFactory.copyOf(this.lia));
        if (this.object3D != null) {
            lre.object3D = new Object3D(this.object3D);
        }
        if (this.object3DParent != null) {
            lre.object3DParent = this.object3DParent;
        }
        return lre;
    }

    @Override
    public Object3D getObject3D() {
        return this.object3D;
    }

    @Override
    public void prepare2D(double xOffset, double yOffset) {
        Location[] points = this.object3D.getPoints2D(xOffset, yOffset);
        this.setStart(points[0]);
        this.setEnd(points[1]);
    }

    @Override
    public void reset() {
        this.object3D = new Object3D(2);
        super.reset();
    }

    public Object3D getObject3DParent() {
        return this.object3DParent;
    }

    public void setObject3DParent(Object3D object3DParent) {
        this.object3DParent = object3DParent;
    }
}

