package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.FileEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n._;

public class ImportPupitriPopupUI extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_EDITABLE = "editable";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVVzW8bRRR/duM0cdKmxPRLpKhNK5UeGPMhJERQ6adFIrdEJJUqfCjj3UkyZTwzzMy2G0Wg8h/wJ8CdCxI3TogDZw5cEP8CQhy4It7s2rvZZCwnByztevXm937v+813f0LDGrjylKYpMYl0fMDI2u3Hjz/qP2WRu8dsZLh2ykD+q9Wh3oO5uJBbB1d7Xa/eHqq376qBVpLJfdorXWhatyuY3WHMObhU1YisbW8UxyupTsyItXAqxPrN33/Vv45ffFsHSDV618RQLk/SKiOZ6kKdxw4W0dIz2hZUbqMbhstt9PeUl90V1NqHdMA+hy/hZBemNTVI5mD56CFnHJl+qh20OCKNW080R0v3OBVq28H6liF8y7ABM8QlznGScGKfoyckUtIhMVGaGeq4kiSiLtphlljNIo7/q/sZ15VO9KNVrTOT0w5mWMwd7Qvm4CUfEvFhkjtKCUZlCZsdUC7XqWTCwYVKCnM3Nj2Fx84WKqcdQj7rcMG6tO/1Fj1/OlRYy4QeulAaKTQcXAsY8a4qQzzgfvZZVV+MqDEqsUwURv3Jy1XUqQrKC89XATPX1rJA3zjocSatYucjKiMm7mBNsA7QquBzqUculUl5RgWPqWPl4ZUhwsArlZix60nZ9WVb1nrQMAmKsRK9w4PyMR7lI3LhwIh4wuz033Ot337844fOaC5m0fbZIHTfWGO/auO7zHFveiEfisRx0X5A9UoPWZjAnZDN/FLAsY3hMTqH9vJm8+rkQ2p3kKJx8veffj736a8noN6BplA07lCPX8W+2DGYBSXiVH9wK/No/vkMvs/gU3fQcNz5nrmYz0ZlhMjwrDFQMcUmnMIeYylmZymQncLF/uwv/7Q2vr81ylANPb44Fl5mqfEJTHMpuGTZ7hiuheCumNOWJbEqxz+0ECC8EfRwMG9k79dDOZkRvv87qAlze8VcfeETwFLcUFdDudriTMSkQKeJp387i99/vQOHpnqSJ1NoEO1hS5C9J68tBws0IiQIZNLiDlu+gY4ueL3RwuR+vN47BgWJS82M7jyNIqbdbZHNPT6OmUeW4X5vbFFhsUXOxNxk9dy9L/06K45CeSh31fGKsbBX2T9lQa6PL0hFI+RMYPMdvTBvjctqhXRicW4ek+b/LlB1zx8lHXkdWnkMkRoMssvU73cHTVxF6Oiqv25heiSd52++Kx9Ihkge4dYLqJJBcTzn8Fbd5HpzrJ1QHJUr5uhhnK3Qj26dA4GcoHF8KIpXg5pj4wgbCq6O6t03KZYaJlrQXYVgOP0+6tHLfS5jvFpvHmKv+XdzIqMXv/Cvr8IMl5DhP9xdfFTzCgAA";
    private static final Log log = LogFactory.getLog(ImportPupitriPopupUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton cancelButton;
    protected FileEditor carrouselFile;
    protected JLabel carrouselFileLabel;
    protected Boolean editable;
    protected final ImportPupitriPopupUIHandler handler = new ImportPupitriPopupUIHandler();
    protected ImportPupitriPopupUI importPupitriDialog = this;
    protected Table mainPanel;
    protected FileEditor trunkFile;
    protected JLabel trunkFileLabel;
    protected JButton validateButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    public void open() {
        handler.open();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ImportPupitriPopupUI(TuttiUIContext context) {
        super(context.getMainUI());
            TuttiUIUtil.setApplicationContext(this, context);
            $initialize();
    }

    public ImportPupitriPopupUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI() {
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ImportPupitriPopupUI(Window param0) {
        super(param0);
        $initialize();
    }

    public ImportPupitriPopupUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__validateButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.validate();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancelButton() {
        return cancelButton;
    }

    public FileEditor getCarrouselFile() {
        return carrouselFile;
    }

    public JLabel getCarrouselFileLabel() {
        return carrouselFileLabel;
    }

    public Boolean getEditable() {
        return editable;
    }

    public ImportPupitriPopupUIHandler getHandler() {
        return handler;
    }

    public Table getMainPanel() {
        return mainPanel;
    }

    public FileEditor getTrunkFile() {
        return trunkFile;
    }

    public JLabel getTrunkFileLabel() {
        return trunkFileLabel;
    }

    public JButton getValidateButton() {
        return validateButton;
    }

    public Boolean isEditable() {
        return editable !=null && editable;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setEditable(Boolean editable) {
        Boolean oldValue = this.editable;
        this.editable = editable;
        firePropertyChange(PROPERTY_EDITABLE, oldValue, editable);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToImportPupitriDialog() {
        if (!allComponentsCreated) {
            return;
        }
        add(mainPanel);
    }

    protected void addChildrenToMainPanel() {
        if (!allComponentsCreated) {
            return;
        }
        mainPanel.add(trunkFileLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(trunkFile, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(carrouselFileLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(carrouselFile, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add($JPanel0, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.common.cancel"));
        cancelButton.setToolTipText(_("tutti.common.cancel"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createCarrouselFile() {
        $objectMap.put("carrouselFile", carrouselFile = new FileEditor());
        
        carrouselFile.setName("carrouselFile");
        carrouselFile.setAcceptAllFileFilterUsed(false);
        carrouselFile.setDirectoryEnabled(false);
    }

    protected void createCarrouselFileLabel() {
        $objectMap.put("carrouselFileLabel", carrouselFileLabel = new JLabel());
        
        carrouselFileLabel.setName("carrouselFileLabel");
        carrouselFileLabel.setText(_("tutti.importPupitri.field.carrouselFile"));
    }

    protected void createEditable() {
        $objectMap.put("editable", editable = true);
    }

    protected void createMainPanel() {
        $objectMap.put("mainPanel", mainPanel = new Table());
        
        mainPanel.setName("mainPanel");
    }

    protected void createTrunkFile() {
        $objectMap.put("trunkFile", trunkFile = new FileEditor());
        
        trunkFile.setName("trunkFile");
        trunkFile.setAcceptAllFileFilterUsed(false);
        trunkFile.setDirectoryEnabled(false);
    }

    protected void createTrunkFileLabel() {
        $objectMap.put("trunkFileLabel", trunkFileLabel = new JLabel());
        
        trunkFileLabel.setName("trunkFileLabel");
        trunkFileLabel.setText(_("tutti.importPupitri.field.trunkFile"));
    }

    protected void createValidateButton() {
        $objectMap.put("validateButton", validateButton = new JButton());
        
        validateButton.setName("validateButton");
        validateButton.setText(_("tutti.common.validate"));
        validateButton.setToolTipText(_("tutti.common.validate"));
        validateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validateButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToImportPupitriDialog();
        addChildrenToMainPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(validateButton);
        
        // apply 12 property setters
        trunkFileLabel.setLabelFor(trunkFile);
        trunkFile.setExts(_("tutti.importPupitri.trunkFile.extension"));
        trunkFile.setExtsDescription(_("tutti.importPupitri.trunkFile.extension.description"));
        carrouselFileLabel.setLabelFor(carrouselFile);
        carrouselFile.setExts(_("tutti.importPupitri.carrouselFile.extension"));
        carrouselFile.setExtsDescription(_("tutti.importPupitri.carrouselFile.extension.description"));
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.common.cancel.mnemonic"),'Z'));
        validateButton.setIcon(SwingUtil.createActionIcon("add"));
        validateButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.common.validate.mnemonic"),'Z'));
        // late initializer
        importPupitriDialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("importPupitriDialog", importPupitriDialog);
        createEditable();
        createMainPanel();
        createTrunkFileLabel();
        createTrunkFile();
        createCarrouselFileLabel();
        createCarrouselFile();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCancelButton();
        createValidateButton();
        // inline creation of importPupitriDialog
        setName("importPupitriDialog");
        importPupitriDialog.getContentPane().setLayout(new BorderLayout());
        setTitle(_("tutti.importPupitri.title"));
        setModal(true);
        
        $completeSetup();
        handler.afterInit(this);
    }

}