/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.db;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.TuttiBusinessException;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.config.TuttiPersistenceConfig;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.content.db.CloseDbAction;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import java.io.File;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Version;

public class ImportDbAction
extends AbstractMainUITuttiAction {
    private static final Log log = LogFactory.getLog(ImportDbAction.class);
    protected File importFile;
    protected String jdbcUrl;
    protected boolean updateSchema;
    protected boolean closeDb;
    protected Version dbVersion;
    protected Version applicationVersion;
    protected PersistenceService.ImportStructureType importStructureType;

    public ImportDbAction(MainUIHandler handler) {
        super(handler, true);
        this.setActionDescription(I18n._((String)"tutti.dbManager.action.importDb.tip", (Object[])new Object[0]));
    }

    public void setImportFile(File importFile) {
        this.importFile = importFile;
    }

    @Override
    public boolean prepareAction() throws Exception {
        this.importStructureType = null;
        this.jdbcUrl = null;
        this.applicationVersion = null;
        this.dbVersion = null;
        this.updateSchema = false;
        this.closeDb = false;
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.jdbcUrl = TuttiPersistenceConfig.getInstance().getJdbcUrl();
            if (this.importFile == null) {
                this.importFile = this.chooseFile(I18n._((String)"tutti.dbManager.title.choose.dbImportFile", (Object[])new Object[0]), I18n._((String)"tutti.dbManager.action.chooseDbFile", (Object[])new Object[0]), "^.*\\.zip", I18n._((String)"tutti.common.file.zip", (Object[])new Object[0]));
                if (this.importFile == null) {
                    this.displayWarningMessage(I18n._((String)"tutti.dbManager.title.choose.dbImportFile", (Object[])new Object[0]), I18n._((String)"tutti.dbManager.action.importdb.no.import.file.choosen", (Object[])new Object[0]));
                    doAction = false;
                }
            }
            if (doAction) {
                ProgressionModel progressionModel = new ProgressionModel();
                progressionModel.setTotal(3);
                this.setProgressionModel(progressionModel);
                this.importStructureType = this.getContext().getPersistenceService().checkImportStructure(this.importFile);
            }
        }
        return doAction;
    }

    @Override
    public void releaseAction() {
        this.importFile = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        String message;
        Preconditions.checkNotNull((Object)this.importFile);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import db: " + this.importFile));
        }
        ProgressionModel progressionModel = this.getProgressionModel();
        progressionModel.increments(I18n._((String)"tutti.importDb.step.unzipArchive", (Object[])new Object[0]));
        this.getContext().getPersistenceService().importDb(this.importStructureType, this.importFile);
        progressionModel.increments(I18n._((String)"tutti.importDb.step.openDb", (Object[])new Object[]{this.jdbcUrl}));
        try {
            this.getContext().setDbExist(true);
            this.getContext().setDbLoaded(true);
            ((MainUIHandler)this.getHandler()).reloadPersistenceService();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not open db", (Throwable)e);
            }
            this.getContext().setDbLoaded(false);
            ((MainUIHandler)this.getHandler()).reloadPersistenceService();
            throw new TuttiBusinessException(I18n._((String)"tutti.dbManager.action.importdb.couldNotOpen", (Object[])new Object[0]), (Throwable)e);
        }
        progressionModel.increments(I18n._((String)"tutti.importDb.step.checkSchemaVersion", (Object[])new Object[0]));
        PersistenceService persistenceService = ((MainUIHandler)this.getHandler()).getPersistenceService();
        this.dbVersion = persistenceService.getDbVersion();
        if (log.isInfoEnabled()) {
            log.info((Object)("Detected database version: " + this.dbVersion));
        }
        this.applicationVersion = persistenceService.getApplicationVersion();
        if (log.isInfoEnabled()) {
            log.info((Object)("Detected schema application version:" + this.applicationVersion));
        }
        if (this.dbVersion == null) {
            message = I18n._((String)"tutti.dbManager.action.upgradeDb.schema.version.not.found", (Object[])new Object[0]);
            this.displayWarningMessage(I18n._((String)"tutti.dbManager.title.schema.toupdate", (Object[])new Object[0]), message);
            this.closeDb = true;
        } else if (this.dbVersion.equals((Object)this.applicationVersion)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Database schema is up-to-date at version: " + this.dbVersion));
            }
        } else if (this.dbVersion.compareTo(this.applicationVersion) < 0) {
            boolean continueAction;
            message = I18n._((String)"tutti.dbManager.action.upgradeDb.schema.to.update.message", (Object[])new Object[]{this.dbVersion, this.applicationVersion});
            String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", message, I18n._((String)"tutti.dbManager.action.upgradeDb.schema.to.update.message.help", (Object[])new Object[0]));
            int i = JOptionPane.showConfirmDialog(((MainUIHandler)this.getHandler()).getTopestUI(), htmlMessage, I18n._((String)"tutti.dbManager.title.schema.toupdate", (Object[])new Object[0]), 2, 3);
            boolean bl = continueAction = i == 0;
            if (continueAction) {
                this.updateSchema = true;
            } else {
                this.closeDb = true;
            }
        } else {
            boolean continueAction;
            message = I18n._((String)"tutti.dbManager.action.upgradeDb.schema.too.high", (Object[])new Object[]{this.dbVersion, this.applicationVersion});
            String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", message, I18n._((String)"tutti.dbManager.action.upgradeDb.schema.too.high.help", (Object[])new Object[0]));
            int i = JOptionPane.showConfirmDialog(((MainUIHandler)this.getHandler()).getTopestUI(), htmlMessage, I18n._((String)"tutti.dbManager.title.schema.toupdate", (Object[])new Object[0]), 2, 3);
            boolean bl = continueAction = i == 0;
            if (!continueAction) {
                this.closeDb = true;
            }
        }
        if (this.closeDb) {
            progressionModel.increments(I18n._((String)"tutti.importDb.step.closeDb", (Object[])new Object[0]));
            TuttiActionHelper.runInternalAction(this.getHandler(), CloseDbAction.class);
            return;
        }
        if (this.updateSchema) {
            progressionModel.adaptTotal(progressionModel.getTotal() + 2);
            message = I18n._((String)"tutti.importDb.step.will.migrateSchema", (Object[])new Object[]{this.dbVersion, this.applicationVersion});
            progressionModel.increments(message);
            this.sendMessage(message);
            ((MainUIHandler)this.getHandler()).getPersistenceService().updateSchema();
            this.sendMessage(I18n._((String)"tutti.flash.info.db.schema.updated", (Object[])new Object[]{this.dbVersion, this.applicationVersion}));
        }
        message = I18n._((String)"tutti.importDb.step.check.dbContext", (Object[])new Object[]{this.dbVersion, this.applicationVersion});
        progressionModel.increments(message);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Check db context");
        }
        this.getContext().checkDbContext();
    }

    @Override
    public void postSuccessAction() {
        ((MainUIHandler)this.handler).reloadDbManagerText();
        super.postSuccessAction();
        if (this.closeDb) {
            this.sendMessage(I18n._((String)"tutti.flash.info.db.imported.but.closed", (Object[])new Object[]{this.jdbcUrl}));
        } else {
            this.sendMessage(I18n._((String)"tutti.flash.info.db.imported", (Object[])new Object[]{this.jdbcUrl}));
        }
        ((MainUI)this.getUI()).getHandler().changeTitle();
    }

    @Override
    public void postFailedAction(Throwable error) {
        ((MainUIHandler)this.handler).reloadDbManagerText();
        super.postFailedAction(error);
    }
}

