/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.action.DelayedPostInsertIdentifier;
import org.hibernate.action.EntityUpdateAction;
import org.hibernate.classic.Validatable;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.Nullability;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.engine.Versioning;
import org.hibernate.event.EventSource;
import org.hibernate.event.FlushEntityEvent;
import org.hibernate.event.FlushEntityEventListener;
import org.hibernate.event.def.DirtyCollectionSearchVisitor;
import org.hibernate.event.def.FlushVisitor;
import org.hibernate.event.def.WrapVisitor;
import org.hibernate.intercept.FieldInterceptionHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFlushEntityEventListener
implements FlushEntityEventListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultFlushEntityEventListener.class);

    public void checkId(Object object, EntityPersister persister, Serializable id, EntityMode entityMode, SessionImplementor session) throws HibernateException {
        if (id != null && id instanceof DelayedPostInsertIdentifier) {
            return;
        }
        if (persister.canExtractIdOutOfEntity()) {
            Serializable oid = persister.getIdentifier(object, session);
            if (id == null) {
                throw new AssertionFailure("null id in " + persister.getEntityName() + " entry (don't flush the Session after an exception occurs)");
            }
            if (!persister.getIdentifierType().isEqual(id, oid, entityMode, session.getFactory())) {
                throw new HibernateException("identifier of an instance of " + persister.getEntityName() + " was altered from " + id + " to " + oid);
            }
        }
    }

    private void checkNaturalId(EntityPersister persister, EntityEntry entry, Object[] current, Object[] loaded, EntityMode entityMode, SessionImplementor session) {
        if (persister.hasNaturalIdentifier() && entry.getStatus() != Status.READ_ONLY) {
            Object[] snapshot = null;
            Type[] types = persister.getPropertyTypes();
            int[] props = persister.getNaturalIdentifierProperties();
            boolean[] updateable = persister.getPropertyUpdateability();
            for (int i = 0; i < props.length; ++i) {
                Object loadedVal;
                int prop = props[i];
                if (updateable[prop]) continue;
                if (loaded == null) {
                    if (snapshot == null) {
                        snapshot = session.getPersistenceContext().getNaturalIdSnapshot(entry.getId(), persister);
                    }
                    loadedVal = snapshot[i];
                } else {
                    loadedVal = loaded[prop];
                }
                if (types[prop].isEqual(current[prop], loadedVal, entityMode)) continue;
                throw new HibernateException("immutable natural identifier of an instance of " + persister.getEntityName() + " was altered");
            }
        }
    }

    public void onFlushEntity(FlushEntityEvent event) throws HibernateException {
        Object entity = event.getEntity();
        EntityEntry entry = event.getEntityEntry();
        EventSource session = event.getSession();
        EntityPersister persister = entry.getPersister();
        Status status = entry.getStatus();
        EntityMode entityMode = session.getEntityMode();
        Type[] types = persister.getPropertyTypes();
        boolean mightBeDirty = entry.requiresDirtyCheck(entity);
        Object[] values = this.getValues(entity, entry, entityMode, mightBeDirty, session);
        event.setPropertyValues(values);
        boolean substitute = this.wrapCollections(session, persister, types, values);
        if (this.isUpdateNecessary(event, mightBeDirty)) {
            boolean bl = substitute = this.scheduleUpdate(event) || substitute;
        }
        if (status != Status.DELETED) {
            if (substitute) {
                persister.setPropertyValues(entity, values, entityMode);
            }
            if (persister.hasCollections()) {
                new FlushVisitor(session, entity).processEntityPropertyValues(values, types);
            }
        }
    }

    private Object[] getValues(Object entity, EntityEntry entry, EntityMode entityMode, boolean mightBeDirty, SessionImplementor session) {
        Object[] values;
        Object[] loadedState = entry.getLoadedState();
        Status status = entry.getStatus();
        EntityPersister persister = entry.getPersister();
        if (status == Status.DELETED) {
            values = entry.getDeletedState();
        } else if (!mightBeDirty && loadedState != null) {
            values = loadedState;
        } else {
            this.checkId(entity, persister, entry.getId(), entityMode, session);
            values = persister.getPropertyValues(entity, entityMode);
            this.checkNaturalId(persister, entry, values, loadedState, entityMode, session);
        }
        return values;
    }

    private boolean wrapCollections(EventSource session, EntityPersister persister, Type[] types, Object[] values) {
        if (persister.hasCollections()) {
            WrapVisitor visitor = new WrapVisitor(session);
            visitor.processEntityPropertyValues(values, types);
            return visitor.isSubstitutionRequired();
        }
        return false;
    }

    private boolean isUpdateNecessary(FlushEntityEvent event, boolean mightBeDirty) {
        Status status = event.getEntityEntry().getStatus();
        if (mightBeDirty || status == Status.DELETED) {
            this.dirtyCheck(event);
            if (this.isUpdateNecessary(event)) {
                return true;
            }
            FieldInterceptionHelper.clearDirty(event.getEntity());
            return false;
        }
        return this.hasDirtyCollections(event, event.getEntityEntry().getPersister(), status);
    }

    private boolean scheduleUpdate(FlushEntityEvent event) {
        EntityEntry entry = event.getEntityEntry();
        EventSource session = event.getSession();
        Object entity = event.getEntity();
        Status status = entry.getStatus();
        EntityMode entityMode = session.getEntityMode();
        EntityPersister persister = entry.getPersister();
        Object[] values = event.getPropertyValues();
        if (log.isTraceEnabled()) {
            if (status == Status.DELETED) {
                if (!persister.isMutable()) {
                    log.trace("Updating immutable, deleted entity: " + MessageHelper.infoString(persister, entry.getId(), session.getFactory()));
                } else if (!entry.isModifiableEntity()) {
                    log.trace("Updating non-modifiable, deleted entity: " + MessageHelper.infoString(persister, entry.getId(), session.getFactory()));
                } else {
                    log.trace("Updating deleted entity: " + MessageHelper.infoString(persister, entry.getId(), session.getFactory()));
                }
            } else {
                log.trace("Updating entity: " + MessageHelper.infoString(persister, entry.getId(), session.getFactory()));
            }
        }
        boolean intercepted = !entry.isBeingReplicated() ? this.handleInterception(event) : false;
        this.validate(entity, persister, status, entityMode);
        Object nextVersion = this.getNextVersion(event);
        int[] dirtyProperties = event.getDirtyProperties();
        if (event.isDirtyCheckPossible() && dirtyProperties == null) {
            if (!intercepted && !event.hasDirtyCollection()) {
                throw new AssertionFailure("dirty, but no dirty properties");
            }
            dirtyProperties = ArrayHelper.EMPTY_INT_ARRAY;
        }
        new Nullability(session).checkNullability(values, persister, true);
        session.getActionQueue().addAction(new EntityUpdateAction(entry.getId(), values, dirtyProperties, event.hasDirtyCollection(), status == Status.DELETED && !entry.isModifiableEntity() ? persister.getPropertyValues(entity, entityMode) : entry.getLoadedState(), entry.getVersion(), nextVersion, entity, entry.getRowId(), persister, session));
        return intercepted;
    }

    protected void validate(Object entity, EntityPersister persister, Status status, EntityMode entityMode) {
        if (status == Status.MANAGED && persister.implementsValidatable(entityMode)) {
            ((Validatable)entity).validate();
        }
    }

    protected boolean handleInterception(FlushEntityEvent event) {
        Object[] values;
        EventSource session = event.getSession();
        EntityEntry entry = event.getEntityEntry();
        EntityPersister persister = entry.getPersister();
        Object entity = event.getEntity();
        boolean intercepted = this.invokeInterceptor(session, entity, entry, values = event.getPropertyValues(), persister);
        if (intercepted && event.isDirtyCheckPossible() && !event.isDirtyCheckHandledByInterceptor()) {
            int[] dirtyProperties = event.hasDatabaseSnapshot() ? persister.findModified(event.getDatabaseSnapshot(), values, entity, session) : persister.findDirty(values, entry.getLoadedState(), entity, session);
            event.setDirtyProperties(dirtyProperties);
        }
        return intercepted;
    }

    protected boolean invokeInterceptor(SessionImplementor session, Object entity, EntityEntry entry, Object[] values, EntityPersister persister) {
        return session.getInterceptor().onFlushDirty(entity, entry.getId(), values, entry.getLoadedState(), persister.getPropertyNames(), persister.getPropertyTypes());
    }

    private Object getNextVersion(FlushEntityEvent event) throws HibernateException {
        EntityEntry entry = event.getEntityEntry();
        EntityPersister persister = entry.getPersister();
        if (persister.isVersioned()) {
            Object[] values = event.getPropertyValues();
            if (entry.isBeingReplicated()) {
                return Versioning.getVersion(values, persister);
            }
            int[] dirtyProperties = event.getDirtyProperties();
            boolean isVersionIncrementRequired = this.isVersionIncrementRequired(event, entry, persister, dirtyProperties);
            Object nextVersion = isVersionIncrementRequired ? Versioning.increment(entry.getVersion(), persister.getVersionType(), event.getSession()) : entry.getVersion();
            Versioning.setVersion(values, nextVersion, persister);
            return nextVersion;
        }
        return null;
    }

    private boolean isVersionIncrementRequired(FlushEntityEvent event, EntityEntry entry, EntityPersister persister, int[] dirtyProperties) {
        boolean isVersionIncrementRequired = entry.getStatus() != Status.DELETED && (dirtyProperties == null || Versioning.isVersionIncrementRequired(dirtyProperties, event.hasDirtyCollection(), persister.getPropertyVersionability()));
        return isVersionIncrementRequired;
    }

    protected final boolean isUpdateNecessary(FlushEntityEvent event) throws HibernateException {
        EntityPersister persister = event.getEntityEntry().getPersister();
        Status status = event.getEntityEntry().getStatus();
        if (!event.isDirtyCheckPossible()) {
            return true;
        }
        int[] dirtyProperties = event.getDirtyProperties();
        if (dirtyProperties != null && dirtyProperties.length != 0) {
            return true;
        }
        return this.hasDirtyCollections(event, persister, status);
    }

    private boolean hasDirtyCollections(FlushEntityEvent event, EntityPersister persister, Status status) {
        if (this.isCollectionDirtyCheckNecessary(persister, status)) {
            DirtyCollectionSearchVisitor visitor = new DirtyCollectionSearchVisitor(event.getSession(), persister.getPropertyVersionability());
            visitor.processEntityPropertyValues(event.getPropertyValues(), persister.getPropertyTypes());
            boolean hasDirtyCollections = visitor.wasDirtyCollectionFound();
            event.setHasDirtyCollection(hasDirtyCollections);
            return hasDirtyCollections;
        }
        return false;
    }

    private boolean isCollectionDirtyCheckNecessary(EntityPersister persister, Status status) {
        return (status == Status.MANAGED || status == Status.READ_ONLY) && persister.isVersioned() && persister.hasCollections();
    }

    protected void dirtyCheck(FlushEntityEvent event) throws HibernateException {
        boolean cannotDirtyCheck;
        boolean interceptorHandledDirtyCheck;
        Object entity = event.getEntity();
        Object[] values = event.getPropertyValues();
        EventSource session = event.getSession();
        EntityEntry entry = event.getEntityEntry();
        EntityPersister persister = entry.getPersister();
        Serializable id = entry.getId();
        Object[] loadedState = entry.getLoadedState();
        int[] dirtyProperties = session.getInterceptor().findDirty(entity, id, values, loadedState, persister.getPropertyNames(), persister.getPropertyTypes());
        event.setDatabaseSnapshot(null);
        if (dirtyProperties == null) {
            interceptorHandledDirtyCheck = false;
            boolean bl = cannotDirtyCheck = loadedState == null;
            if (!cannotDirtyCheck) {
                dirtyProperties = persister.findDirty(values, loadedState, entity, session);
            } else if (entry.getStatus() == Status.DELETED && !event.getEntityEntry().isModifiableEntity()) {
                if (values != entry.getDeletedState()) {
                    throw new IllegalStateException("Entity has status Status.DELETED but values != entry.getDeletedState");
                }
                Object[] currentState = persister.getPropertyValues(event.getEntity(), event.getSession().getEntityMode());
                dirtyProperties = persister.findDirty(entry.getDeletedState(), currentState, entity, session);
                cannotDirtyCheck = false;
            } else {
                Object[] databaseSnapshot = this.getDatabaseSnapshot(session, persister, id);
                if (databaseSnapshot != null) {
                    dirtyProperties = persister.findModified(databaseSnapshot, values, entity, session);
                    cannotDirtyCheck = false;
                    event.setDatabaseSnapshot(databaseSnapshot);
                }
            }
        } else {
            cannotDirtyCheck = false;
            interceptorHandledDirtyCheck = true;
        }
        this.logDirtyProperties(id, dirtyProperties, persister);
        event.setDirtyProperties(dirtyProperties);
        event.setDirtyCheckHandledByInterceptor(interceptorHandledDirtyCheck);
        event.setDirtyCheckPossible(!cannotDirtyCheck);
    }

    private void logDirtyProperties(Serializable id, int[] dirtyProperties, EntityPersister persister) {
        if (log.isTraceEnabled() && dirtyProperties != null && dirtyProperties.length > 0) {
            String[] allPropertyNames = persister.getPropertyNames();
            String[] dirtyPropertyNames = new String[dirtyProperties.length];
            for (int i = 0; i < dirtyProperties.length; ++i) {
                dirtyPropertyNames[i] = allPropertyNames[dirtyProperties[i]];
            }
            log.trace("Found dirty properties [{}] : {}", (Object)MessageHelper.infoString(persister.getEntityName(), id), (Object)dirtyPropertyNames);
        }
    }

    private Object[] getDatabaseSnapshot(SessionImplementor session, EntityPersister persister, Serializable id) {
        if (persister.isSelectBeforeUpdateRequired()) {
            Object[] snapshot = session.getPersistenceContext().getDatabaseSnapshot(id, persister);
            if (snapshot == null) {
                if (session.getFactory().getStatistics().isStatisticsEnabled()) {
                    session.getFactory().getStatisticsImplementor().optimisticFailure(persister.getEntityName());
                }
                throw new StaleObjectStateException(persister.getEntityName(), id);
            }
            return snapshot;
        }
        EntityKey entityKey = new EntityKey(id, persister, session.getEntityMode());
        return session.getPersistenceContext().getCachedDatabaseSnapshot(entityKey);
    }
}

