/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.cruise;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.catches.ValidateCruiseOperationsService;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseFishingOperationAction;
import fr.ifremer.tutti.ui.swing.content.cruise.ValidateCruiseUI;
import fr.ifremer.tutti.ui.swing.content.cruise.ValidateCruiseUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.CloseableUI;
import fr.ifremer.tutti.ui.swing.util.RemoveablePropertyChangeListener;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionUIModel;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.NuitonValidatorResult;
import org.nuiton.validator.NuitonValidatorScope;

public class ValidateCruiseUIHandler
extends AbstractTuttiUIHandler<ValidateCruiseUIModel, ValidateCruiseUI>
implements CloseableUI {
    private static final Log log = LogFactory.getLog(ValidateCruiseUIHandler.class);
    private final ValidateCruiseOperationsService validationService;
    protected EditCruiseFishingOperationAction editFishingOperationAction;

    public ValidateCruiseUIHandler(TuttiUI parentUi, ValidateCruiseUI ui) {
        super(((AbstractTuttiUIHandler)parentUi.getHandler()).getContext(), ui);
        this.validationService = this.context.getValidateCruiseOperationsService();
    }

    @Override
    public void beforeInitUI() {
        ValidateCruiseUIModel model = new ValidateCruiseUIModel();
        ProgressionModel progressionModel = new ProgressionModel();
        TuttiActionUIModel actionUIModel = this.context.getActionUI().getModel();
        actionUIModel.setProgressionModel(progressionModel);
        model.setValidator(this.validationService.validateCruiseOperations(progressionModel));
        actionUIModel.setProgressionModel(null);
        model.addPropertyChangeListener("selectedFishingOperation", new RemoveablePropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FishingOperation operation = (FishingOperation)evt.getNewValue();
                ValidateCruiseUIHandler.this.editFishingOperationAction.setFishingOperation(operation);
                TuttiActionHelper.runAction(ValidateCruiseUIHandler.this.editFishingOperationAction);
            }
        });
        ((ValidateCruiseUI)this.ui).setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        this.editFishingOperationAction = TuttiActionHelper.createLogicAction(this, EditCruiseFishingOperationAction.class);
        ((ValidateCruiseUI)this.ui).getOperationPanel().getModel().setSelectedFishingOperation(null);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        Map<FishingOperation, NuitonValidatorResult> validator = ((ValidateCruiseUIModel)((Object)this.getModel())).getValidator();
        for (FishingOperation operation : validator.keySet()) {
            NuitonValidatorResult result = validator.get(operation);
            OperationTreeNode node = new OperationTreeNode(operation, result);
            root.add(node);
        }
        DefaultTreeModel model = new DefaultTreeModel(root);
        JTree navigation = ((ValidateCruiseUI)this.ui).getNavigation();
        navigation.setModel(model);
        navigation.setCellRenderer(new ValidationTreeCellRenderer());
        SwingUtil.expandTree((JTree)navigation);
        SwingUtil.addExpandOnClickListener((JTree)navigation);
        FishingOperationsUI operationPanel = ((ValidateCruiseUI)this.ui).getOperationPanel();
        operationPanel.getTopPanel().setVisible(false);
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        this.clearValidators();
    }

    @Override
    public SwingValidator<ValidateCruiseUIModel> getValidator() {
        return null;
    }

    @Override
    protected JComponent getComponentToFocus() {
        return null;
    }

    @Override
    public boolean quitUI() {
        return true;
    }

    public void autoSelectNode(MouseEvent e, JPopupMenu popup) {
        Object o;
        JTree navigation = (JTree)e.getSource();
        boolean rightClick = SwingUtilities.isRightMouseButton(e);
        if (rightClick) {
            TreePath path = navigation.getPathForLocation(e.getX(), e.getY());
            if (path == null) {
                navigation.clearSelection();
            } else {
                navigation.setSelectionPath(path);
            }
            popup.show(navigation, e.getX(), e.getY());
        }
        TreePath selectionPath = navigation.getSelectionPath();
        FishingOperation operation = null;
        if (selectionPath != null && selectionPath.getPathCount() > 1 && (o = selectionPath.getPathComponent(1)) != null) {
            operation = (FishingOperation)((OperationTreeNode)o).getUserObject();
        }
        ((ValidateCruiseUIModel)((Object)this.getModel())).setSelectedFishingOperation(operation);
    }

    public void openNodeMenu(KeyEvent e, JPopupMenu popup) {
        JTree navigation;
        TreePath path;
        if (e.getKeyCode() == 525 && (path = (navigation = (JTree)e.getSource()).getSelectionPath()) != null) {
            Rectangle r = navigation.getPathBounds(path);
            Point p = new Point(r.x + r.width / 2, r.y + r.height);
            popup.show(navigation, p.x, p.y);
        }
    }

    protected void updateCurrentOperationNode(NuitonValidatorResult validationResult) {
        JTree navigation = ((ValidateCruiseUI)this.ui).getNavigation();
        TreePath selectionPath = navigation.getSelectionPath();
        Preconditions.checkArgument((selectionPath.getPathCount() > 1 ? 1 : 0) != 0);
        OperationTreeNode operationNode = (OperationTreeNode)selectionPath.getPathComponent(1);
        operationNode.removeAllChildren();
        operationNode.createChildren(validationResult);
        DefaultTreeModel treeModel = (DefaultTreeModel)navigation.getModel();
        treeModel.reload(operationNode);
        navigation.setSelectionPath(selectionPath);
    }

    protected class MessageTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        protected NuitonValidatorScope scope;

        public MessageTreeNode(NuitonValidatorScope scope, String message) {
            super(message);
            this.scope = scope;
        }

        public NuitonValidatorScope getScope() {
            return this.scope;
        }
    }

    protected class OperationTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;

        public OperationTreeNode(FishingOperation operation, NuitonValidatorResult validationResult) {
            super(operation);
            this.setAllowsChildren(true);
            this.createChildren(validationResult);
        }

        public void createChildren(NuitonValidatorResult validationResult) {
            int messageNb = 0;
            messageNb += this.addMessages(NuitonValidatorScope.ERROR, validationResult.getMessagesForScope(NuitonValidatorScope.ERROR));
            if ((messageNb += this.addMessages(NuitonValidatorScope.WARNING, validationResult.getMessagesForScope(NuitonValidatorScope.WARNING))) == 0) {
                this.addMessages(NuitonValidatorScope.INFO, Lists.newArrayList((Object[])new String[]{I18n._((String)"tutti.validator.info.operation.noError", (Object[])new Object[0])}));
            }
        }

        protected int addMessages(NuitonValidatorScope scope, List<String> messages) {
            HashSet messageSet = Sets.newHashSet(messages);
            for (String message : messageSet) {
                MessageTreeNode child = new MessageTreeNode(scope, message);
                this.add(child);
            }
            return messages.size();
        }
    }

    protected class ValidationTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        protected ValidationTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value != null) {
                if (value instanceof OperationTreeNode) {
                    OperationTreeNode node = (OperationTreeNode)value;
                    String text = ValidateCruiseUIHandler.this.getDecorator(FishingOperation.class, null).toString(node.getUserObject());
                    label.setText(text);
                    label.setToolTipText(text);
                } else if (value instanceof MessageTreeNode) {
                    MessageTreeNode node = (MessageTreeNode)value;
                    String text = I18n._((String)String.valueOf(node.getUserObject()), (Object[])new Object[0]);
                    label.setText(text);
                    label.setToolTipText(text);
                    String iconName = node.getScope().toString().toLowerCase();
                    label.setIcon(SwingUtil.createImageIcon((String)(iconName + ".png")));
                }
            }
            return label;
        }
    }
}

