package fr.ifremer.tutti.ui.swing.content.report;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.GoToPreviousScreenAction;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.FileEditor;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class ReportUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<ReportUIModel, ReportUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_GENERATE_BUTTON_ENABLED = "generateButton.enabled";
    public static final String BINDING_INPUT_FILE_FIELD_SELECTED_FILE = "inputFileField.selectedFile";
    public static final String BINDING_OUTPUT_FILE_FIELD_SELECTED_FILE = "outputFileField.selectedFile";
    public static final String BINDING_REPORT_COMBO_BOX_SELECTED_ITEM = "reportComboBox.selectedItem";
    public static final String BINDING_SHOW_OUTPUT_FILE_BUTTON_ENABLED = "showOutputFileButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVXTU8kRRguZpmBAVYW2GVZBWX52ICbbVy/sglmXWbdWSAgBEazkQPWTNdArT1dbXU1NJlg/An+BL17MfHmyXjw7MGL8ahHYzx4Nb5V3dM9NdPdA1kSGqb6fZ/346l63ppv/0J5l6Pbz7HvG9yzBW0QY3Pt2bOd6nNSEx8Qt8apIxhHwU9fDuUO0LAZrbsCzR9sSfeV0H3lMWs4zCZ2m/fqFhpyxZlF3GNChEAzukfNdVf2o9ervuPxFmqUVBLq1//8nfvK/PKbHEK+A9mNQymzvbziSvq3UI6aAo1DpBO8YmH7CNLg1D6CfK/KtccWdt0PcYN8jr5AA1uo4GAOYALNXbxkhaH8fUeglzhxGBcV5uxim1gC3a9zg9Y5aRBuCE8IanjUcE8hCaPGbAGYRuBi7Kk/H204joIrCDRwjG3TIlygB5dGWQ9cY7B8g5kyoXcvDbUtHWOgQpWzz2RSy+lIFflxHbxKyjZ2Lp5gi5oYGijQXY3K6EUIsS+fH7cWY4T+OuMNgaY05zAqrlqKymJkPRzUsoWrsvZxSbofWm+qRWk3FZmH9AHfVVZivkDvJIQhJpVpVgm2jRI8ytQShMvYLb8OUGo7ngArEkWcSbMoU2LBll1IDyutnqh/dYxR5okeYdpMwt2pN0Qtprqo1OTyonwsRSY3Y5O1mqDMrjBmVTEQfF1Dl8slzHXn6+4xO92JAEqwb2ATognNM1iVHvcix8GFIN035OfX9aSHaxZzSez1pny8FXf7iNjAl0iw4OgVrfOgXEasXLG09B2gPPdgGTbiQbfY7cGrQOamOmROAqq3/01O/PrD79+XW9o2AbFvJJq2STNojsOZA4ePytCjgbB5glor29hZPUBFl1ig60q3pxMS2w9fQ3IQb0y6G9LdWMfuMUDkB3778afJT3+5gnJlNGQxbJaxtN9ARXHMoQvMMn3n/Ucqo5HTQXheg98cHEt5HECymkpmzuGkS2b3iCvnQb/gHvGhHdMJ7YhyqhZ//ndi/7tHrZb0QYq3Us3jtuQ/QQVqW9QmSvBDLU8U+GHHJZ7JYs1OUnEEOj6ZfLBDGXqonqWuPvTB5joMKNixy6zmAQ2Fpiz+3Peky7oqS/63KaMMbVaIL9TB6o2c0NAkyFgfekACacU6UCxkgTAf6tgCbHS1yrhJ+C6mMAzM1np3rPSD7/SuJX94DMNBoBvNuWByhCNHrs4l9KprsPaK0Q8KYUkZLMtJc62p6/q57CB0XqBbWvi6ZCL8ADIioJ4KdSrKcibV0hBwI4hKmusoSbNMr699UPUq7opAI8EuI+aGIDANJ4JjZxwREUztpWWocTAUizPYha2iRg+jQRsOxdnm4VJ6ynPLWXTE5+JydOjzLqZjOiGPyLaTkdksY52UxURSYuOMfacP716F5tqoCXKejKnZaEEpdrqZmE9hIkohjQy9nZcjY6zZMeJjNpK2fGzcScftTGudjzuJfLRZpxPSec+5PCM3Y0bim0cKJQsplMRJpHDSeXHqlWYeZiexpRSD5k6HGVI3TvCJT13hqjSHsJLbDXlfR0U44va9uqpshN5/YG/bpMFsWoMLtpZ44GToFy6jEVnrbN65gK9G6d0OSpNd0nlNvAn26loh2qsvJwWvYbsmWdQaVmitjhwqn2B2SR18yipsl5MTyjx3v8YJsddCHHk7OO/q73x6zNS+vprho/VzPrmfoWnGIGm7/PZq30D7phuLNp361qV2WqIsh5m0btEd7R2M1zsaPN18Gr4KZlR2cxezYqa2dzbTK3MmdBpnzAT9C8QF7jsFC5+BIIDre6AueLZKbRO+2jzsQu+Tz6ELIA7K+3blzFE32z+TcV7riSOX/8hAWH5hBOOFEd4GhP8BYzIcvsgSAAA=";
    private static final Log log = LogFactory.getLog(ReportUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton closeButton;
    protected Table form;
    protected JButton generateButton;
    protected ReportUIHandler handler;
    @ValidatorField( validatorId = "validator",  propertyName = "inputFile",  editorName = "inputFileField")
    protected FileEditor inputFileField;
    protected JLabel inputFileLabel;
    protected ReportUIModel model;
    protected JToolBar outputFileActionToolbar;
    @ValidatorField( validatorId = "validator",  propertyName = "outputFile",  editorName = "outputFileField")
    protected FileEditor outputFileField;
    protected JLabel outputFileLabel;
    protected JPanel outputFilePanel;
    @ValidatorField( validatorId = "validator",  propertyName = "report",  editorName = "reportComboBox")
    protected BeanFilterableComboBox<File> reportComboBox;
    protected JLabel reportLabel;
    protected ReportUI reportTopPanel = this;
    protected JButton showOutputFileButton;
    @Validator( validatorId = "validator")
    protected SwingValidator<ReportUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
          protected void $afterCompleteSetup() {
              handler.afterInitUI();
          }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ReportUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
                  ReportUIHandler handler = new ReportUIHandler(parentUI, this);
                  setContextValue(handler);
                  handler.beforeInitUI();
            $initialize();
    }

    public ReportUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReportUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ReportUI() {
        $initialize();
    }

    public ReportUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ReportUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ReportUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ReportUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public ReportUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__inputFileField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setFile(event, "inputFile");
    }

    public void doActionPerformed__on__outputFileField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setFile(event, "outputFile");
    }

    public void doActionPerformed__on__showOutputFileButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showReport();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCloseButton() {
        return closeButton;
    }

    public Table getForm() {
        return form;
    }

    public JButton getGenerateButton() {
        return generateButton;
    }

    public ReportUIHandler getHandler() {
        return handler;
    }

    public FileEditor getInputFileField() {
        return inputFileField;
    }

    public JLabel getInputFileLabel() {
        return inputFileLabel;
    }

    public ReportUIModel getModel() {
        return model;
    }

    public JToolBar getOutputFileActionToolbar() {
        return outputFileActionToolbar;
    }

    public FileEditor getOutputFileField() {
        return outputFileField;
    }

    public JLabel getOutputFileLabel() {
        return outputFileLabel;
    }

    public JPanel getOutputFilePanel() {
        return outputFilePanel;
    }

    public BeanFilterableComboBox<File> getReportComboBox() {
        return reportComboBox;
    }

    public JLabel getReportLabel() {
        return reportLabel;
    }

    public JButton getShowOutputFileButton() {
        return showOutputFileButton;
    }

    public SwingValidator<ReportUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToForm() {
        if (!allComponentsCreated) {
            return;
        }
        form.add(reportLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(reportComboBox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(inputFileLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(inputFileField), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(outputFileLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(outputFilePanel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add($JPanel0, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 15, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToOutputFileActionToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        outputFileActionToolbar.add(showOutputFileButton);
    }

    protected void addChildrenToOutputFilePanel() {
        if (!allComponentsCreated) {
            return;
        }
        outputFilePanel.add(SwingUtil.boxComponentWithJxLayer(outputFileField), BorderLayout.CENTER);
        outputFilePanel.add(outputFileActionToolbar, BorderLayout.EAST);
    }

    protected void addChildrenToReportTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(form);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.report.help"));
    }

    protected void createCloseButton() {
        $objectMap.put("closeButton", closeButton = new JButton());
        
        closeButton.setName("closeButton");
        closeButton.setText(_("tutti.report.action.cancel"));
        closeButton.setToolTipText(_("tutti.report.action.cancel.tip"));
        closeButton.putClientProperty("help", "tutti.report.action.cancel.help");
        closeButton.putClientProperty("tuttiAction", GoToPreviousScreenAction.class);
    }

    protected void createForm() {
        $objectMap.put("form", form = new Table());
        
        form.setName("form");
    }

    protected void createGenerateButton() {
        $objectMap.put("generateButton", generateButton = new JButton());
        
        generateButton.setName("generateButton");
        generateButton.setText(_("tutti.report.action.generate"));
        generateButton.setToolTipText(_("tutti.report.action.generate.tip"));
        generateButton.putClientProperty("help", "tutti.report.action.generate.help");
        generateButton.putClientProperty("tuttiAction", GenerateReportAction.class);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(ReportUIHandler.class));
    }

    protected void createInputFileField() {
        $objectMap.put("inputFileField", inputFileField = new FileEditor());
        
        inputFileField.setName("inputFileField");
        inputFileField.setShowReset(true);
        inputFileField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__inputFileField"));
        inputFileField.putClientProperty("validatorLabel", _("tutti.report.field.inputFile"));
    }

    protected void createInputFileLabel() {
        $objectMap.put("inputFileLabel", inputFileLabel = new JLabel());
        
        inputFileLabel.setName("inputFileLabel");
        inputFileLabel.setText(_("tutti.report.field.inputFile"));
        inputFileLabel.setToolTipText(_("tutti.report.field.inputFile.tip"));
        inputFileLabel.putClientProperty("help", "tutti.report.field.inputFile.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(ReportUIModel.class));
    }

    protected void createOutputFileActionToolbar() {
        $objectMap.put("outputFileActionToolbar", outputFileActionToolbar = new JToolBar());
        
        outputFileActionToolbar.setName("outputFileActionToolbar");
        outputFileActionToolbar.setLayout(new GridLayout());
        outputFileActionToolbar.setFloatable(false);
        outputFileActionToolbar.setBorderPainted(false);
    }

    protected void createOutputFileField() {
        $objectMap.put("outputFileField", outputFileField = new FileEditor());
        
        outputFileField.setName("outputFileField");
        outputFileField.setShowReset(true);
        outputFileField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__outputFileField"));
        outputFileField.putClientProperty("validatorLabel", _("tutti.report.field.outputFile"));
    }

    protected void createOutputFileLabel() {
        $objectMap.put("outputFileLabel", outputFileLabel = new JLabel());
        
        outputFileLabel.setName("outputFileLabel");
        outputFileLabel.setText(_("tutti.report.field.outputFile"));
        outputFileLabel.setToolTipText(_("tutti.report.field.outputFile.tip"));
        outputFileLabel.putClientProperty("help", "tutti.report.field.outputFile.help");
    }

    protected void createOutputFilePanel() {
        $objectMap.put("outputFilePanel", outputFilePanel = new JPanel());
        
        outputFilePanel.setName("outputFilePanel");
        outputFilePanel.setLayout(new BorderLayout());
    }

    protected void createReportComboBox() {
        $objectMap.put("reportComboBox", reportComboBox = new BeanFilterableComboBox<File>(this));
        
        reportComboBox.setName("reportComboBox");
        reportComboBox.setProperty("report");
        reportComboBox.setShowReset(true);
        reportComboBox.putClientProperty("validatorLabel", _("tutti.report.field.report"));
    }

    protected void createReportLabel() {
        $objectMap.put("reportLabel", reportLabel = new JLabel());
        
        reportLabel.setName("reportLabel");
        reportLabel.setText(_("tutti.report.field.report"));
        reportLabel.setToolTipText(_("tutti.report.field.report.tip"));
        reportLabel.putClientProperty("help", "tutti.report.field.report.help");
    }

    protected void createShowOutputFileButton() {
        $objectMap.put("showOutputFileButton", showOutputFileButton = new JButton());
        
        showOutputFileButton.setName("showOutputFileButton");
        showOutputFileButton.setToolTipText(_("tutti.report.action.showOutputFile.tip"));
        showOutputFileButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__showOutputFileButton"));
        showOutputFileButton.putClientProperty("help", "tutti.report.action.showOutputFile.help");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(ReportUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToReportTopPanel();
        addChildrenToValidator();
        addChildrenToForm();
        addChildrenToOutputFilePanel();
        addChildrenToOutputFileActionToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(closeButton);
        $JPanel0.add(generateButton);
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 15 property setters
        reportComboBox.setBeanType(File.class);
        reportLabel.setLabelFor(reportComboBox);
        reportComboBox.setBean(model);
        inputFileLabel.setLabelFor(inputFileField);
        outputFileLabel.setLabelFor(outputFileField);
        showOutputFileButton.setIcon(SwingUtil.createActionIcon("open-file"));
        showOutputFileButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.report.action.showOutputFile.mnemonic"),'Z'));
        closeButton.setIcon(SwingUtil.createActionIcon("cancel"));
        closeButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.report.action.cancel.mnemonic"),'Z'));
        generateButton.setIcon(SwingUtil.createActionIcon("generate"));
        generateButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.report.action.generate.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, reportTopPanel, "tutti.report.help");
        registerHelpId(_broker, reportLabel, "tutti.report.field.report.help");
        registerHelpId(_broker, inputFileLabel, "tutti.report.field.inputFile.help");
        registerHelpId(_broker, outputFileLabel, "tutti.report.field.outputFile.help");
        registerHelpId(_broker, showOutputFileButton, "tutti.report.action.showOutputFile.help");
        registerHelpId(_broker, closeButton, "tutti.report.action.cancel.help");
        registerHelpId(_broker, generateButton, "tutti.report.action.generate.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("reportTopPanel", reportTopPanel);
        createHandler();
        createModel();
        createBroker();
        createValidator();
        createForm();
        createReportLabel();
        createReportComboBox();
        createInputFileLabel();
        createInputFileField();
        createOutputFileLabel();
        createOutputFilePanel();
        createOutputFileField();
        createOutputFileActionToolbar();
        createShowOutputFileButton();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCloseButton();
        createGenerateButton();
        // inline creation of reportTopPanel
        setName("reportTopPanel");
        setLayout(new BorderLayout());
        reportTopPanel.putClientProperty("help", "tutti.report.help");
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPORT_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("report", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    reportComboBox.setSelectedItem(model.getReport());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("report", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INPUT_FILE_FIELD_SELECTED_FILE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("inputFile", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    inputFileField.setSelectedFile(model.getInputFile());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("inputFile", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_OUTPUT_FILE_FIELD_SELECTED_FILE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("outputFile", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    outputFileField.setSelectedFile(model.getOutputFile());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("outputFile", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SHOW_OUTPUT_FILE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("outputFileExists", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    showOutputFileButton.setEnabled(model.isOutputFileExists());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("outputFileExists", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GENERATE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    generateButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}