package fr.ifremer.tutti.ui.swing.content.operation.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id: ExportFishingOperationReportAction.java 1265 2013-10-02 10:08:19Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.9/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/ExportFishingOperationReportAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.catches.ExportCatchesReportService;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.File;

import static org.nuiton.i18n.I18n._;

/**
 * Opens a file chooser, exports the cruise catches into the selected file and open the default email editor.
 *
 * @author kmorin <morin@codelutin.com>
 * @since 1.0
 */
public class ExportFishingOperationReportAction extends AbstractTuttiAction<EditCatchesUIModel, EditCatchesUI, EditCatchesUIHandler> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(ExportFishingOperationReportAction.class);

    protected File file;

    public ExportFishingOperationReportAction(EditCatchesUIHandler handler) {
        super(handler, true);
    }

    @Override
    public boolean prepareAction() throws Exception {

        boolean doAction = super.prepareAction();

        if (doAction) {

            Cruise cruise = getDataContext().getCruise();
            FishingOperation fishingOperation = getModel().getFishingOperation();
            // choose file to export
            file = saveFile(
                    "exportFishingOperation-" + cruise.getName() + "-" + fishingOperation.getStationNumber(),
                    "pdf",
                    _("tutti.exportFishingOperationReport.title.choose.exportFile"),
                    _("tutti.exportFishingOperationReport.action.chooseFile"),
                    "^.+\\.pdf$", _("tutti.common.file.pdf")
            );
            doAction = file != null;
        }
        return doAction;
    }

    @Override
    public void releaseAction() {
        file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        Cruise cruise = getDataContext().getCruise();
        FishingOperation fishingOperation = getModel().getFishingOperation();
        Preconditions.checkNotNull(cruise);
        Preconditions.checkNotNull(fishingOperation);
        Preconditions.checkNotNull(file);

        if (log.isInfoEnabled()) {
            log.info("Will export fishingOperation " + cruise.getId() + "-" + fishingOperation.getStationNumber() +
                     " to file: " + file);
        }

        // export catches
        ExportCatchesReportService service =
                getContext().getGeneratePDFService();
        service.generateFishingOperationPDFFile(file, fishingOperation.getId(), getConfig().getI18nLocale());

    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        sendMessage(_("tutti.exportFishingOperationReport.action.success", file));
    }
}
