/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.util.HashSet;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class RemoveBenthosBatchAction
extends AbstractTuttiAction<BenthosBatchUIModel, BenthosBatchUI, BenthosBatchUIHandler> {
    private static final Log log = LogFactory.getLog(RemoveBenthosBatchAction.class);
    protected int rowIndex;

    public RemoveBenthosBatchAction(BenthosBatchUIHandler handler) {
        super(handler, false);
    }

    @Override
    public boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        this.rowIndex = -1;
        if (result) {
            int answer = JOptionPane.showConfirmDialog(this.getContext().getActionUI(), I18n._((String)"tutti.editBenthosBatch.action.removeBatch.confirm.message", (Object[])new Object[0]), I18n._((String)"tutti.editBenthosBatch.action.removeBatch.confirm.title", (Object[])new Object[0]), 0);
            result = answer == 0;
        }
        return result;
    }

    @Override
    public void doAction() throws Exception {
        PersistenceService persistenceService = this.getContext().getPersistenceService();
        JXTable table = ((BenthosBatchUIHandler)this.handler).getTable();
        this.rowIndex = SwingUtil.getSelectedModelRow((JTable)table);
        Preconditions.checkState((this.rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant remove batch if no batch selected");
        BenthosBatchTableModel tableModel = ((BenthosBatchUIHandler)this.handler).getTableModel();
        BenthosBatchRowModel selectedBatch = (BenthosBatchRowModel)tableModel.getEntry(this.rowIndex);
        Preconditions.checkState((!TuttiEntities.isNew((TuttiEntity)selectedBatch) ? 1 : 0) != 0, (Object)"Can't remove batch if batch is not persisted");
        persistenceService.deleteBenthosBatch(selectedBatch.getId());
        if (selectedBatch.isBatchRoot()) {
            ((BenthosBatchUIHandler)this.handler).removeFromSpeciesUsed(selectedBatch);
        } else {
            BenthosBatchRowModel parentBatch = selectedBatch.getParentBatch();
            parentBatch.getChildBatch().remove(selectedBatch);
        }
        HashSet rowToRemove = Sets.newHashSet();
        rowToRemove.add(selectedBatch);
        ((BenthosBatchUIHandler)this.handler).collectChildren(selectedBatch, rowToRemove);
        ((BenthosBatchUIModel)this.getModel()).getRows().removeAll(rowToRemove);
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        JXTable table = ((BenthosBatchUIHandler)this.handler).getTable();
        ((BenthosBatchUIHandler)this.handler).getTableModel().fireTableDataChanged();
        TuttiUIUtil.selectFirstCellOnFirstRowAndStopEditing(table);
    }
}

