/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.MethodUtilities;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.utility.StringUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Member;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class SimpleMemberModel {
    private final Member member;
    private final Class[] argTypes;

    protected SimpleMemberModel(Member member, Class[] argTypes) {
        this.member = member;
        this.argTypes = argTypes;
    }

    Object[] unwrapArguments(List arguments, BeansWrapper wrapper) throws TemplateModelException {
        if (arguments == null) {
            arguments = Collections.EMPTY_LIST;
        }
        boolean isVarArg = MethodUtilities.isVarArgs(this.member);
        int typesLen = this.argTypes.length;
        if (isVarArg) {
            if (typesLen - 1 > arguments.size()) {
                throw new TemplateModelException("Method " + this.member + " takes at least " + (typesLen - 1) + " arguments, " + arguments.size() + " was given.");
            }
        } else if (typesLen != arguments.size()) {
            throw new TemplateModelException("Method " + this.member + " takes exactly " + typesLen + " arguments, " + arguments.size() + " was given.");
        }
        Object[] args = SimpleMemberModel.unwrapArguments(arguments, this.argTypes, isVarArg, wrapper);
        return args;
    }

    static Object[] unwrapArguments(List args, Class[] argTypes, boolean isVarargs, BeansWrapper w) throws TemplateModelException {
        if (args == null) {
            return null;
        }
        int typesLen = argTypes.length;
        int argsLen = args.size();
        Object[] unwrappedArgs = new Object[typesLen];
        Iterator it = args.iterator();
        int normalArgCnt = isVarargs ? typesLen - 1 : typesLen;
        int argIdx = 0;
        while (argIdx < normalArgCnt) {
            Class argType = argTypes[argIdx];
            TemplateModel argVal = (TemplateModel)it.next();
            Object unwrappedArgVal = w.unwrapInternal(argVal, argType);
            if (unwrappedArgVal == BeansWrapper.CAN_NOT_UNWRAP) {
                throw SimpleMemberModel.createArgumentTypeMismarchException(argIdx, argVal, argType);
            }
            unwrappedArgs[argIdx++] = unwrappedArgVal;
        }
        if (isVarargs) {
            Class varargType = argTypes[typesLen - 1];
            Class<?> varargItemType = varargType.getComponentType();
            if (!it.hasNext()) {
                unwrappedArgs[argIdx++] = Array.newInstance(varargItemType, 0);
            } else {
                Object unwrappedArgVal;
                TemplateModel argVal = (TemplateModel)it.next();
                if (argsLen - argIdx == 1 && (unwrappedArgVal = w.unwrapInternal(argVal, varargType)) != BeansWrapper.CAN_NOT_UNWRAP) {
                    unwrappedArgs[argIdx++] = unwrappedArgVal;
                } else {
                    int varargArrayLen = argsLen - argIdx;
                    Object varargArray = Array.newInstance(varargItemType, varargArrayLen);
                    for (int varargIdx = 0; varargIdx < varargArrayLen; ++varargIdx) {
                        TemplateModel varargVal = varargIdx == 0 ? argVal : it.next();
                        Object unwrappedVarargVal = w.unwrapInternal(varargVal, varargItemType);
                        if (unwrappedVarargVal == BeansWrapper.CAN_NOT_UNWRAP) {
                            throw SimpleMemberModel.createArgumentTypeMismarchException(argIdx + varargIdx, varargVal, varargItemType);
                        }
                        if (unwrappedVarargVal == null && varargItemType.isPrimitive()) {
                            throw SimpleMemberModel.createArgumentTypeMismarchException(argIdx + varargIdx, unwrappedVarargVal, varargItemType);
                        }
                        Array.set(varargArray, varargIdx, unwrappedVarargVal);
                    }
                    unwrappedArgs[argIdx++] = varargArray;
                }
            }
        }
        return unwrappedArgs;
    }

    private static TemplateModelException createArgumentTypeMismarchException(int argIdx, Object argVal, Class targetType) {
        return new TemplateModelException("Argument type mismatch; can not unwrap argument #" + (argIdx + 1) + " (" + (argVal == null ? "value: null" : "class: " + argVal.getClass().getName() + ", toString: " + StringUtil.jQuote(argVal)) + ") to " + targetType);
    }

    protected Member getMember() {
        return this.member;
    }
}

