/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.catches.multipost;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.catches.multipost.MarineLitterRow;
import java.util.List;
import org.nuiton.csv.ValueFormatter;

public class MarineLitterRowModel
extends TuttiCsvUtil.AbstractTuttiImportExportModel<MarineLitterRow> {
    public MarineLitterRowModel(char separator) {
        this(separator, null, null);
    }

    public MarineLitterRowModel(char separator, List<CaracteristicQualitativeValue> categoryValues, List<CaracteristicQualitativeValue> sizeCategoryValues) {
        super(separator);
        if (categoryValues == null) {
            categoryValues = Lists.newArrayList();
        }
        ImmutableMap categoryValueMap = Maps.uniqueIndex((Iterable)categoryValues, (Function)TuttiEntities.GET_ID);
        if (sizeCategoryValues == null) {
            sizeCategoryValues = Lists.newArrayList();
        }
        ImmutableMap sizeCategoryValueMap = Maps.uniqueIndex((Iterable)sizeCategoryValues, (Function)TuttiEntities.GET_ID);
        ValueFormatter<CaracteristicQualitativeValue> caracteristicQualitativeValueFormatter = new ValueFormatter<CaracteristicQualitativeValue>(){

            public String format(CaracteristicQualitativeValue value) {
                String result = "";
                if (value != null) {
                    result = value.getId();
                }
                return result;
            }
        };
        this.newColumnForImportExport("batchId");
        this.newColumnForExport("category", (ValueFormatter)caracteristicQualitativeValueFormatter);
        this.newForeignKeyColumn("category", CaracteristicQualitativeValue.class, "id", categoryValueMap);
        this.newColumnForExport("sizeCategory", (ValueFormatter)caracteristicQualitativeValueFormatter);
        this.newForeignKeyColumn("sizeCategory", CaracteristicQualitativeValue.class, "id", sizeCategoryValueMap);
        this.newColumnForImportExport("number", TuttiCsvUtil.INTEGER);
        this.newColumnForImportExport("weight", TuttiCsvUtil.FLOAT);
        this.newColumnForImportExport("comment");
    }

    public MarineLitterRow newEmptyInstance() {
        return new MarineLitterRow();
    }
}

