package fr.ifremer.tutti.ui.swing.spatial;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class DmdCoordinateEditor extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_SHOW_RESET = "showReset";
    public static final String PROPERTY_SHOW_RESET_TIP = "showResetTip";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_ENABLED = "editor.enabled";
    public static final String BINDING_RESET_BUTTON_ENABLED = "resetButton.enabled";
    public static final String BINDING_RESET_BUTTON_TOOL_TIP_TEXT = "resetButton.toolTipText";
    public static final String BINDING_TOOLBAR_LEFT_VISIBLE = "toolbarLeft.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1Uz08TQRR+LbTQll+KEowYUROjJm4ToxchivxogBQ1lAOxF2e703bI7sw6MwtLiMY/wT9B715MvHkyHjx78GL8F4zx4NX4ZrftUiiB0KSTdua9733vm+/N+1+QURKubJEwtGTANfOotfpoc/OJvUVrepGqmmS+FhLiTyoN6SoUnM6+0nCtWjbpxVZ6cUF4vuCU78ueKUNe6V2XqialWsOl7oyaUsVK53gm9APZRu2Q6oX69s/v9Bvn9bs0QOgju0FsZfq4rKST/jKkmaPhLFbaJkWX8AbSkIw3kO+w2VtwiVKPiUdfwCsYKEPWJxLBNFw9ecsRRpQf+hoK1GF4+pRw6mq4V5cWq0vqUWnpQGtmBcxSO8jAUj7RjLjWoucsCCEdxommS1Gy70d4WQ051RQ761QZTc8YwpZpwpoXwqWEJ3FDnbgNJAdjSWjcbxKZ8YRjmN0/FbM1k5yADTQJd1wqNcyeCm45Tk8ACxo7s4ks0zp2fM60EbZgVjfwaJ5IE5lLEqRpeh4rCq5hvCsh3jWBk534bHw9Gi53hZaE9IjW1NmgoS4x6jqtMhIudvkNnWwlTk6slqpCRga4rWGyetj863gU237ygO0NYHT6b2L8+6efH0ttr/dj7fM9Q/eNKnrQl8LHG2Cm9Ghs9EAzt7hG/JkqGoi6OOfRHE/1IFZpHSM5rBdbzKRby0Q1ESIz8OPzl4nn3/ogXYK8K4hTIiZ+BXK6ido3heuE/sO5iNHQziCuY/jtQ29sM8VsF0Ua3WOq0vbnjZsv0dZ1RNIkOs3UiYv7MGyjNygODuN4D+39ECWb6iFZh7ed+/p3vPJhri1bCtu4cGR4Il3mGWQZdxmn0SPRmv+ej0LBVzRwRDLnvSYfus3rtzx9PVpvHRIogwJRbhTAVodRoKX4T0seUQtUtzxD0d4BdTTk8TaY4Cs1Y/+RmvBsYYvwtoyfjIgRvgjG1Tgdew2qK/seCiwWBobfnUg48+sudM/UcX2kju6jF3Rr/E6AmnXJrkAKMDLroFWmbcbx5Wg8OISaMmseEf8DwBjPiesGAAA=";
    private static final Log log = LogFactory.getLog(DmdCoordinateEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JFormattedTextField editor;
    protected DmdCoordinateEditor editorPanel = this;
    protected DmdCoordinateEditorHandler handler;
    protected DmdCoordinateEditorModel model;
    protected JButton resetButton;
    protected Boolean showReset;
    protected String showResetTip;
    protected JToolBar toolbarLeft;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() { handler.init(); }
    public void setBean(Serializable bean) { model.setBean(bean); }
    public void setPropertySign(String property ) { model.setPropertySign(property); }
    public void setPropertyDegree(String property ) { model.setPropertyDegree(property); }
    public void setPropertyMinute(String property ) { model.setPropertyMinute(property); }
    public void setPropertyDecimal(String property ) { model.setPropertyDecimal(property); }
    public void setLongitudeEditor(boolean longitudeEditor) { model.setLongitudeEditor(longitudeEditor); }
    public void setValue(DmdCoordinate value) { handler.setValue(value, false); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DmdCoordinateEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DmdCoordinateEditor(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DmdCoordinateEditor() {
        $initialize();
    }

    public DmdCoordinateEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DmdCoordinateEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DmdCoordinateEditor(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DmdCoordinateEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public DmdCoordinateEditor(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__resetButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.resetEditor();
    }

    public void doFocusGained__on__editorPanel(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        editor.requestFocus();
    }

    public void doKeyReleased__on__editor(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.onKeyReleased(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JFormattedTextField getEditor() {
        return editor;
    }

    public DmdCoordinateEditorHandler getHandler() {
        return handler;
    }

    public DmdCoordinateEditorModel getModel() {
        return model;
    }

    public JButton getResetButton() {
        return resetButton;
    }

    public Boolean getShowReset() {
        return showReset;
    }

    public String getShowResetTip() {
        return showResetTip;
    }

    public JToolBar getToolbarLeft() {
        return toolbarLeft;
    }

    public Boolean isShowReset() {
        return showReset !=null && showReset;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setShowReset(Boolean showReset) {
        Boolean oldValue = this.showReset;
        this.showReset = showReset;
        firePropertyChange(PROPERTY_SHOW_RESET, oldValue, showReset);
    }

    public void setShowResetTip(String showResetTip) {
        String oldValue = this.showResetTip;
        this.showResetTip = showResetTip;
        firePropertyChange(PROPERTY_SHOW_RESET_TIP, oldValue, showResetTip);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditorPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(toolbarLeft, BorderLayout.WEST);
        add(editor, BorderLayout.CENTER);
    }

    protected void addChildrenToToolbarLeft() {
        if (!allComponentsCreated) {
            return;
        }
        toolbarLeft.add(resetButton);
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new JFormattedTextField());
        
        editor.setName("editor");
        editor.setColumns(15);
        editor.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__editor"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new DmdCoordinateEditorHandler(this));
    }

    protected void createModel() {
        $objectMap.put("model", model = new DmdCoordinateEditorModel());
    }

    protected void createResetButton() {
        $objectMap.put("resetButton", resetButton = new JButton());
        
        resetButton.setName("resetButton");
        resetButton.setFocusable(false);
        resetButton.setFocusPainted(false);
        resetButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resetButton"));
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = false);
    }

    protected void createShowResetTip() {
        $objectMap.put("showResetTip", showResetTip = new String());
    }

    protected void createToolbarLeft() {
        $objectMap.put("toolbarLeft", toolbarLeft = new JToolBar());
        
        toolbarLeft.setName("toolbarLeft");
        toolbarLeft.setFloatable(false);
        toolbarLeft.setBorderPainted(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditorPanel();
        addChildrenToToolbarLeft();
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 2 property setters
        resetButton.setIcon(SwingUtil.createActionIcon("combobox-reset"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("editorPanel", editorPanel);
        createShowReset();
        createShowResetTip();
        createModel();
        createHandler();
        createToolbarLeft();
        createResetButton();
        createEditor();
        // inline creation of editorPanel
        setName("editorPanel");
        setLayout(new BorderLayout());
        editorPanel.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__editorPanel"));
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TOOLBAR_LEFT_VISIBLE, true ,"showReset") {
        
            @Override
            public void processDataBinding() {
                toolbarLeft.setVisible(isShowReset());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_BUTTON_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                resetButton.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_BUTTON_TOOL_TIP_TEXT, true ,"showResetTip") {
        
            @Override
            public void processDataBinding() {
                resetButton.setToolTipText(_(getShowResetTip()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                editor.setEnabled(isEnabled());
            }
        });
    }

}