/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.table.AbstractSelectTableAction;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class RemoveAllIndividualObservationBatchAction
extends AbstractTuttiAction<IndividualObservationBatchUIModel, IndividualObservationBatchUI, IndividualObservationBatchUIHandler> {
    private static final Log log = LogFactory.getLog(RemoveAllIndividualObservationBatchAction.class);
    protected Species species;
    protected List<Integer> rowIndexToRemove;

    public RemoveAllIndividualObservationBatchAction(IndividualObservationBatchUIHandler handler) {
        super(handler, false);
    }

    @Override
    public boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        this.rowIndexToRemove = null;
        this.species = null;
        int rowIndex = -1;
        if (result) {
            JXTable table = ((IndividualObservationBatchUIHandler)this.handler).getTable();
            rowIndex = table.getSelectedRow();
            Preconditions.checkState((rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant remove batch if none is selected");
        }
        if (result) {
            IndividualObservationBatchTableModel tableModel = ((IndividualObservationBatchUIHandler)this.handler).getTableModel();
            IndividualObservationBatchRowModel entry = (IndividualObservationBatchRowModel)tableModel.getEntry(rowIndex);
            this.species = entry.getSpecies();
            this.rowIndexToRemove = Lists.newArrayList();
            for (IndividualObservationBatchRowModel rowModel : tableModel.getRows()) {
                if (!this.species.equals(rowModel.getSpecies())) continue;
                this.rowIndexToRemove.add(0, tableModel.getRowIndex(rowModel));
            }
            int answer = JOptionPane.showConfirmDialog(this.getContext().getActionUI(), I18n._((String)"tutti.editIndividualObservationBatch.action.removeAllBatch.confirm.message", (Object[])new Object[]{this.rowIndexToRemove.size(), this.decorate(this.species)}), I18n._((String)"tutti.editIndividualObservationBatch.action.removeAllBatch.confirm.title", (Object[])new Object[0]), 0);
            result = answer == 0;
        }
        return result;
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkNotNull(this.rowIndexToRemove);
        Preconditions.checkNotNull((Object)this.species);
        JXTable table = ((IndividualObservationBatchUIHandler)this.handler).getTable();
        IndividualObservationBatchTableModel tableModel = ((IndividualObservationBatchUIHandler)this.handler).getTableModel();
        for (Integer rowIndex : this.rowIndexToRemove) {
            IndividualObservationBatchRowModel selectedBatch = (IndividualObservationBatchRowModel)tableModel.getEntry(rowIndex);
            boolean persisted = !TuttiEntities.isNew((TuttiEntity)selectedBatch);
            if (!persisted) continue;
            String id = selectedBatch.getId();
            if (log.isInfoEnabled()) {
                log.info((Object)("Remove individual observation with id: " + id));
            }
            PersistenceService persistenceService = this.getContext().getPersistenceService();
            persistenceService.deleteIndividualObservationBatch(id);
        }
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        JXTable table = ((IndividualObservationBatchUIHandler)this.handler).getTable();
        IndividualObservationBatchTableModel tableModel = ((IndividualObservationBatchUIHandler)this.handler).getTableModel();
        for (Integer rowIndex : this.rowIndexToRemove) {
            tableModel.removeRow(rowIndex);
        }
        if (!tableModel.getRows().isEmpty()) {
            AbstractSelectTableAction.doSelectCell((JTable)table, 0, 0);
        }
        if (table.isEditing()) {
            table.getCellEditor().stopCellEditing();
        }
    }
}

