/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocols;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class EditProtocolUIModel
extends AbstractTuttiBeanUIModel<TuttiProtocol, EditProtocolUIModel>
implements TuttiProtocol {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_SPECIES_ROW = "speciesRow";
    public static final String PROPERTY_BENTHOS_ROW = "benthosRow";
    public static final String PROPERTY_REMOVE_SPECIES_ENABLED = "removeSpeciesEnabled";
    public static final String PROPERTY_REMOVE_BENTHOS_ENABLED = "removeBenthosEnabled";
    public static final String PROPERTY_IMPORTED = "imported";
    public static final String PROPERTY_CLONED = "cloned";
    public static final String PROPERTY_CLEANED = "cleaned";
    protected final TuttiProtocol editObject = TuttiProtocols.newTuttiProtocol();
    protected boolean imported;
    protected boolean cloned;
    protected boolean cleaned;
    protected boolean removeSpeciesEnabled;
    protected boolean removeBenthosEnabled;
    protected List<Species> allSpecies;
    protected List<Species> allSynonyms;
    protected Multimap<String, Species> allSpeciesByTaxonId;
    protected Map<String, Species> allReferentSpeciesByTaxonId;
    protected List<Caracteristic> caracteristics;
    protected Map<String, Caracteristic> allCaracteristic;
    protected List<EditProtocolSpeciesRowModel> speciesRow;
    protected List<EditProtocolSpeciesRowModel> benthosRow;
    protected static Binder<EditProtocolUIModel, TuttiProtocol> toBeanBinder = BinderFactory.newBinder(EditProtocolUIModel.class, TuttiProtocol.class);
    protected static Binder<TuttiProtocol, EditProtocolUIModel> fromBeanBinder = BinderFactory.newBinder(TuttiProtocol.class, EditProtocolUIModel.class);

    public EditProtocolUIModel() {
        super(TuttiProtocol.class, fromBeanBinder, toBeanBinder);
    }

    @Override
    protected TuttiProtocol newEntity() {
        return TuttiProtocols.newTuttiProtocol();
    }

    public void setLengthClassesPmfm(List<Caracteristic> lengthClassesPmfm) {
        ArrayList ids = Lists.newArrayList(TuttiEntities.collecIds(lengthClassesPmfm));
        this.setLengthClassesPmfmId(ids);
    }

    public void setGearUseFeaturePmfm(List<Caracteristic> gearUseFeaturePmfm) {
        List<String> ids = TuttiEntities.collecIds(gearUseFeaturePmfm);
        this.setGearUseFeaturePmfmId(ids);
    }

    public void setVesselUseFeaturePmfm(List<Caracteristic> vesselUseFeaturePmfm) {
        List<String> ids = TuttiEntities.collecIds(vesselUseFeaturePmfm);
        this.setVesselUseFeaturePmfmId(ids);
    }

    public void setIndividualObservationPmfm(List<Caracteristic> individualObservationPmfm) {
        List<String> ids = TuttiEntities.collecIds(individualObservationPmfm);
        this.setIndividualObservationPmfmId(ids);
    }

    public List<EditProtocolSpeciesRowModel> getSpeciesRow() {
        return this.speciesRow;
    }

    public void setSpeciesRow(List<EditProtocolSpeciesRowModel> speciesRow) {
        List<EditProtocolSpeciesRowModel> oldValue = this.getSpeciesRow();
        this.speciesRow = speciesRow;
        this.firePropertyChange(PROPERTY_SPECIES_ROW, oldValue, speciesRow);
    }

    public List<EditProtocolSpeciesRowModel> getBenthosRow() {
        return this.benthosRow;
    }

    public void setBenthosRow(List<EditProtocolSpeciesRowModel> benthosRow) {
        List<EditProtocolSpeciesRowModel> oldValue = this.getBenthosRow();
        this.benthosRow = benthosRow;
        this.firePropertyChange(PROPERTY_BENTHOS_ROW, oldValue, benthosRow);
    }

    public boolean isRemoveSpeciesEnabled() {
        return this.removeSpeciesEnabled;
    }

    public void setRemoveSpeciesEnabled(boolean removeSpeciesEnabled) {
        this.removeSpeciesEnabled = removeSpeciesEnabled;
        this.firePropertyChange(PROPERTY_REMOVE_SPECIES_ENABLED, null, removeSpeciesEnabled);
    }

    public boolean isRemoveBenthosEnabled() {
        return this.removeBenthosEnabled;
    }

    public void setRemoveBenthosEnabled(boolean removeBenthosEnabled) {
        this.removeBenthosEnabled = removeBenthosEnabled;
        this.firePropertyChange(PROPERTY_REMOVE_BENTHOS_ENABLED, null, removeBenthosEnabled);
    }

    public boolean isImported() {
        return this.imported;
    }

    public void setImported(boolean imported) {
        Boolean oldValue = this.isImported();
        this.imported = imported;
        this.firePropertyChange(PROPERTY_IMPORTED, oldValue, imported);
    }

    public boolean isCloned() {
        return this.cloned;
    }

    public void setCloned(boolean cloned) {
        Boolean oldValue = this.isCloned();
        this.cloned = cloned;
        this.firePropertyChange(PROPERTY_CLONED, oldValue, cloned);
    }

    public boolean isCleaned() {
        return this.cleaned;
    }

    public void setCleaned(boolean cleaned) {
        Boolean oldValue = this.isCleaned();
        this.cleaned = cleaned;
        this.firePropertyChange(PROPERTY_CLEANED, oldValue, cleaned);
    }

    public List<Species> getAllSpecies() {
        return this.allSpecies;
    }

    public void setAllSpecies(List<Species> allSpecies) {
        this.allSpecies = allSpecies;
        if (this.allReferentSpeciesByTaxonId != null && allSpecies != null) {
            this.allSynonyms = Lists.newArrayList(allSpecies);
            this.allSynonyms.removeAll(this.allReferentSpeciesByTaxonId.values());
        }
    }

    public Multimap<String, Species> getAllSpeciesByTaxonId() {
        return this.allSpeciesByTaxonId;
    }

    public Collection<Species> getAllSynonyms(String taxonId) {
        return this.allSpeciesByTaxonId.get((Object)taxonId);
    }

    public void setAllSpeciesByTaxonId(Multimap<String, Species> allSpeciesByTaxonId) {
        this.allSpeciesByTaxonId = allSpeciesByTaxonId;
    }

    public List<Species> getAllSynonyms() {
        return this.allSynonyms;
    }

    public Map<String, Species> getAllReferentSpeciesByTaxonId() {
        return this.allReferentSpeciesByTaxonId;
    }

    public void setAllReferentSpeciesByTaxonId(Map<String, Species> allReferentSpeciesByTaxonId) {
        this.allReferentSpeciesByTaxonId = allReferentSpeciesByTaxonId;
        if (allReferentSpeciesByTaxonId != null && this.allSpecies != null) {
            this.allSynonyms = Lists.newArrayList(this.allSpecies);
            for (Species species : allReferentSpeciesByTaxonId.values()) {
                this.allSynonyms.remove(species);
            }
        }
    }

    public List<Caracteristic> getCaracteristics() {
        return this.caracteristics;
    }

    public void setCaracteristics(List<Caracteristic> caracteristics) {
        this.caracteristics = caracteristics;
    }

    public Map<String, Caracteristic> getAllCaracteristic() {
        return this.allCaracteristic;
    }

    public void setAllCaracteristic(Map<String, Caracteristic> allCaracteristic) {
        this.allCaracteristic = allCaracteristic;
    }

    @Override
    public String getName() {
        return this.editObject.getName();
    }

    @Override
    public void setName(String name) {
        String oldValue = this.getName();
        this.editObject.setName(name);
        this.firePropertyChange("name", oldValue, name);
    }

    @Override
    public String getComment() {
        return this.editObject.getComment();
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.getComment();
        this.editObject.setComment(comment);
        this.firePropertyChange("comment", oldValue, comment);
    }

    @Override
    public List<String> getLengthClassesPmfmId() {
        return this.editObject.getLengthClassesPmfmId();
    }

    @Override
    public void setLengthClassesPmfmId(List<String> lengthClassesPmfmId) {
        this.editObject.setLengthClassesPmfmId(lengthClassesPmfmId);
        this.firePropertyChange("lengthClassesPmfmId", null, lengthClassesPmfmId);
    }

    @Override
    public List<String> getGearUseFeaturePmfmId() {
        return this.editObject.getGearUseFeaturePmfmId();
    }

    @Override
    public void setGearUseFeaturePmfmId(List<String> gearUseFeaturePmfmId) {
        this.editObject.setGearUseFeaturePmfmId(gearUseFeaturePmfmId);
        this.firePropertyChange("gearUseFeaturePmfmId", null, gearUseFeaturePmfmId);
    }

    @Override
    public List<String> getVesselUseFeaturePmfmId() {
        return this.editObject.getVesselUseFeaturePmfmId();
    }

    @Override
    public void setVesselUseFeaturePmfmId(List<String> vesselUseFeaturePmfmId) {
        this.editObject.setVesselUseFeaturePmfmId(vesselUseFeaturePmfmId);
        this.firePropertyChange("vesselUseFeaturePmfmId", null, vesselUseFeaturePmfmId);
    }

    @Override
    public List<String> getIndividualObservationPmfmId() {
        return this.editObject.getIndividualObservationPmfmId();
    }

    @Override
    public void setIndividualObservationPmfmId(List<String> individualObservationPmfmId) {
        this.editObject.setIndividualObservationPmfmId(individualObservationPmfmId);
        this.firePropertyChange("individualObservationPmfmId", null, individualObservationPmfmId);
    }

    @Override
    public String getGearUseFeaturePmfmId(int index) {
        return this.editObject.getGearUseFeaturePmfmId(index);
    }

    @Override
    public boolean isGearUseFeaturePmfmIdEmpty() {
        return this.editObject.isGearUseFeaturePmfmIdEmpty();
    }

    @Override
    public int sizeGearUseFeaturePmfmId() {
        return this.editObject.sizeGearUseFeaturePmfmId();
    }

    @Override
    public void addGearUseFeaturePmfmId(String gearUseFeaturePmfmId) {
        this.editObject.addGearUseFeaturePmfmId(gearUseFeaturePmfmId);
    }

    @Override
    public void addAllGearUseFeaturePmfmId(Collection<String> gearUseFeaturePmfmId) {
        this.editObject.addAllGearUseFeaturePmfmId(gearUseFeaturePmfmId);
    }

    @Override
    public boolean removeGearUseFeaturePmfmId(String gearUseFeaturePmfmId) {
        return this.editObject.removeGearUseFeaturePmfmId(gearUseFeaturePmfmId);
    }

    @Override
    public boolean removeAllGearUseFeaturePmfmId(Collection<String> gearUseFeaturePmfmId) {
        return this.editObject.removeAllGearUseFeaturePmfmId(gearUseFeaturePmfmId);
    }

    @Override
    public boolean containsGearUseFeaturePmfmId(String gearUseFeaturePmfmId) {
        return this.editObject.containsGearUseFeaturePmfmId(gearUseFeaturePmfmId);
    }

    @Override
    public boolean containsAllGearUseFeaturePmfmId(Collection<String> gearUseFeaturePmfmId) {
        return this.editObject.containsAllGearUseFeaturePmfmId(gearUseFeaturePmfmId);
    }

    @Override
    public String getVesselUseFeaturePmfmId(int index) {
        return this.editObject.getVesselUseFeaturePmfmId(index);
    }

    @Override
    public boolean isVesselUseFeaturePmfmIdEmpty() {
        return this.editObject.isVesselUseFeaturePmfmIdEmpty();
    }

    @Override
    public int sizeVesselUseFeaturePmfmId() {
        return this.editObject.sizeVesselUseFeaturePmfmId();
    }

    @Override
    public void addVesselUseFeaturePmfmId(String vesselUseFeaturePmfmId) {
        this.editObject.addVesselUseFeaturePmfmId(vesselUseFeaturePmfmId);
    }

    @Override
    public void addAllVesselUseFeaturePmfmId(Collection<String> vesselUseFeaturePmfmId) {
        this.editObject.addAllVesselUseFeaturePmfmId(vesselUseFeaturePmfmId);
    }

    @Override
    public boolean removeVesselUseFeaturePmfmId(String vesselUseFeaturePmfmId) {
        return this.editObject.removeVesselUseFeaturePmfmId(vesselUseFeaturePmfmId);
    }

    @Override
    public boolean removeAllVesselUseFeaturePmfmId(Collection<String> vesselUseFeaturePmfmId) {
        return this.editObject.removeAllVesselUseFeaturePmfmId(vesselUseFeaturePmfmId);
    }

    @Override
    public boolean containsVesselUseFeaturePmfmId(String vesselUseFeaturePmfmId) {
        return this.editObject.containsVesselUseFeaturePmfmId(vesselUseFeaturePmfmId);
    }

    @Override
    public boolean containsAllVesselUseFeaturePmfmId(Collection<String> vesselUseFeaturePmfmId) {
        return this.editObject.containsAllVesselUseFeaturePmfmId(vesselUseFeaturePmfmId);
    }

    @Override
    public String getIndividualObservationPmfmId(int index) {
        return this.editObject.getIndividualObservationPmfmId(index);
    }

    @Override
    public boolean isIndividualObservationPmfmIdEmpty() {
        return this.editObject.isIndividualObservationPmfmIdEmpty();
    }

    @Override
    public int sizeIndividualObservationPmfmId() {
        return this.editObject.sizeIndividualObservationPmfmId();
    }

    @Override
    public void addIndividualObservationPmfmId(String individualObservationPmfmId) {
        this.editObject.addIndividualObservationPmfmId(individualObservationPmfmId);
    }

    @Override
    public void addAllIndividualObservationPmfmId(Collection<String> individualObservationPmfmId) {
        this.editObject.addAllIndividualObservationPmfmId(individualObservationPmfmId);
    }

    @Override
    public boolean removeIndividualObservationPmfmId(String individualObservationPmfmId) {
        return this.editObject.removeIndividualObservationPmfmId(individualObservationPmfmId);
    }

    @Override
    public boolean removeAllIndividualObservationPmfmId(Collection<String> individualObservationPmfmId) {
        return this.editObject.removeAllIndividualObservationPmfmId(individualObservationPmfmId);
    }

    @Override
    public boolean containsIndividualObservationPmfmId(String individualObservationPmfmId) {
        return this.editObject.containsIndividualObservationPmfmId(individualObservationPmfmId);
    }

    @Override
    public boolean containsAllIndividualObservationPmfmId(Collection<String> individualObservationPmfmId) {
        return this.editObject.containsAllIndividualObservationPmfmId(individualObservationPmfmId);
    }

    @Override
    public String getLengthClassesPmfmId(int index) {
        return this.editObject.getLengthClassesPmfmId(index);
    }

    @Override
    public boolean isLengthClassesPmfmIdEmpty() {
        return this.editObject.isLengthClassesPmfmIdEmpty();
    }

    @Override
    public int sizeLengthClassesPmfmId() {
        return this.editObject.sizeLengthClassesPmfmId();
    }

    @Override
    public void addLengthClassesPmfmId(String lengthClassesPmfmId) {
        this.editObject.addLengthClassesPmfmId(lengthClassesPmfmId);
        this.firePropertyChange("lengthClassesPmfmId", null, this.getLengthClassesPmfmId());
    }

    @Override
    public void addAllLengthClassesPmfmId(Collection<String> lengthClassesPmfmId) {
        this.editObject.addAllLengthClassesPmfmId(lengthClassesPmfmId);
        this.firePropertyChange("lengthClassesPmfmId", null, this.getLengthClassesPmfmId());
    }

    @Override
    public boolean removeLengthClassesPmfmId(String lengthClassesPmfmId) {
        boolean result = this.editObject.removeLengthClassesPmfmId(lengthClassesPmfmId);
        this.firePropertyChange("lengthClassesPmfmId", null, this.getLengthClassesPmfmId());
        return result;
    }

    @Override
    public boolean removeAllLengthClassesPmfmId(Collection<String> lengthClassesPmfmId) {
        boolean result = this.editObject.removeAllLengthClassesPmfmId(lengthClassesPmfmId);
        this.firePropertyChange("lengthClassesPmfmId", null, this.getLengthClassesPmfmId());
        return result;
    }

    @Override
    public boolean containsLengthClassesPmfmId(String lengthClassesPmfmId) {
        return this.editObject.containsLengthClassesPmfmId(lengthClassesPmfmId);
    }

    @Override
    public boolean containsAllLengthClassesPmfmId(Collection<String> lengthClassesPmfmId) {
        return this.editObject.containsAllLengthClassesPmfmId(lengthClassesPmfmId);
    }

    @Override
    public SpeciesProtocol getSpecies(int index) {
        return this.editObject.getSpecies(index);
    }

    @Override
    public boolean isSpeciesEmpty() {
        return this.editObject.isSpeciesEmpty();
    }

    @Override
    public int sizeSpecies() {
        return this.editObject.sizeSpecies();
    }

    @Override
    public void addSpecies(SpeciesProtocol species) {
        this.editObject.addSpecies(species);
    }

    @Override
    public void addAllSpecies(Collection<SpeciesProtocol> species) {
        this.editObject.addAllSpecies(species);
    }

    @Override
    public boolean removeSpecies(SpeciesProtocol species) {
        return this.editObject.removeSpecies(species);
    }

    @Override
    public boolean removeAllSpecies(Collection<SpeciesProtocol> species) {
        return this.editObject.removeAllSpecies(species);
    }

    @Override
    public boolean containsSpecies(SpeciesProtocol species) {
        return this.editObject.containsSpecies(species);
    }

    @Override
    public boolean containsAllSpecies(Collection<SpeciesProtocol> species) {
        return this.editObject.containsAllSpecies(species);
    }

    @Override
    public List<SpeciesProtocol> getSpecies() {
        return this.editObject.getSpecies();
    }

    @Override
    public void setSpecies(List<SpeciesProtocol> species) {
        this.editObject.setSpecies(species);
    }

    @Override
    public SpeciesProtocol getBenthos(int index) {
        return this.editObject.getBenthos(index);
    }

    @Override
    public boolean isBenthosEmpty() {
        return this.editObject.isBenthosEmpty();
    }

    @Override
    public int sizeBenthos() {
        return this.editObject.sizeBenthos();
    }

    @Override
    public void addBenthos(SpeciesProtocol benthos) {
        this.editObject.addBenthos(benthos);
    }

    @Override
    public void addAllBenthos(Collection<SpeciesProtocol> benthos) {
        this.editObject.addAllBenthos(benthos);
    }

    @Override
    public boolean removeBenthos(SpeciesProtocol benthos) {
        return this.editObject.removeBenthos(benthos);
    }

    @Override
    public boolean removeAllBenthos(Collection<SpeciesProtocol> benthos) {
        return this.editObject.removeAllBenthos(benthos);
    }

    @Override
    public boolean containsBenthos(SpeciesProtocol benthos) {
        return this.editObject.containsBenthos(benthos);
    }

    @Override
    public boolean containsAllBenthos(Collection<SpeciesProtocol> benthos) {
        return this.editObject.containsAllBenthos(benthos);
    }

    @Override
    public List<SpeciesProtocol> getBenthos() {
        return this.editObject.getBenthos();
    }

    @Override
    public void setBenthos(List<SpeciesProtocol> benthos) {
        this.editObject.setBenthos(benthos);
    }

    @Override
    public Integer getVersion() {
        return this.editObject.getVersion();
    }

    @Override
    public void setVersion(Integer version) {
        this.editObject.setVersion(version);
    }
}

