package fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class CreateIndividualObservationBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<CreateIndividualObservationBatchUIModel, CreateIndividualObservationBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_INDIVIDUAL_OBSERVATION_CREATE_FROM_BATCH_ENABLED = "individualObservationCreateFromBatch.enabled";
    public static final String BINDING_INDIVIDUAL_OBSERVATION_CREATE_FROM_BATCH_SELECTED = "individualObservationCreateFromBatch.selected";
    public static final String BINDING_INDIVIDUAL_OBSERVATION_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_SELECTED_ITEM = "individualObservationLengthStepCaracteristicComboBox.selectedItem";
    public static final String BINDING_INDIVIDUAL_OBSERVATION_SIZE_FIELD_MODEL = "individualObservationSizeField.model";
    public static final String BINDING_INDIVIDUAL_OBSERVATION_SPECIES_COMBO_BOX_DATA = "individualObservationSpeciesComboBox.data";
    public static final String BINDING_INDIVIDUAL_OBSERVATION_SPECIES_COMBO_BOX_SELECTED_ITEM = "individualObservationSpeciesComboBox.selectedItem";
    public static final String BINDING_INDIVIDUAL_OBSERVATION_WEIGHT_FIELD_MODEL = "individualObservationWeightField.model";
    public static final String BINDING_SAVE_AND_CLOSE_BUTTON_ENABLED = "saveAndCloseButton.enabled";
    public static final String BINDING_SAVE_AND_CONTINUE_BUTTON_ENABLED = "saveAndContinueButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(CreateIndividualObservationBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addSpeciesButton;
    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    protected Table configurationPanel;
    protected CreateIndividualObservationBatchUI createIndividualObservationBatchTopPanel = this;
    protected CreateIndividualObservationBatchUIHandler handler;
    protected JCheckBox individualObservationCreateFromBatch;
    @ValidatorField( validatorId = "validator",  propertyName = "lengthStepCaracteristic",  editorName = "individualObservationLengthStepCaracteristicComboBox")
    protected BeanFilterableComboBox<Caracteristic> individualObservationLengthStepCaracteristicComboBox;
    protected JLabel individualObservationLengthStepCaracteristicLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "size",  editorName = "individualObservationSizeField")
    protected NumberEditor individualObservationSizeField;
    protected JLabel individualObservationSizeLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "species",  editorName = "individualObservationSpeciesComboBox")
    protected BeanFilterableComboBox<Species> individualObservationSpeciesComboBox;
    protected JLabel individualObservationSpeciesLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "weight",  editorName = "individualObservationWeightField")
    protected NumberEditor individualObservationWeightField;
    protected JLabel individualObservationWeightLabel;
    protected CreateIndividualObservationBatchUIModel model;
    protected JButton saveAndCloseButton;
    protected JButton saveAndContinueButton;
    @Validator( validatorId = "validator")
    protected SwingValidator<CreateIndividualObservationBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CreateIndividualObservationBatchUI(EditCatchesUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            CreateIndividualObservationBatchUIHandler handler = new CreateIndividualObservationBatchUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public CreateIndividualObservationBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CreateIndividualObservationBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateIndividualObservationBatchUI() {
        $initialize();
    }

    public CreateIndividualObservationBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateIndividualObservationBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CreateIndividualObservationBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateIndividualObservationBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public CreateIndividualObservationBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__saveAndCloseButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveAndClose();
    }

    public void doActionPerformed__on__saveAndContinueButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveAndContinue();
    }

    public void doItemStateChanged__on__individualObservationCreateFromBatch(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "createFromBatch");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddSpeciesButton() {
        return addSpeciesButton;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public Table getConfigurationPanel() {
        return configurationPanel;
    }

    public CreateIndividualObservationBatchUIHandler getHandler() {
        return handler;
    }

    public JCheckBox getIndividualObservationCreateFromBatch() {
        return individualObservationCreateFromBatch;
    }

    public BeanFilterableComboBox<Caracteristic> getIndividualObservationLengthStepCaracteristicComboBox() {
        return individualObservationLengthStepCaracteristicComboBox;
    }

    public JLabel getIndividualObservationLengthStepCaracteristicLabel() {
        return individualObservationLengthStepCaracteristicLabel;
    }

    public NumberEditor getIndividualObservationSizeField() {
        return individualObservationSizeField;
    }

    public JLabel getIndividualObservationSizeLabel() {
        return individualObservationSizeLabel;
    }

    public BeanFilterableComboBox<Species> getIndividualObservationSpeciesComboBox() {
        return individualObservationSpeciesComboBox;
    }

    public JLabel getIndividualObservationSpeciesLabel() {
        return individualObservationSpeciesLabel;
    }

    public NumberEditor getIndividualObservationWeightField() {
        return individualObservationWeightField;
    }

    public JLabel getIndividualObservationWeightLabel() {
        return individualObservationWeightLabel;
    }

    public CreateIndividualObservationBatchUIModel getModel() {
        return model;
    }

    public JButton getSaveAndCloseButton() {
        return saveAndCloseButton;
    }

    public JButton getSaveAndContinueButton() {
        return saveAndContinueButton;
    }

    public SwingValidator<CreateIndividualObservationBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(individualObservationSpeciesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(individualObservationSpeciesComboBox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(addSpeciesButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(individualObservationCreateFromBatch, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(individualObservationWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(individualObservationWeightField), new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(individualObservationSizeLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(individualObservationSizeField), new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(individualObservationLengthStepCaracteristicLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(individualObservationLengthStepCaracteristicComboBox), new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCreateIndividualObservationBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(configurationPanel, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAddSpeciesButton() {
        $objectMap.put("addSpeciesButton", addSpeciesButton = new JButton());
        
        addSpeciesButton.setName("addSpeciesButton");
        addSpeciesButton.setText(_("tutti.createIndividualObservationBatch.action.addSpecies"));
        addSpeciesButton.setToolTipText(_("tutti.createIndividualObservationBatch.action.addSpecies.tip"));
        addSpeciesButton.putClientProperty("help", "tutti.createIndividualObservationBatch.action.addSpecies.help");
        addSpeciesButton.putClientProperty("tuttiAction", SelectSpeciesForIndividualObservationBatchAction.class);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.createIndividualObservationBatch.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.createIndividualObservationBatch.action.cancel"));
        cancelButton.setToolTipText(_("tutti.createIndividualObservationBatch.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
        cancelButton.putClientProperty("help", "tutti.createIndividualObservationBatch.action.cancel.help");
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new Table());
        
        configurationPanel.setName("configurationPanel");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(CreateIndividualObservationBatchUIHandler.class));
    }

    protected void createIndividualObservationCreateFromBatch() {
        $objectMap.put("individualObservationCreateFromBatch", individualObservationCreateFromBatch = new JCheckBox());
        
        individualObservationCreateFromBatch.setName("individualObservationCreateFromBatch");
        individualObservationCreateFromBatch.setText(_("tutti.createIndividualObservationBatch.field.createFromBatch"));
        individualObservationCreateFromBatch.setToolTipText(_("tutti.createIndividualObservationBatch.field.createFromBatch.tip"));
        individualObservationCreateFromBatch.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__individualObservationCreateFromBatch"));
        individualObservationCreateFromBatch.putClientProperty("help", "tutti.createIndividualObservationBatch.field.createFromBatch.help");
    }

    protected void createIndividualObservationLengthStepCaracteristicComboBox() {
        $objectMap.put("individualObservationLengthStepCaracteristicComboBox", individualObservationLengthStepCaracteristicComboBox = new BeanFilterableComboBox<Caracteristic>(this));
        
        individualObservationLengthStepCaracteristicComboBox.setName("individualObservationLengthStepCaracteristicComboBox");
        individualObservationLengthStepCaracteristicComboBox.setProperty("lengthStepCaracteristic");
        individualObservationLengthStepCaracteristicComboBox.setShowReset(true);
    }

    protected void createIndividualObservationLengthStepCaracteristicLabel() {
        $objectMap.put("individualObservationLengthStepCaracteristicLabel", individualObservationLengthStepCaracteristicLabel = new JLabel());
        
        individualObservationLengthStepCaracteristicLabel.setName("individualObservationLengthStepCaracteristicLabel");
        individualObservationLengthStepCaracteristicLabel.setText(_("tutti.createIndividualObservationBatch.field.individualObservationLengthStepCaracteristic"));
        individualObservationLengthStepCaracteristicLabel.setToolTipText(_("tutti.createIndividualObservationBatch.field.individualObservationLengthStepCaracteristic.tip"));
        individualObservationLengthStepCaracteristicLabel.putClientProperty("help", "tutti.createIndividualObservationBatch.field.individualObservationLengthStepCaracteristic.help");
    }

    protected void createIndividualObservationSizeField() {
        $objectMap.put("individualObservationSizeField", individualObservationSizeField = new NumberEditor(this));
        
        individualObservationSizeField.setName("individualObservationSizeField");
        individualObservationSizeField.setProperty("size");
        individualObservationSizeField.setUseFloat(true);
        individualObservationSizeField.setShowReset(true);
    }

    protected void createIndividualObservationSizeLabel() {
        $objectMap.put("individualObservationSizeLabel", individualObservationSizeLabel = new JLabel());
        
        individualObservationSizeLabel.setName("individualObservationSizeLabel");
        individualObservationSizeLabel.setText(_("tutti.createIndividualObservationBatch.field.individualObservationSize"));
        individualObservationSizeLabel.setToolTipText(_("tutti.createIndividualObservationBatch.field.individualObservationSize.tip"));
        individualObservationSizeLabel.putClientProperty("help", "tutti.createIndividualObservationBatch.field.individualObservationSize.help");
    }

    protected void createIndividualObservationSpeciesComboBox() {
        $objectMap.put("individualObservationSpeciesComboBox", individualObservationSpeciesComboBox = new BeanFilterableComboBox<Species>(this));
        
        individualObservationSpeciesComboBox.setName("individualObservationSpeciesComboBox");
        individualObservationSpeciesComboBox.setProperty("species");
        individualObservationSpeciesComboBox.setShowReset(true);
    }

    protected void createIndividualObservationSpeciesLabel() {
        $objectMap.put("individualObservationSpeciesLabel", individualObservationSpeciesLabel = new JLabel());
        
        individualObservationSpeciesLabel.setName("individualObservationSpeciesLabel");
        individualObservationSpeciesLabel.setText(_("tutti.createIndividualObservationBatch.field.individualObservationSpecies"));
        individualObservationSpeciesLabel.setToolTipText(_("tutti.createIndividualObservationBatch.field.individualObservationSpecies.tip"));
        individualObservationSpeciesLabel.putClientProperty("help", "tutti.createIndividualObservationBatch.field.individualObservationSpecies.help");
    }

    protected void createIndividualObservationWeightField() {
        $objectMap.put("individualObservationWeightField", individualObservationWeightField = new NumberEditor(this));
        
        individualObservationWeightField.setName("individualObservationWeightField");
        individualObservationWeightField.setProperty("weight");
        individualObservationWeightField.setUseFloat(true);
        individualObservationWeightField.setShowReset(true);
    }

    protected void createIndividualObservationWeightLabel() {
        $objectMap.put("individualObservationWeightLabel", individualObservationWeightLabel = new JLabel());
        
        individualObservationWeightLabel.setName("individualObservationWeightLabel");
        individualObservationWeightLabel.setText(_("tutti.createIndividualObservationBatch.field.individualObservationWeight"));
        individualObservationWeightLabel.setToolTipText(_("tutti.createIndividualObservationBatch.field.individualObservationWeight.tip"));
        individualObservationWeightLabel.putClientProperty("help", "tutti.createIndividualObservationBatch.field.individualObservationWeight.help");
        individualObservationWeightLabel.putClientProperty("addWeightUnit", handler.getConfig().getIndividualObservationWeightUnit());
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(CreateIndividualObservationBatchUIModel.class));
    }

    protected void createSaveAndCloseButton() {
        $objectMap.put("saveAndCloseButton", saveAndCloseButton = new JButton());
        
        saveAndCloseButton.setName("saveAndCloseButton");
        saveAndCloseButton.setText(_("tutti.createIndividualObservationBatch.action.saveAndClose"));
        saveAndCloseButton.setToolTipText(_("tutti.createIndividualObservationBatch.action.saveAndClose.tip"));
        saveAndCloseButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveAndCloseButton"));
        saveAndCloseButton.putClientProperty("help", "tutti.createIndividualObservationBatch.action.saveAndClose.help");
    }

    protected void createSaveAndContinueButton() {
        $objectMap.put("saveAndContinueButton", saveAndContinueButton = new JButton());
        
        saveAndContinueButton.setName("saveAndContinueButton");
        saveAndContinueButton.setText(_("tutti.createIndividualObservationBatch.action.saveAndContinue"));
        saveAndContinueButton.setToolTipText(_("tutti.createIndividualObservationBatch.action.saveAndContinue.tip"));
        saveAndContinueButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveAndContinueButton"));
        saveAndContinueButton.putClientProperty("help", "tutti.createIndividualObservationBatch.action.saveAndContinue.help");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(CreateIndividualObservationBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToCreateIndividualObservationBatchTopPanel();
        addChildrenToValidator();
        addChildrenToConfigurationPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(saveAndContinueButton);
        $JPanel0.add(saveAndCloseButton);
        
        // apply 9 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 23 property setters
        individualObservationSpeciesComboBox.setBeanType(Species.class);
        individualObservationLengthStepCaracteristicComboBox.setBeanType(Caracteristic.class);
        individualObservationSpeciesLabel.setLabelFor(individualObservationSpeciesComboBox);
        individualObservationSpeciesComboBox.setBean(model);
        addSpeciesButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.createIndividualObservationBatch.action.addSpecies.mnemonic"),'Z'));
        individualObservationWeightLabel.setLabelFor(individualObservationWeightField);
        individualObservationWeightField.setBean(model);
        individualObservationWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        individualObservationWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        individualObservationSizeLabel.setLabelFor(individualObservationSizeField);
        individualObservationSizeField.setBean(model);
        individualObservationSizeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        individualObservationSizeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        individualObservationLengthStepCaracteristicLabel.setLabelFor(individualObservationLengthStepCaracteristicComboBox);
        individualObservationLengthStepCaracteristicComboBox.setBean(model);
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.createIndividualObservationBatch.action.cancel.mnemonic"),'Z'));
        saveAndContinueButton.setIcon(SwingUtil.createActionIcon("save"));
        saveAndContinueButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.createIndividualObservationBatch.action.saveAndContinue.mnemonic"),'Z'));
        saveAndCloseButton.setIcon(SwingUtil.createActionIcon("save"));
        saveAndCloseButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.createIndividualObservationBatch.action.saveAndClose.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, createIndividualObservationBatchTopPanel, "tutti.createIndividualObservationBatch.help");
        registerHelpId(_broker, individualObservationSpeciesLabel, "tutti.createIndividualObservationBatch.field.individualObservationSpecies.help");
        registerHelpId(_broker, addSpeciesButton, "tutti.createIndividualObservationBatch.action.addSpecies.help");
        registerHelpId(_broker, individualObservationCreateFromBatch, "tutti.createIndividualObservationBatch.field.createFromBatch.help");
        registerHelpId(_broker, individualObservationWeightLabel, "tutti.createIndividualObservationBatch.field.individualObservationWeight.help");
        registerHelpId(_broker, individualObservationSizeLabel, "tutti.createIndividualObservationBatch.field.individualObservationSize.help");
        registerHelpId(_broker, individualObservationLengthStepCaracteristicLabel, "tutti.createIndividualObservationBatch.field.individualObservationLengthStepCaracteristic.help");
        registerHelpId(_broker, cancelButton, "tutti.createIndividualObservationBatch.action.cancel.help");
        registerHelpId(_broker, saveAndContinueButton, "tutti.createIndividualObservationBatch.action.saveAndContinue.help");
        registerHelpId(_broker, saveAndCloseButton, "tutti.createIndividualObservationBatch.action.saveAndClose.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("createIndividualObservationBatchTopPanel", createIndividualObservationBatchTopPanel);
        createHandler();
        createModel();
        createValidator();
        createBroker();
        createConfigurationPanel();
        createIndividualObservationSpeciesLabel();
        createIndividualObservationSpeciesComboBox();
        createAddSpeciesButton();
        createIndividualObservationCreateFromBatch();
        createIndividualObservationWeightLabel();
        createIndividualObservationWeightField();
        createIndividualObservationSizeLabel();
        createIndividualObservationSizeField();
        createIndividualObservationLengthStepCaracteristicLabel();
        createIndividualObservationLengthStepCaracteristicComboBox();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createSaveAndContinueButton();
        createSaveAndCloseButton();
        // inline creation of createIndividualObservationBatchTopPanel
        setName("createIndividualObservationBatchTopPanel");
        setLayout(new BorderLayout());
        createIndividualObservationBatchTopPanel.putClientProperty("help", "tutti.createIndividualObservationBatch.help");
        
        // registers 9 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 9 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INDIVIDUAL_OBSERVATION_SPECIES_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("species", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    individualObservationSpeciesComboBox.setSelectedItem(model.getSpecies());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("species", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INDIVIDUAL_OBSERVATION_SPECIES_COMBO_BOX_DATA, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("availableSpecies", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    individualObservationSpeciesComboBox.setData(model.getAvailableSpecies());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("availableSpecies", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INDIVIDUAL_OBSERVATION_CREATE_FROM_BATCH_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesFromBatch", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    individualObservationCreateFromBatch.setEnabled(model.isSpeciesFromBatch());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesFromBatch", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INDIVIDUAL_OBSERVATION_CREATE_FROM_BATCH_SELECTED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesFromBatch", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("createFromBatch", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    individualObservationCreateFromBatch.setSelected(model.isSpeciesFromBatch() && model.isCreateFromBatch());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesFromBatch", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("createFromBatch", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INDIVIDUAL_OBSERVATION_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("weight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    individualObservationWeightField.setModel(model.getWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("weight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INDIVIDUAL_OBSERVATION_SIZE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("size", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    individualObservationSizeField.setModel(model.getSize());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("size", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_INDIVIDUAL_OBSERVATION_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    individualObservationLengthStepCaracteristicComboBox.setSelectedItem(model.getLengthStepCaracteristic());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CONTINUE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndContinueButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_AND_CLOSE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveAndCloseButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}