package fr.ifremer.tutti.ui.swing.content.operation;

/*
 * #%L
 * Tutti :: UI
 * $Id: AbstractTuttiBatchTableUIHandler.java 1274 2013-10-04 07:14:17Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.7/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/AbstractTuttiBatchTableUIHandler.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.sort.TableSortController;

import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;

/**
 * Abstract ui handler forbatch ui.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public abstract class AbstractTuttiBatchTableUIHandler<R extends AbstractTuttiBeanUIModel, M extends AbstractTuttiBatchUIModel<R, M>, UI extends TuttiUI<M, ?>> extends AbstractTuttiTableUIHandler<R, M, UI> {

    protected abstract ColumnIdentifier<R> getCommentIdentifier();

    protected abstract ColumnIdentifier<R> getAttachementIdentifier();

    public abstract void selectFishingOperation(FishingOperation bean);

    protected AbstractTuttiBatchTableUIHandler(TuttiUI<?, ?> parentUi,
                                               UI ui,
                                               String... properties) {
        super(parentUi.getHandler().getContext(), ui, properties);
    }

    /**
     * To clear the table selection.
     * <p/>
     * This method is invoked before changing the fishing operation.
     *
     * @since 0.3
     */
    public final void clearTableSelection() {

        JXTable table = getTable();

        if (table.isEditing()) {

            // make sure to stop editor
            table.editingCanceled(null);
        }

        // make sure selection is empty (will remove bean from monitor)
        table.clearSelection();
    }

    @Override
    protected void onRowModified(int rowIndex,
                                       R row,
                                       String propertyName,
                                       Object oldValue,
                                       Object newValue) {
        recomputeRowValidState(row);

        saveSelectedRowIfNeeded();
    }

    protected void initBatchTable(JXTable table,
                                  TableColumnModel columnModel,
                                  AbstractTuttiTableModel<R> tableModel) {

        installTableKeyListener(columnModel, table);

        TableSortController<TableModel> sorter = new TableSortController<TableModel>(tableModel);
        sorter.setSortable(false);
        table.setRowSorter(sorter);

        initTable(table);
    }

    @Override
    protected void addHighlighters(final JXTable table) {
        super.addHighlighters(table);
        addCommentHighlighter(table, getCommentIdentifier());
        addAttachementHighlighter(table, getAttachementIdentifier());
    }

    protected void addCommentHighlighter(JXTable table, ColumnIdentifier identifier) {
        Color cellWithValueColor = getConfig().getColorCellWithValue();

        Highlighter commentHighlighter = TuttiUIUtil.newBackgroundColorHighlighter(
                new HighlightPredicate.AndHighlightPredicate(
                        new HighlightPredicate.IdentifierHighlightPredicate(identifier),
                        // for not null value
                        new HighlightPredicate() {
                            @Override
                            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                                String value = (String) adapter.getValue();
                                return StringUtils.isNotBlank(value);
                            }
                        }), cellWithValueColor);
        table.addHighlighter(commentHighlighter);
    }

    protected void addAttachementHighlighter(JXTable table, ColumnIdentifier identifier) {
        Color cellWithValueColor = getConfig().getColorCellWithValue();

        Highlighter attachmentHighlighter = TuttiUIUtil.newBackgroundColorHighlighter(
                new HighlightPredicate.AndHighlightPredicate(
                        new HighlightPredicate.IdentifierHighlightPredicate(identifier),
                        // for not null value
                        new HighlightPredicate() {
                            @Override
                            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                                Collection attachments = (Collection) adapter.getValue();
                                return CollectionUtils.isNotEmpty(attachments);
                            }
                        }
                ), cellWithValueColor);
        table.addHighlighter(attachmentHighlighter);
    }
}
