/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.referential;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.service.referential.ReferentialImportExportService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUI;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUIHandler;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ImportTemporaryGearAction
extends AbstractTuttiAction<TuttiUIContext, ManageTemporaryReferentialUI, ManageTemporaryReferentialUIHandler> {
    private static final Log log = LogFactory.getLog(ImportTemporaryGearAction.class);
    private File file;

    public ImportTemporaryGearAction(ManageTemporaryReferentialUIHandler handler) {
        super(handler, true);
    }

    @Override
    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = this.chooseFile(I18n._((String)"tutti.manageTemporaryReferential.title.choose.importTemporaryGearFile", (Object[])new Object[0]), I18n._((String)"tutti.manageTemporaryReferential.action.chooseReferentialGearFile.import", (Object[])new Object[0]), "^.*\\.csv", I18n._((String)"tutti.common.file.csv", (Object[])new Object[0]));
            doAction = this.file != null;
        }
        return doAction;
    }

    @Override
    public void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import gear temporary referential from file: " + this.file));
        }
        ReferentialImportExportService service = this.getContext().getTuttiReferentialImportExportService();
        service.importTemporaryGear(this.file);
        this.getDataContext().resetGears();
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        this.sendMessage(I18n._((String)"tutti.manageTemporaryReferential.action.chooseReferentialGearFile.import.success", (Object[])new Object[]{this.file}));
    }
}

