package fr.ifremer.tutti.ui.swing.util.species;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class SelectSpeciesUI extends JPanel implements TuttiUI<SelectSpeciesUIModel, SelectSpeciesUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_SPECIES_COMBO_DATA = "speciesCombo.data";
    public static final String BINDING_SPECIES_COMBO_SELECTED_ITEM = "speciesCombo.selectedItem";
    public static final String BINDING_VALIDATE_BUTTON_ENABLED = "validateButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1US28URxCu3ezDLx6Jg0USkGxeIVE0CxEgJIcABlkY2YBYO0LZC70zjbdRb3enuwaPFSXKT8hPSO65IOWWU8SBM4dcovyFCHHgiqiemX167bW80rZ26/F11ddf1R//Q9lZWHjKkiSwsULR5sHdm48e3W8+5SHe5i60wqC2kH0KRSg2YDrq2h3C6caqT6/l6bVbum204qove3EVphxuS+5anCPCycGM0LlaveteTExsO6jdokah/vbmdfHX6JffiwCJoeqq1Mr8uKxeJ6VVKIoI4SO66RmrSaY2qQwr1CbVe8jbbknm3D3W5j/Az1BdhYphlsAQTu2/5RQjzU8M3eW4JGLrhoeCuwfaxGS88sQG4onlbW4DjBFFEIvAbVEhQYxCBi6LDur9uRsrxqS4FYRqi6lIcotw7WBQd7L8HmK5rSMuERYPhrfms3toM3kY8dTUCJcH3ihD45Eg1oImZypYomNZSOSWNYlAn7SkE4812YWcOHP3AVNcXiBO/VMlOU5mHYydCZkKuVyi+rVCmB2Iz6w+8lg34fAzJkXEkPecn+YRFj4bqJ60G/S02xNXoQFlG5MZ4Xhjp9wfkisT+vEhoXvA1Ptubvafv/77c7mj7grdfWxkaN9wkuqM1YakIPzVRzJp+6eqrTGz2IDJTIDp5J4YUVg9d1NxdN+HPj176TvMtQiiXP337xdzj199AMVlmJKaRcvMx6/AJLYssaBllJjrN9KKZrYm6DxK3zJCyb8tafXHVFo/eVWkd/FoBXmbqskcwSbHeu7I9XT+C4ou0XswhI/7ovq8E3nX29SzG8xG6rmltx5y51dPCW3ME+L9xAjeu803J1++na0/v9HhvkBcfLJreI//8vdQEUoKxdPdkq+Nkbtk2jgeR7q3HkYtDBiaHZPP1Kn0PLeD5pJvkCfU50I2rQPrJqCXEloF2TggTGX/V0I/FZWOdUZcvKrWFG9rJUKEL8cCBe1u8DRqLdeFWU9rODs+FYVJYt/L1ynL/tclGJrYcU2Ttqpc+VVBy/zMHiqaX7g2r2LptZezdHqPCjs7YJgnFobc4A6evtoH1K5Mfb6f5F24GlpW49gqUAuSbWsKhsPf+KGabwoV0S78dgd6wZ9T+0Cc8LO9vm1ScX83Gmd2LI43b+yBMEcI7wGHKQ8jsggAAA==";
    private static final Log log = LogFactory.getLog(SelectSpeciesUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton cancelButton;
    protected SelectSpeciesUIHandler handler;
    protected SelectSpeciesUIModel model;
    protected SelectSpeciesUI selectSpeciesPopup = this;
    protected BeanFilterableComboBox<Species> speciesCombo;
    protected JButton validateButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SelectSpeciesUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            SelectSpeciesUIHandler handler = new SelectSpeciesUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public SelectSpeciesUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectSpeciesUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectSpeciesUI() {
        $initialize();
    }

    public SelectSpeciesUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectSpeciesUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SelectSpeciesUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectSpeciesUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SelectSpeciesUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__validateButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.validate();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancelButton() {
        return cancelButton;
    }

    public SelectSpeciesUIHandler getHandler() {
        return handler;
    }

    public SelectSpeciesUIModel getModel() {
        return model;
    }

    public BeanFilterableComboBox<Species> getSpeciesCombo() {
        return speciesCombo;
    }

    public JButton getValidateButton() {
        return validateButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToSelectSpeciesPopup() {
        if (!allComponentsCreated) {
            return;
        }
        add(speciesCombo, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.selectSpecies.action.cancel"));
        cancelButton.setToolTipText(_("tutti.selectSpecies.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(SelectSpeciesUIHandler.class));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SelectSpeciesUIModel.class));
    }

    protected void createSpeciesCombo() {
        $objectMap.put("speciesCombo", speciesCombo = new BeanFilterableComboBox<Species>(this));
        
        speciesCombo.setName("speciesCombo");
        speciesCombo.setProperty("selectedSpecies");
        speciesCombo.setShowReset(true);
    }

    protected void createValidateButton() {
        $objectMap.put("validateButton", validateButton = new JButton());
        
        validateButton.setName("validateButton");
        validateButton.setText(_("tutti.selectSpecies.action.validate"));
        validateButton.setToolTipText(_("tutti.selectSpecies.action.validate.tip"));
        validateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validateButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToSelectSpeciesPopup();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(validateButton);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 8 property setters
        speciesCombo.setBeanType(Species.class);
        speciesCombo.setBean(model);
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.selectSpecies.action.cancel.mnemonic"),'Z'));
        validateButton.setIcon(SwingUtil.createActionIcon("accept"));
        validateButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.selectSpecies.action.validate.mnemonic"),'Z'));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("selectSpeciesPopup", selectSpeciesPopup);
        createHandler();
        createModel();
        createSpeciesCombo();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createValidateButton();
        // inline creation of selectSpeciesPopup
        setName("selectSpeciesPopup");
        setLayout(new BorderLayout());
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_COMBO_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedSpecies", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesCombo.setSelectedItem(model.getSelectedSpecies());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedSpecies", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_COMBO_DATA, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("species", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesCombo.setData(model.getSpecies());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("species", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VALIDATE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("selectedSpecies", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    validateButton.setEnabled(model.getSelectedSpecies() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("selectedSpecies", this);
                }
            }
        });
    }

}