package fr.ifremer.tutti.ui.swing.content.operation;

/*
 * #%L
 * Tutti :: UI
 * $Id: DeleteFishingOperationAction.java 1170 2013-09-13 16:21:34Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.6/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/DeleteFishingOperationAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import static org.nuiton.i18n.I18n._;

/**
 * To delete a fishing operation.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.2
 */
public class DeleteFishingOperationAction extends AbstractTuttiAction<FishingOperationsUIModel, FishingOperationsUI, FishingOperationsUIHandler> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(DeleteFishingOperationAction.class);

    public DeleteFishingOperationAction(FishingOperationsUIHandler handler) {
        super(handler, true);
        setActionDescription(
                _("tutti.editFishingOperation.action.deleteFishingOperation.tip"));
    }

    @Override
    public boolean prepareAction() throws Exception {
        boolean canContinue = super.prepareAction();
        FishingOperation fishingOperation = getModel().getSelectedFishingOperation();
        canContinue &= fishingOperation != null &&
                       !TuttiEntities.isNew(fishingOperation) &&
                       askBeforeDelete(
                               _("tutti.editFishingOperation.action.deleteFishingOperation.title"),
                               _("tutti.editFishingOperation.action.deleteFishingOperation.message", decorate(fishingOperation))
                       );
        return canContinue;
    }

    @Override
    public void doAction() throws Exception {

        FishingOperation fishingOperation =
                getModel().getSelectedFishingOperation();

        if (log.isInfoEnabled()) {
            log.info("Will delete fishingOperation: " + fishingOperation);
        }

        getContext().getPersistenceService().deleteFishingOperation(fishingOperation.getId());

        FishingOperationsUIModel model = getModel();

        // unselect removed fishing operation
        model.setSelectedFishingOperation(null);

        // remove it from selection model
        model.removeFishingOperation(fishingOperation);

        sendMessage(_("tutti.editFishingOperation.message.operation.deleted", decorate(fishingOperation)));
    }
}