/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.TuttiBusinessException;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.ui.swing.util.TuttiColorHighlighter;
import java.awt.Color;
import java.awt.Desktop;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.nuiton.i18n.I18n;

public final class TuttiUIUtil {
    private static final Log log = LogFactory.getLog(TuttiUIUtil.class);
    public static final double EARTH_RADIUS = 6378288.0;
    private static DecimalFormatSymbols symbols;
    private static DecimalFormat decimalFormat;

    private TuttiUIUtil() {
    }

    public static void setProperty(Object bean, String property, Object value) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)property);
        try {
            PropertyUtils.setSimpleProperty((Object)bean, (String)property, (Object)value);
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.property.set.error", (Object[])new Object[]{property, bean.getClass().getName()}), (Throwable)e);
        }
    }

    public static Object getProperty(Object bean, String property) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)property);
        try {
            return PropertyUtils.getSimpleProperty((Object)bean, (String)property);
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.property.get.error", (Object[])new Object[]{property, bean.getClass().getName()}), (Throwable)e);
        }
    }

    public static Highlighter newBackgroundColorHighlighter(HighlightPredicate predicate, Color color) {
        return new TuttiColorHighlighter(predicate, color, false);
    }

    public static Highlighter newForegroundColorHighlighter(HighlightPredicate predicate, Color color) {
        return new TuttiColorHighlighter(predicate, color, true);
    }

    public static int computeDistanceInMeters(Float startLatitude, Float startLongitude, Float endLatitude, Float endLongitude) {
        double sLat = (double)startLatitude.floatValue() * Math.PI / 180.0;
        double sLong = (double)startLongitude.floatValue() * Math.PI / 180.0;
        double eLat = (double)endLatitude.floatValue() * Math.PI / 180.0;
        double eLong = (double)endLongitude.floatValue() * Math.PI / 180.0;
        Double d = 6378288.0 * (1.5707963267948966 - Math.asin(Math.sin(eLat) * Math.sin(sLat) + Math.cos(eLong - sLong) * Math.cos(eLat) * Math.cos(sLat)));
        return d.intValue();
    }

    public static String getDistanceInMilles(Float distance) {
        String distanceText;
        if (distance != null) {
            Float distanceInMilles = Float.valueOf(distance.floatValue() / 1852.0f);
            distanceText = String.format("%.3f", distanceInMilles);
        } else {
            distanceText = "";
        }
        return distanceText;
    }

    public static DecimalFormatSymbols getDecimalFormatSymbols() {
        if (symbols == null) {
            symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
            symbols.setGroupingSeparator(' ');
        }
        return symbols;
    }

    public static DecimalFormat getDecimalFormat(int minDecimal, int maxDecimal) {
        if (decimalFormat == null) {
            decimalFormat = new DecimalFormat();
            decimalFormat.setDecimalFormatSymbols(TuttiUIUtil.getDecimalFormatSymbols());
            decimalFormat.setGroupingUsed(false);
        }
        decimalFormat.setMinimumFractionDigits(minDecimal);
        decimalFormat.setMaximumFractionDigits(maxDecimal);
        return decimalFormat;
    }

    public static String getWeightStringValue(Float weight) {
        String textValue;
        if (weight != null) {
            DecimalFormat weightDecimalFormat = TuttiUIUtil.getDecimalFormat(1, 3);
            textValue = weightDecimalFormat.format(weight);
        } else {
            textValue = "";
        }
        return textValue;
    }

    public static void openLink(URL url) {
        try {
            TuttiUIUtil.openLink(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new TuttiTechnicalException(I18n._((String)"swing.error.cannot.open.link", (Object[])new Object[]{url}), (Throwable)e);
        }
    }

    public static Desktop getDesktopForBrowse() {
        if (!Desktop.isDesktopSupported()) {
            throw new TuttiTechnicalException(I18n._((String)"swing.error.desktop.not.supported", (Object[])new Object[0]));
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.BROWSE)) {
            throw new TuttiTechnicalException(I18n._((String)"swing.error.desktop.browse.not.supported", (Object[])new Object[0]));
        }
        return desktop;
    }

    public static void openLink(URI uri) {
        Desktop desktop = TuttiUIUtil.getDesktopForBrowse();
        try {
            desktop.browse(uri);
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"swing.error.cannot.open.link", (Object[])new Object[]{uri}), (Throwable)e);
        }
    }

    public static Desktop getDesktopForMail() {
        if (!Desktop.isDesktopSupported()) {
            throw new TuttiTechnicalException(I18n._((String)"swing.error.desktop.not.supported", (Object[])new Object[0]));
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.MAIL)) {
            throw new TuttiTechnicalException(I18n._((String)"swing.error.desktop.mail.not.supported", (Object[])new Object[0]));
        }
        return desktop;
    }

    public static void mail(String subject, String body) {
        Desktop desktop = TuttiUIUtil.getDesktopForMail();
        try {
            URI mailtoURI = new URI("mailto", null, null, "subject=" + subject + "&body=" + body, null);
            desktop.mail(mailtoURI);
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"swing.error.cannot.mail", (Object[])new Object[0]), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryToConnectToUpdateUrl(String urlAsString, String badUrlFormatI18nKey, String notReachI18nKey, String notFoundI18nKey) {
        URLConnection urlConnection;
        URL url;
        try {
            url = new URL(urlAsString);
        }
        catch (MalformedURLException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Bad url syntax at " + urlAsString), (Throwable)e);
            }
            throw new TuttiBusinessException(I18n._((String)badUrlFormatI18nKey, (Object[])new Object[]{urlAsString}));
        }
        try {
            urlConnection = url.openConnection();
            urlConnection.setConnectTimeout(10000);
            urlConnection.connect();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Could not connect to " + urlAsString), (Throwable)e);
            }
            throw new TuttiBusinessException(I18n._((String)notReachI18nKey, (Object[])new Object[]{urlAsString}));
        }
        try {
            urlConnection.setReadTimeout(1000);
            InputStream inputStream = null;
            try {
                inputStream = urlConnection.getInputStream();
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Could not found file at to " + urlAsString), (Throwable)e);
            }
            throw new TuttiBusinessException(I18n._((String)notFoundI18nKey, (Object[])new Object[]{urlAsString}));
        }
    }

    public static float getRoundedLengthStep(float lengthStep, boolean aroundUp) {
        int intValue = (int)((lengthStep + (aroundUp ? 0.001f : 0.0f)) * 10.0f);
        float result = (float)intValue / 10.0f;
        return result;
    }
}

