/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util;

import fr.ifremer.tutti.TuttiBusinessException;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import java.awt.Component;
import javax.swing.JOptionPane;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.error.ErrorReporter;
import org.nuiton.i18n.I18n;

public class TuttiErrorHelper
implements ErrorReporter {
    protected TuttiUIContext context;

    public TuttiErrorHelper(TuttiUIContext context) {
        this.context = context;
    }

    public void showErrorDialog(String message, Throwable cause) {
        if (cause == null) {
            JOptionPane.showMessageDialog(this.context.getMainUI(), "<html><body>" + message + "</body></html>", I18n._((String)"tutti.error.ui.business.error", (Object[])new Object[0]), 0);
        } else if (cause instanceof TuttiBusinessException) {
            JOptionPane.showMessageDialog(this.context.getMainUI(), "<html><body>" + cause.getMessage() + "</body></html>", I18n._((String)"tutti.error.ui.business.error", (Object[])new Object[0]), 0);
        } else {
            JXErrorPane pane = new JXErrorPane();
            ErrorInfo info = new ErrorInfo(I18n._((String)"tutti.error.ui.other.error", (Object[])new Object[0]), I18n._((String)"tutti.error.errorpane.htmlmessage", (Object[])new Object[]{message}), null, null, cause, null, null);
            pane.setErrorInfo(info);
            pane.setErrorReporter((ErrorReporter)this);
            JXErrorPane.showDialog((Component)this.context.getActionUI(), (JXErrorPane)pane);
        }
    }

    public void showErrorDialog(String message) {
        this.showErrorDialog(message, null);
    }

    public void reportError(ErrorInfo errorInfo) throws NullPointerException {
        this.showErrorDialog(errorInfo.getBasicErrorMessage(), errorInfo.getErrorException());
    }

    public void showWarningDialog(String message) {
        JOptionPane.showMessageDialog(this.context.getMainUI(), "<html><body>" + message + "</body></html>", I18n._((String)"tutti.error.ui.business.warning", (Object[])new Object[0]), 2);
    }
}

