/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.db;

import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.db.DbManagerUI;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Version;

public class DbManagerUIHandler
extends AbstractTuttiUIHandler<TuttiUIContext, DbManagerUI> {
    public DbManagerUIHandler(TuttiUIContext context, DbManagerUI ui) {
        super(context, ui);
    }

    @Override
    public void beforeInitUI() {
    }

    public String updateMessage(boolean dbExist, boolean dbLoaded) {
        String message;
        if (dbExist) {
            String jdbcUrl = this.getConfig().getServiceConfig().getPersistenceConfig().getJdbcUrl();
            if (dbLoaded) {
                Version dbVersion = this.getContext().getPersistenceService().getDbVersion();
                message = I18n._((String)"tutti.dbManager.info.db.loaded", (Object[])new Object[]{jdbcUrl, dbVersion});
            } else {
                message = I18n._((String)"tutti.dbManager.info.no.db.loaded", (Object[])new Object[]{jdbcUrl});
            }
        } else {
            message = I18n._((String)"tutti.dbManager.info.no.db.exist", (Object[])new Object[0]);
        }
        return "<html><body>" + message + "</body></html>";
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        ((TuttiUIContext)this.getModel()).addPropertyChangeListener("dbExist", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean dbExist = (Boolean)evt.getNewValue();
                String mnemonic = dbExist != false ? I18n._((String)"tutti.dbManager.action.reinstallDb.mnemonic", (Object[])new Object[0]) : I18n._((String)"tutti.dbManager.action.installDb.mnemonic", (Object[])new Object[0]);
                if (StringUtils.isNotBlank((CharSequence)mnemonic)) {
                    ((DbManagerUI)DbManagerUIHandler.this.ui).getInstallOrReinstallDbButton().setMnemonic(mnemonic.charAt(0));
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DbManagerUIHandler.this.getContext().getMainUI().getBody().repaint();
            }
        });
    }

    @Override
    protected JComponent getComponentToFocus() {
        return ((DbManagerUI)this.getUI()).getUpgradeDbButton();
    }

    @Override
    public void onCloseUI() {
    }

    @Override
    public SwingValidator<TuttiUIContext> getValidator() {
        return null;
    }

    public String getInstallButtonText(boolean dbExist) {
        String result = dbExist ? I18n._((String)"tutti.dbManager.action.reinstallDb", (Object[])new Object[0]) : I18n._((String)"tutti.dbManager.action.installDb", (Object[])new Object[0]);
        return result;
    }

    public String getInstallButtonTip(boolean dbExist) {
        String result = dbExist ? I18n._((String)"tutti.dbManager.action.reinstallDb.tip", (Object[])new Object[0]) : I18n._((String)"tutti.dbManager.action.installDb.tip", (Object[])new Object[0]);
        return result;
    }
}

