/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.typeconversion.core;

import java.text.ParseException;
import liquibase.database.Database;
import liquibase.database.core.CacheDatabase;
import liquibase.database.structure.type.BlobType;
import liquibase.database.structure.type.BooleanType;
import liquibase.database.structure.type.ClobType;
import liquibase.database.structure.type.CurrencyType;
import liquibase.database.typeconversion.core.AbstractTypeConverter;

public class CacheTypeConverter
extends AbstractTypeConverter {
    public int getPriority() {
        return 5;
    }

    public boolean supports(Database database) {
        return database instanceof CacheDatabase;
    }

    public Object convertDatabaseValueToObject(Object defaultValue, int dataType, int columnSize, int decimalDigits, Database database) throws ParseException {
        if (defaultValue != null && defaultValue instanceof String) {
            String stringDefaultValue = (String)defaultValue;
            if (stringDefaultValue.charAt(0) == '\"' && stringDefaultValue.charAt(stringDefaultValue.length() - 1) == '\"') {
                defaultValue = stringDefaultValue.substring(1, stringDefaultValue.length() - 1);
            } else if (stringDefaultValue.startsWith("$")) {
                defaultValue = "OBJECTSCRIPT '" + defaultValue + "'";
            }
        }
        return super.convertDatabaseValueToObject(defaultValue, dataType, columnSize, decimalDigits, database);
    }

    public BlobType getBlobType() {
        return new BlobType("LONGVARBINARY");
    }

    public BooleanType getBooleanType() {
        return new BooleanType.NumericBooleanType();
    }

    public ClobType getClobType() {
        return new ClobType("LONGVARCHAR");
    }

    public CurrencyType getCurrencyType() {
        return new CurrencyType("MONEY");
    }
}

