/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SampleCategoryAble;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SampleCategoryColumnIdentifier;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.table.TableColumn;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.i18n.I18n;

public class SpeciesBatchTableModel
extends AbstractTuttiTableModel<SpeciesBatchRowModel> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SpeciesBatchTableModel.class);
    public static final ColumnIdentifier<SpeciesBatchRowModel> SPECIES = ColumnIdentifier.newId("species", I18n.n_((String)"tutti.editSpeciesBatch.table.header.species", (Object[])new Object[0]), I18n.n_((String)"tutti.editSpeciesBatch.table.header.species", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> WEIGHT = ColumnIdentifier.newId("computedOrNotWeight", I18n.n_((String)"tutti.editSpeciesBatch.table.header.weight", (Object[])new Object[0]), I18n.n_((String)"tutti.editSpeciesBatch.table.header.weight", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> COMPUTED_NUMBER = ColumnIdentifier.newId("computedOrNotNumber", I18n.n_((String)"tutti.editSpeciesBatch.table.header.computedNumber", (Object[])new Object[0]), I18n.n_((String)"tutti.editSpeciesBatch.table.header.computedNumber", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> COMMENT = ColumnIdentifier.newId("comment", I18n.n_((String)"tutti.editSpeciesBatch.table.header.comment", (Object[])new Object[0]), I18n.n_((String)"tutti.editSpeciesBatch.table.header.comment", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> ATTACHMENT = ColumnIdentifier.newReadOnlyId("attachment", I18n.n_((String)"tutti.editSpeciesBatch.table.header.file", (Object[])new Object[0]), I18n.n_((String)"tutti.editSpeciesBatch.table.header.file", (Object[])new Object[0]));
    public static final ColumnIdentifier<SpeciesBatchRowModel> SPECIES_TO_CONFIRM = ColumnIdentifier.newId("speciesToConfirm", I18n.n_((String)"tutti.editSpeciesBatch.table.header.toConfirm", (Object[])new Object[0]), I18n.n_((String)"tutti.editSpeciesBatch.table.header.toConfirm", (Object[])new Object[0]));
    protected final Set<ColumnIdentifier<SpeciesBatchRowModel>> frequencyCols;
    protected final Set<SampleCategoryColumnIdentifier<SpeciesBatchRowModel>> sampleCols;
    protected final SampleCategoryModel sampleCategoryModel;

    public SpeciesBatchTableModel(SampleCategoryModel sampleCategoryModel, TableColumnModelExt columnModel) {
        super(columnModel, false, false);
        this.sampleCategoryModel = sampleCategoryModel;
        this.setNoneEditableCols(SPECIES);
        this.frequencyCols = Sets.newHashSet();
        this.frequencyCols.add(COMPUTED_NUMBER);
        this.frequencyCols.add(WEIGHT);
        this.sampleCols = Sets.newHashSet();
        Enumeration columns = columnModel.getColumns();
        while (columns.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)columns.nextElement();
            Object identifier = tableColumn.getIdentifier();
            if (!(identifier instanceof SampleCategoryColumnIdentifier)) continue;
            this.sampleCols.add((SampleCategoryColumnIdentifier)identifier);
        }
    }

    @Override
    public SpeciesBatchRowModel createNewRow() {
        SpeciesBatchRowModel result = new SpeciesBatchRowModel(this.sampleCategoryModel);
        result.setValid(false);
        return result;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex, ColumnIdentifier<SpeciesBatchRowModel> propertyName, SpeciesBatchRowModel entry) {
        if (this.sampleCols.contains(propertyName)) {
            SampleCategoryColumnIdentifier sampleCategoryColumnIdentifier = (SampleCategoryColumnIdentifier)propertyName;
            sampleCategoryColumnIdentifier.setWeightValue(entry, aValue);
            Integer sampleCategoryId = sampleCategoryColumnIdentifier.getSampleCategoryId();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sample category: " + sampleCategoryId + " modified at row: " + rowIndex));
            }
            SampleCategory<?> sampleCategory = entry.getSampleCategoryById(sampleCategoryId);
            SampleCategoryAble firstAncestor = entry.getFirstAncestor((SampleCategory)sampleCategory);
            int firstRowIndex = this.getRowIndex(firstAncestor);
            if (log.isDebugEnabled()) {
                log.debug((Object)("First ancestor row: " + firstRowIndex));
            }
            HashSet shell = Sets.newHashSet();
            ((SpeciesBatchRowModel)firstAncestor).collectShell(shell);
            for (SpeciesBatchRowModel batchRowModel : shell) {
                int currentRowIndex = this.getRowIndex(batchRowModel);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Update shell row: " + currentRowIndex));
                }
                this.fireTableCellUpdated(currentRowIndex, columnIndex);
            }
        } else {
            super.setValueAt(aValue, rowIndex, columnIndex, propertyName, entry);
        }
    }

    @Override
    protected boolean isCellEditable(int rowIndex, int columnIndex, ColumnIdentifier<SpeciesBatchRowModel> propertyName) {
        boolean result = super.isCellEditable(rowIndex, columnIndex, propertyName);
        if (result) {
            if (this.frequencyCols.contains(propertyName)) {
                SpeciesBatchRowModel entry = (SpeciesBatchRowModel)this.getEntry(rowIndex);
                result = entry.isBatchLeaf();
            } else if (this.sampleCols.contains(propertyName)) {
                SampleCategory value;
                SpeciesBatchRowModel entry = (SpeciesBatchRowModel)this.getEntry(rowIndex);
                Species species = entry.getSpecies();
                result = species == null ? false : (value = (SampleCategory)propertyName.getValue(entry)).getCategoryValue() != null;
            }
        }
        return result;
    }
}

