package fr.ifremer.tutti.ui.swing.config;

/*
 * #%L
 * Tutti :: Application
 * $Id: TuttiApplicationConfigOption.java 1171 2013-09-17 09:25:46Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.4/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/config/TuttiApplicationConfigOption.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.util.editor.CoordinateEditorType;
import org.nuiton.config.ConfigOptionDef;

import javax.swing.KeyStroke;
import java.awt.Color;
import java.io.File;
import java.util.Locale;

import static org.nuiton.i18n.I18n.n_;

/**
 * All Tutti configuration options.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public enum TuttiApplicationConfigOption implements ConfigOptionDef {

    TUTTI_LAUNCH_MODE(
            "tutti.launch.mode",
            n_("tutti.config.option.launch.mode.description"),
            null,
            String.class,
            true,
            true
    ),

    TUTTI_I18N_DIRECTORY(
            "tutti.i18n.directory",
            n_("tutti.config.option.i18n.directory.description"),
            "${tutti.basedir}/i18n",
            File.class,
            false,
            true
    ),

    TUTTI_HELP_DIRECTORY(
            "tutti.help.directory",
            n_("tutti.config.option.help.directory.description"),
            "${tutti.basedir}/help",
            File.class,
            false,
            true
    ),

    START_ACTION_FILE(
            "tutti.startActionFile",
            n_("tutti.config.option.startActionFile.description"),
            "${tutti.basedir}/tutti-start-action",
            File.class,
            true,
            true
    ),
    TUTTI_I18N_LOCALE(
            "tutti.i18n.locale",
            n_("tutti.config.option.i18n.locale.description"),
            Locale.FRANCE.getCountry(),
            Locale.class
    ),

    TUTTI_UPDATE_APPLICATION_URL(
            "tutti.update.application.url",
            n_("tutti.config.option.update.application.url.description"),
            "http://appup.forge.codelutin.com/tutti/tutti-application.properties",
            String.class
    ),
    TUTTI_UPDATE_DB_URL(
            "tutti.update.db.url",
            n_("tutti.config.option.update.db.url.description"),
            "http://appup.forge.codelutin.com/tutti/tutti-db.properties",
            String.class
    ),

    UI_CONFIG_FILE(
            "tutti.ui.config.file",
            n_("tutti.config.option.ui.config.file.description"),
            "${tutti.data.directory}/tuttiUI.xml",
            File.class
    ),

    TOTAL_SORTED_WEIGHTS_DIFFERENCE_RATE(
            "tutti.db.weights.rate.difference.totalAndSorted",
            n_("tutti.config.option.weights.rate.difference.totalAndSorted.description"),
            "1.0",
            Float.class
    ),

    TREMIE_CAROUSSEL_VESSEL_ID(
            "tutti.tremieCarousselVessel",
            n_("tutti.config.option.tremieCarousselVessel.description"),
            "",
            String.class
    ),

    PROGRAM_ID(
            "tutti.programId",
            n_("tutti.config.option.programId.description"),
            null,
            String.class
    ),

    CRUISE_ID(
            "tutti.cruiseId",
            n_("tutti.config.option.cruiseId.description"),
            null,
            String.class
    ),

    PROTOCOL_ID(
            "tutti.protocolId",
            n_("tutti.config.option.protocolId.description"),
            null,
            String.class
    ),

    AUTO_POPUP_NUMBER_EDITOR(
            "tutti.ui.autoPopupNumberEditor",
            n_("tutti.config.option.ui.autoPopupNumberEditor.description"),
            String.valueOf(false),
            Boolean.class
    ),

    SHOW_NUMBER_EDITOR_BUTTON(
            "tutti.ui.showNumberEditorButton",
            n_("tutti.config.option.ui.showNumberEditorButton.description"),
            String.valueOf(true),
            Boolean.class
    ),

    COLOR_ROW_READ_ONLY(
            "tutti.ui.color.rowReadOnly",
            n_("tutti.config.option.ui.color.rowReadOnly.description"),
            new Color(192, 192, 192).toString(),
            Color.class
    ),

    COLOR_ROW_INVALID(
            "tutti.ui.color.rowInvalid",
            n_("tutti.config.option.ui.color.rowInvalid.description"),
            new Color(255, 204, 153).toString(),
            Color.class
    ),

    COLOR_CELL_WITH_VALUE(
            "tutti.ui.color.cellWithValue",
            n_("tutti.config.option.ui.color.cellWithValue.description"),
            new Color(128, 255, 128).toString(),
            Color.class
    ),

    COLOR_ROW_TO_CONFIRM(
            "tutti.ui.color.rowToConfirm",
            n_("tutti.config.option.ui.color.rowToConfirm.description"),
            Color.ORANGE.toString(),
            Color.class
    ),

    COLOR_BLOCKING_LAYER(
            "tutti.ui.color.blockingLayer",
            n_("tutti.config.option.ui.color.blockingLayer.description"),
            new Color(200, 200, 200).toString(),
            Color.class
    ),

    COLOR_COMPUTED_WEIGHTS(
            "tutti.ui.color.computedWeights",
            n_("tutti.config.option.ui.color.computedWeights.description"),
            Color.BLUE.toString(),
            Color.class
    ),

    SHORTCUT_CLOSE_POPUP(
            "tutti.ui.shortcut.closePopup",
            n_("tutti.config.option.ui.shortcut.closePopup.description"),
            "alt pressed F",
            KeyStroke.class
    ),

    COORDINATE_EDITOR_TYPE(
            "tutti.ui.coordinateEditorType",
            n_("tutti.config.option.ui.coordinateEditorType.description"),
            CoordinateEditorType.DD.toString(),
            CoordinateEditorType.class
    ),

    DATE_FORMAT(
            "tutti.ui.dateFormat",
            n_("tutti.config.option.ui.dateFormat.description"),
            "dd/MM/yyyy",
            String.class
    ),

    ADMIN_PASSWORD(
            "tutti.admin.password",
            n_("tutti.config.option.ui.dateFormat.description"),
            // "ifremer" by default
            "ef399a6e6ec62c6e142440241a5b98f8",
            String.class
    );

    /** Configuration key. */
    private final String key;

    /** I18n key of option description */
    private final String description;

    /** Type of option */
    private final Class<?> type;

    /** Default value of option. */
    private String defaultValue;

    /** Flag to not keep option value on disk */
    private boolean isTransient;

    /** Flag to not allow option value modification */
    private boolean isFinal;

    TuttiApplicationConfigOption(String key,
                                 String description,
                                 String defaultValue,
                                 Class<?> type,
                                 boolean isTransient,
                                 boolean isFinal) {
        this.key = key;
        this.description = description;
        this.defaultValue = defaultValue;
        this.type = type;
        this.isTransient = isTransient;
        this.isFinal = isFinal;
    }

    TuttiApplicationConfigOption(String key,
                                 String description,
                                 String defaultValue,
                                 Class<?> type) {
        this(key, description, defaultValue, type, false, false);
    }

    @Override
    public String getKey() {
        return key;
    }

    @Override
    public Class<?> getType() {
        return type;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public String getDefaultValue() {
        return defaultValue;
    }

    @Override
    public boolean isTransient() {
        return isTransient;
    }

    @Override
    public boolean isFinal() {
        return isFinal;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public void setTransient(boolean newValue) {
        // not used
    }

    @Override
    public void setFinal(boolean newValue) {
        // not used
    }
}
