/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.db;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.ui.swing.content.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportDbAction
extends AbstractMainUITuttiAction {
    private static final Log log = LogFactory.getLog(ExportDbAction.class);
    protected File file;
    public static final DateFormat df = new SimpleDateFormat("yyy-MM-dd");

    public ExportDbAction(MainUIHandler handler) {
        super(handler, true);
    }

    @Override
    protected boolean prepareAction() throws Exception {
        this.file = null;
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = TuttiUIUtil.saveFile("tutti-db-" + df.format(new Date()) + ".zip", this.getContext().getMainUI(), I18n._((String)"tutti.dbManager.title.choose.dbExportFile", (Object[])new Object[0]), I18n._((String)"tutti.dbManager.action.chooseDbExportFile", (Object[])new Object[0]), "^.*\\.zip", I18n._((String)"tutti.common.file.zip", (Object[])new Object[0]));
            if (this.file == null) {
                doAction = false;
            } else {
                this.file = TuttiIOUtil.addExtensionIfMissing((File)this.file, (String)".zip");
                doAction = ((MainUIHandler)this.getHandler()).askOverwriteFile(this.file);
            }
        }
        return doAction;
    }

    @Override
    protected void doAction() {
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export db to " + this.file));
        }
        ProgressionModel progressionModel = new ProgressionModel();
        this.setProgressionModel(progressionModel);
        progressionModel.setTotal(3);
        progressionModel.setMessage(I18n._((String)"tutti.exportDb.closeDb", (Object[])new Object[0]));
        this.getContext().setDbLoaded(false);
        ((MainUIHandler)this.getHandler()).reloadPersistenceService();
        progressionModel.increments(1);
        progressionModel.setMessage(I18n._((String)"tutti.exportDb.createArchive", (Object[])new Object[]{this.file}));
        this.getContext().getPersistenceService().exportDb(this.file);
        progressionModel.increments(1);
        progressionModel.setMessage(I18n._((String)"tutti.exportDb.openDb", (Object[])new Object[0]));
        this.getContext().setDbLoaded(true);
        ((MainUIHandler)this.getHandler()).reloadPersistenceService();
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        this.sendMessage(I18n._((String)"tutti.flash.info.db.exported", (Object[])new Object[]{this.file}));
        ((MainUI)this.getUI()).getHandler().changeTitle();
    }
}

