/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.LabelAware;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.TuttiDataContext;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.Cancelable;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.UIMessageNotifier;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionUI;
import fr.ifremer.tutti.ui.swing.util.action.TuttiUIAction;
import fr.ifremer.tutti.ui.swing.util.attachment.ButtonAttachment;
import fr.ifremer.tutti.ui.swing.util.editor.SimpleTimeEditor;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.JAXXWidgetUtil;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.editor.bean.BeanUIUtil;
import jaxx.runtime.swing.editor.cell.NumberCellEditor;
import jaxx.runtime.swing.renderer.DecoratorListCellRenderer;
import jaxx.runtime.swing.renderer.DecoratorTableCellRenderer;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.jdesktop.swingx.table.TableColumnExt;
import org.nuiton.i18n.I18n;
import org.nuiton.util.decorator.Decorator;
import org.nuiton.util.decorator.JXPathDecorator;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public abstract class AbstractTuttiUIHandler<M, UI extends TuttiUI<M, ?>>
implements UIMessageNotifier {
    private static final Log log = LogFactory.getLog(AbstractTuttiUIHandler.class);
    protected final TuttiUIContext context;
    protected final UI ui;
    public static final String CONFIRMATION_FORMAT = "<html>%s<hr/><br/>%s</html>";
    public static final String WARNING_FORMAT = "<html>%s<hr/></html>";

    public abstract void beforeInitUI();

    public abstract void afterInitUI();

    public abstract void onCloseUI();

    public abstract SwingValidator<M> getValidator();

    protected AbstractTuttiUIHandler(TuttiUIContext context, UI ui) {
        this.context = context;
        this.ui = ui;
    }

    public DefaultComboBoxModel newComboModel(Object ... items) {
        return new DefaultComboBoxModel<Object>(items);
    }

    public final M getModel() {
        return this.ui.getModel();
    }

    public final UI getUI() {
        return this.ui;
    }

    @Override
    public void showInformationMessage(String message) {
        this.context.showInformationMessage(message);
    }

    public TuttiUIContext getContext() {
        return this.context;
    }

    public TuttiDataContext getDataContext() {
        return this.getContext().getDataContext();
    }

    public TuttiApplicationConfig getConfig() {
        return this.context.getConfig();
    }

    public void setText(KeyEvent event, String property) {
        JTextComponent field = (JTextComponent)event.getSource();
        String value = field.getText();
        TuttiUIUtil.setProperty(this.getModel(), property, value);
    }

    public void setBoolean(ItemEvent event, String property) {
        boolean value = event.getStateChange() == 1;
        TuttiUIUtil.setProperty(this.getModel(), property, value);
    }

    public void setDate(ActionEvent event, String property) {
        JXDatePicker field = (JXDatePicker)event.getSource();
        Date value = field.getDate();
        TuttiUIUtil.setProperty(this.getModel(), property, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectListData(ListSelectionEvent event, String property) {
        if (!event.getValueIsAdjusting()) {
            JList list = (JList)event.getSource();
            ListSelectionModel selectionModel = list.getSelectionModel();
            selectionModel.setValueIsAdjusting(true);
            try {
                LinkedList selectedList = Lists.newLinkedList();
                for (int index : list.getSelectedIndices()) {
                    Object o = list.getModel().getElementAt(index);
                    selectedList.add(o);
                }
                TuttiUIUtil.setProperty(this.getModel(), property, selectedList);
            }
            finally {
                selectionModel.setValueIsAdjusting(false);
            }
        }
    }

    public void openDialog(TuttiUI dialogContent, String title, Dimension dim) {
        Component topestUI = this.getTopestUI();
        JDialog result = topestUI instanceof Frame ? new JDialog((Frame)topestUI, title, true) : new JDialog((Dialog)topestUI, title, true);
        result.add((Component)((Object)dialogContent));
        result.setResizable(true);
        result.setSize(dim);
        Object handler = dialogContent.getHandler();
        if (handler instanceof Cancelable) {
            JRootPane rootPane = result.getRootPane();
            KeyStroke shortcutClosePopup = this.getConfig().getShortcutClosePopup();
            rootPane.getInputMap(2).put(shortcutClosePopup, "close");
            rootPane.getActionMap().put("close", new AbstractAction((AbstractTuttiUIHandler)handler){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ AbstractTuttiUIHandler val$handler;
                {
                    this.val$handler = abstractTuttiUIHandler2;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((Cancelable)((Object)this.val$handler)).cancel();
                }
            });
        }
        result.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                Component ui = (Component)e.getSource();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Destroy ui " + ui));
                }
                JAXXUtil.destroy((Component)ui);
            }
        });
        SwingUtil.center((Component)this.getContext().getMainUI(), (Component)result);
        result.setVisible(true);
    }

    public void closeDialog(TuttiUI ui) {
        ((JDialog)SwingUtil.getParentContainer((Object)ui, JDialog.class)).setVisible(false);
    }

    public int askSaveBeforeLeaving(String message) {
        String htmlMessage = String.format(CONFIRMATION_FORMAT, message, I18n._((String)"tutti.common.askSaveBeforeLeaving.help", (Object[])new Object[0]));
        int result = JOptionPane.showConfirmDialog(this.getTopestUI(), htmlMessage, I18n._((String)"tutti.common.askSaveBeforeLeaving.title", (Object[])new Object[0]), 1, 3);
        return result;
    }

    public boolean askCancelEditBeforeLeaving(String message) {
        String htmlMessage = String.format(CONFIRMATION_FORMAT, message, I18n._((String)"tutti.common.askCancelEditBeforeLeaving.help", (Object[])new Object[0]));
        int i = JOptionPane.showConfirmDialog(this.getTopestUI(), htmlMessage, I18n._((String)"tutti.common.askCancelEditBeforeLeaving.title", (Object[])new Object[0]), 2, 3);
        boolean result = i == 0;
        return result;
    }

    public boolean askBeforeDelete(String title, String message) {
        String htmlMessage = String.format(CONFIRMATION_FORMAT, message, I18n._((String)"tutti.common.askBeforeDelete.help", (Object[])new Object[0]));
        int i = JOptionPane.showConfirmDialog(this.getTopestUI(), htmlMessage, title, 2, 3);
        boolean result = i == 0;
        return result;
    }

    public boolean askOverwriteFile(File file) {
        boolean result;
        if (file.exists()) {
            String htmlMessage = String.format(CONFIRMATION_FORMAT, I18n._((String)"tutti.common.askOverwriteFile.message", (Object[])new Object[]{file}), I18n._((String)"tutti.common.askOverwriteFile.help", (Object[])new Object[0]));
            result = JOptionPane.showConfirmDialog(this.getTopestUI(), htmlMessage, I18n._((String)"tutti.common.askOverwriteFile.title", (Object[])new Object[0]), 2, 3) == 0;
        } else {
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showSuccessMessage(String title, String message) {
        Component topestUI = this.getTopestUI();
        boolean alwaysOnTop = false;
        if (topestUI instanceof JDialog) {
            alwaysOnTop = ((JDialog)topestUI).isAlwaysOnTop();
        }
        if (alwaysOnTop) {
            ((JDialog)topestUI).setAlwaysOnTop(false);
        }
        try {
            TuttiUIUtil.showSuccessMessage(topestUI, title, message);
        }
        finally {
            if (alwaysOnTop) {
                ((JDialog)topestUI).setAlwaysOnTop(true);
            }
        }
    }

    protected Component getTopestUI() {
        TuttiActionUI actionUI;
        TuttiActionUI result = actionUI = this.getContext().getActionUI();
        return result;
    }

    protected void initUI(TuttiUI ui) {
        for (Map.Entry entry : ui.get$objectMap().entrySet()) {
            Object component = entry.getValue();
            if (component instanceof NumberEditor) {
                this.initNumberEditor((NumberEditor)component);
                continue;
            }
            if (component instanceof JXDatePicker) {
                this.initDatePicker((JXDatePicker)component);
                continue;
            }
            if (component instanceof SimpleTimeEditor) {
                this.initTimeEditor((SimpleTimeEditor)((Object)component));
                continue;
            }
            if (component instanceof ButtonAttachment) {
                this.initButtonAttachment((ButtonAttachment)component);
                continue;
            }
            if (component instanceof JLabel) {
                this.initLabel((JLabel)component);
                continue;
            }
            if (component instanceof JTextField) {
                this.initTextField((JTextField)component);
                continue;
            }
            if (component instanceof AbstractButton) {
                this.initButton((AbstractButton)component);
                continue;
            }
            if (!(component instanceof JScrollPane)) continue;
            this.initScrollPane((JScrollPane)component);
        }
        ((Component)((Object)ui)).addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                JComponent component = AbstractTuttiUIHandler.this.getComponentToFocus();
                if ((e.getChangeFlags() & 4L) > 0L && e.getChanged().isShowing() && component != null) {
                    component.requestFocus();
                }
            }
        });
    }

    protected abstract JComponent getComponentToFocus();

    protected void initTextField(JTextField jTextField) {
        Boolean computed = (Boolean)jTextField.getClientProperty("computed");
        if (computed != null && computed.booleanValue()) {
            Font font = jTextField.getFont().deriveFont(2);
            jTextField.setFont(font);
            jTextField.setEditable(computed == false);
            jTextField.setEnabled(computed == false);
            jTextField.setDisabledTextColor(this.getConfig().getColorComputedWeights());
        }
        if (this.isAutoSelectOnFocus(jTextField)) {
            this.addAutoSelectOnFocus(jTextField);
        }
    }

    protected void initLabel(JLabel jLabel) {
        Boolean strongStyle = (Boolean)jLabel.getClientProperty("strongStyle");
        Boolean italicStyle = (Boolean)jLabel.getClientProperty("italicStyle");
        Font font = jLabel.getFont();
        int style = font.getStyle();
        if (strongStyle != null && strongStyle.booleanValue()) {
            style |= 1;
        }
        if (italicStyle != null && italicStyle.booleanValue()) {
            style |= 2;
        }
        jLabel.setFont(font.deriveFont(style));
    }

    protected void initButtonAttachment(ButtonAttachment component) {
        component.init();
    }

    protected void initButton(AbstractButton abstractButton) {
        Class actionName = (Class)abstractButton.getClientProperty("tuttiAction");
        if (actionName != null) {
            TuttiUIAction action = TuttiActionHelper.createUIAction(this, abstractButton, actionName);
            abstractButton.setAction(action);
        }
    }

    protected <E extends Serializable> void initBeanFilterableComboBox(BeanFilterableComboBox<E> comboBox, List<E> data, E selectedData) {
        this.initBeanFilterableComboBox(comboBox, data, selectedData, null);
    }

    protected <E extends Serializable> void initBeanFilterableComboBox(BeanFilterableComboBox<E> comboBox, List<E> data, E selectedData, String decoratorContext) {
        Preconditions.checkNotNull(comboBox, (Object)"No comboBox!");
        Class beanType = comboBox.getBeanType();
        Preconditions.checkNotNull((Object)beanType, (Object)"No beanType on the combobox!");
        Decorator decorator = this.getDecorator(beanType, decoratorContext);
        if (data == null) {
            data = Lists.newArrayList();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("entity comboBox list [" + beanType.getName() + "] : " + (data == null ? 0 : data.size())));
        }
        comboBox.init((JXPathDecorator)decorator, (List)data);
        comboBox.setSelectedItem(selectedData);
        if (log.isDebugEnabled()) {
            log.debug((Object)("combo [" + beanType.getName() + "] : " + comboBox.getData().size()));
        }
    }

    protected <E extends TuttiEntity> void initBeanList(BeanDoubleList<E> list, List<E> data, List<E> selectedData) {
        Preconditions.checkNotNull(list, (Object)"No list!");
        Class beanType = list.getBeanType();
        Preconditions.checkNotNull((Object)beanType, (Object)"No beanType on the double list!");
        DecoratorService decoratorService = this.context.getDecoratorService();
        Decorator decorator = decoratorService.getDecoratorByType(beanType);
        if (log.isInfoEnabled()) {
            log.info((Object)("entity list [" + beanType.getName() + "] : " + (data == null ? 0 : data.size())));
        }
        list.init((JXPathDecorator)decorator, data, selectedData);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Jlist [" + beanType.getName() + "] : " + list.getUniverseList().getModel().getSize()));
        }
    }

    protected void initNumberEditor(NumberEditor editor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init number editor " + editor.getName()));
        }
        editor.init();
        Number model = editor.getModel();
        if (model != null) {
            editor.setModel(null);
            editor.setModel(model);
        }
        if (this.isAutoSelectOnFocus((JComponent)editor)) {
            this.addAutoSelectOnFocus(editor.getTextField());
        }
    }

    protected void initTimeEditor(SimpleTimeEditor editor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init time editor " + editor.getName() + " for property " + editor.getModel().getProperty()));
        }
        editor.init();
        if (this.isAutoSelectOnFocus((JComponent)((Object)editor))) {
            this.addAutoSelectOnFocus(((JSpinner.DefaultEditor)editor.getHour().getEditor()).getTextField());
            this.addAutoSelectOnFocus(((JSpinner.DefaultEditor)editor.getMinute().getEditor()).getTextField());
        }
    }

    protected void initDatePicker(final JXDatePicker picker) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("disable JXDatePicker editor" + picker.getName()));
        }
        String dateFormat = this.getConfig().getDateFormat();
        picker.setFormats(new String[]{dateFormat});
        picker.setToolTipText(I18n._((String)"tutti.common.datefield.tip", (Object[])new Object[]{dateFormat}));
        picker.getEditor().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    picker.commitEdit();
                }
                catch (ParseException ex) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"format error", (Throwable)ex);
                    }
                    picker.requestFocus();
                }
            }
        });
        if (this.isAutoSelectOnFocus((JComponent)picker)) {
            this.addAutoSelectOnFocus(picker.getEditor());
        }
    }

    protected void initScrollPane(JScrollPane scrollPane) {
        Boolean onlyVerticalScrollable = (Boolean)scrollPane.getClientProperty("onlyVerticalScrollable");
        if (onlyVerticalScrollable != null && onlyVerticalScrollable.booleanValue()) {
            scrollPane.setHorizontalScrollBarPolicy(31);
            scrollPane.setVerticalScrollBarPolicy(20);
            final JViewport viewport = scrollPane.getViewport();
            viewport.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    Dimension newDimension = new Dimension(viewport.getExtentSize().width, viewport.getViewSize().height);
                    viewport.setViewSize(newDimension);
                }
            });
        }
    }

    protected boolean isAutoSelectOnFocus(JComponent comp) {
        Object selectOnFocus = comp.getClientProperty("selectOnFocus");
        return selectOnFocus != null && Boolean.valueOf(selectOnFocus.toString()) != false;
    }

    protected void addAutoSelectOnFocus(JTextField jTextField) {
        jTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(final FocusEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JTextField source = (JTextField)e.getSource();
                        source.selectAll();
                    }
                });
            }
        });
    }

    protected boolean quitScreen(boolean modelIsValid, boolean modelIsModify, String askGiveUpMessage, String askSaveMessage, Action saveAction) {
        boolean result;
        if (!modelIsValid) {
            result = this.askCancelEditBeforeLeaving(askGiveUpMessage);
        } else if (modelIsModify) {
            int answer = this.askSaveBeforeLeaving(askSaveMessage);
            switch (answer) {
                case 0: {
                    saveAction.actionPerformed(null);
                    result = true;
                    break;
                }
                case 1: {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                    break;
                }
            }
        } else {
            result = true;
        }
        return result;
    }

    protected void registerValidators(SwingValidator ... validators) {
        MainUI main = this.context.getMainUI();
        Preconditions.checkNotNull((Object)main, (Object)"No mainUI registred in application context");
        MainUIHandler handler = main.getHandler();
        handler.clearValidators();
        for (SwingValidator validator : validators) {
            handler.registerValidator(validator);
        }
    }

    public void clearValidators() {
        MainUI main = this.context.getMainUI();
        Preconditions.checkNotNull((Object)main, (Object)"No mainUI registred in application context");
        MainUIHandler handler = main.getHandler();
        handler.clearValidators();
    }

    public <O> Decorator<O> getDecorator(Class<O> type, String name) {
        DecoratorService decoratorService = this.context.getDecoratorService();
        Preconditions.checkNotNull(type);
        Decorator<LabelAware> decorator = decoratorService.getDecoratorByType(type, name);
        if (decorator == null && LabelAware.class.isAssignableFrom(type)) {
            decorator = this.getDecorator(LabelAware.class, null);
        }
        Preconditions.checkNotNull((Object)decorator);
        return decorator;
    }

    protected String decorate(Object object) {
        return this.decorate(object, null);
    }

    protected String decorate(Object object, String context) {
        String result = "";
        if (object != null) {
            result = this.getDecorator(object.getClass(), context).toString(object);
        }
        return result;
    }

    protected <O> ListCellRenderer newListCellRender(Class<O> type) {
        return this.newListCellRender(type, null);
    }

    protected <O> ListCellRenderer newListCellRender(Class<O> type, String name) {
        Decorator<O> decorator = this.getDecorator(type, name);
        return this.newListCellRender(decorator);
    }

    protected <O> ListCellRenderer newListCellRender(Decorator<O> decorator) {
        Preconditions.checkNotNull(decorator);
        DecoratorListCellRenderer result = new DecoratorListCellRenderer(decorator);
        return result;
    }

    protected void listenValidatorValid(SimpleBeanValidator validator, final AbstractTuttiBeanUIModel model) {
        validator.addPropertyChangeListener("valid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Model [" + (Object)((Object)model) + "] pass to valid state [" + evt.getNewValue() + "]"));
                }
                model.setValid((Boolean)evt.getNewValue());
            }
        });
    }

    protected void listenValidationTableHasNoFatalError(final SimpleBeanValidator validator, final AbstractTuttiBeanUIModel model) {
        this.getContext().getMainUI().getValidatorMessageWidget().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                boolean valid;
                boolean bl = valid = !validator.hasFatalErrors();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Model [" + (Object)((Object)model) + "] pass to valid state [" + valid + "]"));
                }
                model.setValid(valid);
            }
        });
    }

    protected void listModelIsModify(AbstractTuttiBeanUIModel model) {
        model.addPropertyChangeListener(new PropertyChangeListener(){
            final Set<String> excludeProperties;
            {
                this.excludeProperties = AbstractTuttiUIHandler.this.getPropertiesToIgnore();
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!this.excludeProperties.contains(evt.getPropertyName())) {
                    ((AbstractTuttiBeanUIModel)((Object)evt.getSource())).setModify(true);
                }
            }
        });
    }

    protected Set<String> getPropertiesToIgnore() {
        return Sets.newHashSet((Object[])new String[]{"modify", "valid"});
    }

    protected void closeUI(TuttiUI ui) {
        ((AbstractTuttiUIHandler)ui.getHandler()).onCloseUI();
    }

    protected <B> void changeValidatorContext(String newContext, SwingValidator<B> validator) {
        Object bean = validator.getBean();
        validator.setContext(newContext);
        validator.setBean(bean);
    }

    protected <R extends AbstractTuttiBeanUIModel> void addColumnToModel(TableColumnModel model, TableCellEditor editor, TableCellRenderer renderer, ColumnIdentifier<R> identifier) {
        TableColumnExt col = new TableColumnExt(model.getColumnCount());
        col.setCellEditor(editor);
        col.setCellRenderer(renderer);
        col.setHeaderValue((Object)I18n._((String)identifier.getHeaderI18nKey(), (Object[])new Object[0]));
        col.setToolTipText(I18n._((String)identifier.getHeaderTipI18nKey(), (Object[])new Object[0]));
        col.setIdentifier(identifier);
        model.addColumn((TableColumn)col);
    }

    protected <R extends AbstractTuttiBeanUIModel> void addColumnToModel(TableColumnModel model, ColumnIdentifier<R> identifier) {
        this.addColumnToModel(model, null, null, identifier);
    }

    protected <R extends AbstractTuttiBeanUIModel> void addFloatColumnToModel(TableColumnModel model, ColumnIdentifier<R> identifier, String numberPattern) {
        NumberCellEditor editor = JAXXWidgetUtil.newNumberTableCellEditor(Float.class, (boolean)false);
        editor.getNumberEditor().setSelectAllTextOnError(Boolean.valueOf(true));
        editor.getNumberEditor().getTextField().setBorder(new LineBorder(Color.GRAY, 2));
        editor.getNumberEditor().setNumberPattern(numberPattern);
        this.addColumnToModel(model, (TableCellEditor)editor, null, identifier);
    }

    protected <R extends AbstractTuttiBeanUIModel> void addIntegerColumnToModel(TableColumnModel model, ColumnIdentifier<R> identifier, String numberPattern) {
        NumberCellEditor editor = JAXXWidgetUtil.newNumberTableCellEditor(Integer.class, (boolean)false);
        editor.getNumberEditor().setSelectAllTextOnError(Boolean.valueOf(true));
        editor.getNumberEditor().getTextField().setBorder(new LineBorder(Color.GRAY, 2));
        editor.getNumberEditor().setNumberPattern(numberPattern);
        this.addColumnToModel(model, (TableCellEditor)editor, null, identifier);
    }

    protected <R extends AbstractTuttiBeanUIModel> void addBooleanColumnToModel(TableColumnModel model, ColumnIdentifier<R> identifier, JTable table) {
        this.addColumnToModel(model, table.getDefaultEditor(Boolean.class), table.getDefaultRenderer(Boolean.class), identifier);
    }

    protected <R extends AbstractTuttiBeanUIModel, B> void addComboDataColumnToModel(TableColumnModel model, ColumnIdentifier<R> identifier, Decorator<B> decorator, List<B> data) {
        JComboBox comboBox = new JComboBox();
        comboBox.setRenderer(this.newListCellRender(decorator));
        ArrayList dataToList = Lists.newArrayList(data);
        if (!dataToList.isEmpty() && dataToList.get(0) != null) {
            dataToList.add(0, null);
        }
        SwingUtil.fillComboBox(comboBox, (Collection)dataToList, null);
        ObjectToStringConverter converter = BeanUIUtil.newDecoratedObjectToStringConverter(decorator);
        BeanUIUtil.decorate(comboBox, (ObjectToStringConverter)converter);
        ComboBoxCellEditor editor = new ComboBoxCellEditor(comboBox);
        this.addColumnToModel(model, (TableCellEditor)editor, this.newTableCellRender(decorator), identifier);
    }

    protected <O> TableCellRenderer newTableCellRender(Class<O> type) {
        return this.newTableCellRender(type, null);
    }

    protected <O> TableCellRenderer newTableCellRender(Class<O> type, String name) {
        Decorator<O> decorator = this.getDecorator(type, name);
        TableCellRenderer result = this.newTableCellRender(decorator);
        return result;
    }

    protected <O> TableCellRenderer newTableCellRender(Decorator<O> decorator) {
        Preconditions.checkNotNull(decorator);
        DecoratorTableCellRenderer result = new DecoratorTableCellRenderer(decorator, true);
        return result;
    }

    public void autoSelectRowInTable(MouseEvent e, JPopupMenu popup) {
        boolean rightClick = SwingUtilities.isRightMouseButton(e);
        if (rightClick || SwingUtilities.isLeftMouseButton(e)) {
            boolean stopEdit;
            Point p = e.getPoint();
            JXTable source = (JXTable)e.getSource();
            int[] selectedRows = source.getSelectedRows();
            int rowIndex = source.rowAtPoint(p);
            if (log.isDebugEnabled()) {
                log.debug((Object)("At point [" + p + "] found Row " + rowIndex));
            }
            boolean canContinue = true;
            if (source.isEditing() && !(stopEdit = source.getCellEditor().stopCellEditing())) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Could not stop edit cell...");
                }
                canContinue = false;
            }
            if (canContinue) {
                if (rowIndex == -1) {
                    source.clearSelection();
                } else if (!ArrayUtils.contains((int[])selectedRows, (int)rowIndex)) {
                    source.setRowSelectionInterval(rowIndex, rowIndex);
                }
                if (rightClick) {
                    popup.show((Component)source, e.getX(), e.getY());
                }
            }
        }
    }

    public void openRowMenu(KeyEvent e, JPopupMenu popup) {
        if (e.getKeyCode() == 525) {
            boolean stopEdit;
            JXTable source = (JXTable)e.getSource();
            int[] selectedRows = source.getSelectedRows();
            int lowestRow = -1;
            for (int row : selectedRows) {
                lowestRow = Math.max(lowestRow, row);
            }
            Rectangle r = source.getCellRect(lowestRow, source.getSelectedColumn(), true);
            Point p = new Point(r.x + r.width / 2, r.y + r.height);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Row " + lowestRow + " found t point [" + p + "]"));
            }
            boolean canContinue = true;
            if (source.isEditing() && !(stopEdit = source.getCellEditor().stopCellEditing())) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Could not stop edit cell...");
                }
                canContinue = false;
            }
            if (canContinue) {
                popup.show((Component)source, p.x, p.y);
            }
        }
    }
}

