/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.RemoveSpeciesSubBatchAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import fr.ifremer.tutti.ui.swing.util.table.AbstractSelectTableAction;
import java.util.HashSet;
import javax.swing.JTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;

public class RemoveSpeciesBatchAction
extends AbstractTuttiAction<SpeciesBatchUIModel, SpeciesBatchUI, SpeciesBatchUIHandler> {
    private static final Log log = LogFactory.getLog(RemoveSpeciesBatchAction.class);
    protected RemoveSpeciesSubBatchAction removeSpeciesSubBatchAction;

    public RemoveSpeciesBatchAction(SpeciesBatchUIHandler handler) {
        super(handler, false);
        this.removeSpeciesSubBatchAction = new RemoveSpeciesSubBatchAction(handler);
    }

    @Override
    protected void doAction() throws Exception {
        PersistenceService persistenceService = this.getContext().getPersistenceService();
        JXTable table = ((SpeciesBatchUIHandler)this.handler).getTable();
        int rowIndex = table.getSelectedRow();
        Preconditions.checkState((rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant remove batch if no batch selected");
        SpeciesBatchTableModel tableModel = ((SpeciesBatchUIHandler)this.handler).getTableModel();
        SpeciesBatchRowModel selectedBatch = (SpeciesBatchRowModel)tableModel.getEntry(rowIndex);
        Preconditions.checkState((!TuttiEntities.isNew((TuttiEntity)selectedBatch) ? 1 : 0) != 0, (Object)"Can't remove batch if batch is not persisted");
        if (!selectedBatch.isBatchRoot()) {
            SpeciesBatchRowModel parentBatch = selectedBatch.getParentBatch();
            int parentIndex = tableModel.getRowIndex(parentBatch);
            table.setRowSelectionInterval(parentIndex, parentIndex);
            TuttiActionHelper.runInternalAction(this.removeSpeciesSubBatchAction);
        } else {
            persistenceService.deleteSpeciesBatch(selectedBatch.getId());
            ((SpeciesBatchUIHandler)this.handler).removeFromSpeciesUsed(selectedBatch);
            HashSet rowToRemove = Sets.newHashSet((Object[])new SpeciesBatchRowModel[]{selectedBatch});
            ((SpeciesBatchUIHandler)this.handler).collectChildren(selectedBatch, rowToRemove);
            table.clearSelection();
            ((SpeciesBatchUIModel)this.getModel()).getRows().removeAll(rowToRemove);
            tableModel.fireTableDataChanged();
            if (!((SpeciesBatchUIModel)this.getModel()).getRows().isEmpty()) {
                AbstractSelectTableAction.doSelectCell((JTable)table, 0, 0);
            }
            if (table.isEditing()) {
                table.getCellEditor().stopCellEditing();
            }
        }
    }
}

