/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatchImpl;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.adagio.core.dao.data.measure.QuantificationMeasurement;
import fr.ifremer.adagio.core.dao.data.operation.FishingOperation;
import fr.ifremer.adagio.core.dao.data.operation.FishingOperationImpl;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.technical.synchronization.SynchronizationStatus;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.CatchBatchBean;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.AttachmentPersistenceService;
import fr.ifremer.tutti.persistence.service.CatchBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.ReferentialPersistenceService;
import fr.ifremer.tutti.persistence.service.batch.BatchPersistenceHelper;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.type.IntegerType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Service;

@Service(value="batchPersistenceService")
public class CatchBatchPersistenceServiceImpl
extends AbstractPersistenceService
implements CatchBatchPersistenceService {
    private static final Log log = LogFactory.getLog(CatchBatchPersistenceServiceImpl.class);
    @Autowired
    protected ReferentialPersistenceService referentialService;
    @Autowired
    protected AttachmentPersistenceService attachmentPersistenceService;
    @Resource(name="batchPersistenceHelper")
    protected BatchPersistenceHelper batchHelper;

    @Override
    public boolean isFishingOperationWithCatchBatch(String operationId) {
        Preconditions.checkNotNull((Object)operationId);
        boolean result = this.batchHelper.isCatchBatchExistsForFishingOperation(Integer.valueOf(operationId));
        return result;
    }

    @Override
    public CatchBatch getCatchBatchFromFishingOperation(String fishingOperationId) {
        SortingBatch unsortedBatch;
        SortingBatch horsVracBatch;
        SortingBatch vracBatch;
        Preconditions.checkNotNull((Object)fishingOperationId);
        fr.ifremer.adagio.core.dao.data.batch.CatchBatch source = this.batchHelper.getRootCatchBatchByFishingOperationId(fishingOperationId, true);
        CatchBatchBean result = new CatchBatchBean();
        result.setId(source.getId());
        result.setCatchTotalWeight(source.getWeight());
        if (log.isInfoEnabled()) {
            log.info((Object)("Loaded CatchBatch: " + result.getId()));
        }
        if ((vracBatch = this.batchHelper.getSortingBatch((Batch)source, "Vrac", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_VRAC_ID)) != null) {
            SortingBatch vracBenthosBatch;
            result.setCatchTotalSortedCarousselWeight(vracBatch.getWeight());
            result.setCatchTotalSortedTremisWeight(vracBatch.getWeightBeforeSampling());
            SortingBatch vracSpeciesBatch = this.batchHelper.getSortingBatch((Batch)vracBatch, "Vrac > Species", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES);
            if (vracSpeciesBatch != null) {
                SortingBatch livingNotItemizedBatch;
                result.setSpeciesTotalSortedWeight(vracSpeciesBatch.getWeight());
                SortingBatch inertBatch = this.batchHelper.getSortingBatch((Batch)vracSpeciesBatch, "Vrac > Species > Inert", this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_INERT);
                if (inertBatch != null) {
                    result.setSpeciesTotalInertWeight(inertBatch.getWeight());
                }
                if ((livingNotItemizedBatch = this.batchHelper.getSortingBatch((Batch)vracSpeciesBatch, "Vrac > Species > Alive not itemized", this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_ALIVE_NOT_ITEMIZED)) != null) {
                    result.setSpeciesTotalLivingNotItemizedWeight(livingNotItemizedBatch.getWeight());
                }
            }
            if ((vracBenthosBatch = this.batchHelper.getSortingBatch((Batch)vracBatch, "Vrac > Benthos", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_BENTHOS)) != null) {
                SortingBatch livingNotItemizedBatch;
                result.setBenthosTotalSortedWeight(vracBenthosBatch.getWeight());
                SortingBatch inertBatch = this.batchHelper.getSortingBatch((Batch)vracBenthosBatch, "Vrac > Benthos > Inert", this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_INERT);
                if (inertBatch != null) {
                    result.setBenthosTotalInertWeight(inertBatch.getWeight());
                }
                if ((livingNotItemizedBatch = this.batchHelper.getSortingBatch((Batch)vracBenthosBatch, "Vrac > Benthos > Alive not itemized", this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_ALIVE_NOT_ITEMIZED)) != null) {
                    result.setBenthosTotalLivingNotItemizedWeight(livingNotItemizedBatch.getWeight());
                }
            }
        }
        if ((horsVracBatch = this.batchHelper.getSortingBatch((Batch)source, "Hors Vrac", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_HORS_VRAC_ID)) != null) {
            this.batchHelper.getSortingBatch((Batch)horsVracBatch, "Hors Vrac > Species", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES);
            this.batchHelper.getSortingBatch((Batch)horsVracBatch, "Hors Vrac > Benthos", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_BENTHOS);
            SortingBatch marineLitterBatch = this.batchHelper.getSortingBatch((Batch)horsVracBatch, "Hors Vrac > MarineLitter", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_MARINE_LITTER);
            if (marineLitterBatch != null) {
                result.setMarineLitterTotalWeight(marineLitterBatch.getWeight());
            }
        }
        if ((unsortedBatch = this.batchHelper.getSortingBatch((Batch)source, "Unsorted", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_UNSORTED_ID)) != null) {
            result.setCatchTotalRejectedWeight(unsortedBatch.getWeight());
        }
        return result;
    }

    @Override
    public CatchBatch createCatchBatch(CatchBatch bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkArgument((bean.getId() == null ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)bean.getFishingOperation());
        Preconditions.checkNotNull((Object)bean.getFishingOperation().getId());
        fr.ifremer.adagio.core.dao.data.batch.CatchBatch catchBatch = CatchBatch.Factory.newInstance();
        this.catchBatchToEntity(bean, catchBatch);
        bean = this.batchHelper.createCatchBatch(bean, catchBatch);
        this.getCurrentSession().flush();
        Integer fishingOperationId = bean.getFishingOperation().getIdAsInt();
        int rowUpdated = this.queryUpdate("updateFishingOperationCatchBatch", "fishingOperationId", IntegerType.INSTANCE, fishingOperationId, "catchBatchId", IntegerType.INSTANCE, catchBatch.getId());
        if (rowUpdated == 0) {
            throw new DataIntegrityViolationException("Could not attach catch batch to the given operation : operation was not found.");
        }
        return bean;
    }

    @Override
    public CatchBatch saveCatchBatch(CatchBatch bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)bean.getId());
        Preconditions.checkNotNull((Object)bean.getFishingOperation());
        Preconditions.checkNotNull((Object)bean.getFishingOperation().getId());
        this.getCurrentSession().enableFetchProfile("batch-with-childs");
        this.getCurrentSession().setFlushMode(FlushMode.COMMIT);
        fr.ifremer.adagio.core.dao.data.batch.CatchBatch catchBatch = (fr.ifremer.adagio.core.dao.data.batch.CatchBatch)this.load(CatchBatchImpl.class, bean.getIdAsInt());
        if (catchBatch == null) {
            throw new DataRetrievalFailureException("Could not retrieve catch batch with id=" + bean.getId());
        }
        this.catchBatchToEntity(bean, catchBatch);
        this.batchHelper.update(catchBatch);
        this.getCurrentSession().flush();
        return bean;
    }

    @Override
    public void deleteCatchBatch(String fishingOperationId) {
        Preconditions.checkNotNull((Object)fishingOperationId);
        Integer catchBatchId = this.batchHelper.getCatchBatchIdByFishingOperationId(Integer.valueOf(fishingOperationId));
        if (catchBatchId == null) {
            throw new DataRetrievalFailureException("Could not retrieve catch batch for fishingOperation id=" + fishingOperationId);
        }
        this.batchHelper.deleteCatchBatch(fishingOperationId, catchBatchId);
    }

    protected void catchBatchToEntity(CatchBatch source, fr.ifremer.adagio.core.dao.data.batch.CatchBatch target) {
        boolean needUnsorted;
        Preconditions.checkNotNull((Object)source.getFishingOperation());
        Preconditions.checkNotNull((Object)source.getFishingOperation().getId());
        Integer fishingOperationId = source.getFishingOperation().getIdAsInt();
        target.setFishingOperation((FishingOperation)this.load(FishingOperationImpl.class, fishingOperationId));
        target.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)this.enumeration.QUALITY_FLAG_CODE_NOT_QUALIFIED)));
        target.setRankOrder(Short.valueOf((short)1));
        target.setSynchronizationStatus(SynchronizationStatus.DIRTY.getValue());
        Collection quantificationMeasurements = target.getQuantificationMeasurements();
        HashSet notChangedQuantificationMeasurements = Sets.newHashSet();
        if (quantificationMeasurements != null) {
            notChangedQuantificationMeasurements.addAll(quantificationMeasurements);
        }
        if (source.getCatchTotalWeight() != null) {
            QuantificationMeasurement quantificationMeasurement = this.batchHelper.setWeightMeasurementQuantificationMeasurement((Batch)target, source.getCatchTotalWeight());
            notChangedQuantificationMeasurements.remove(quantificationMeasurement);
        }
        if (quantificationMeasurements != null) {
            quantificationMeasurements.removeAll(notChangedQuantificationMeasurements);
        }
        boolean needVracSpeciesAliveNotItemized = source.getSpeciesTotalLivingNotItemizedWeight() != null;
        boolean needVracSpeciesInert = source.getSpeciesTotalInertWeight() != null;
        boolean needVracSpeciesAliveItemized = false;
        boolean needVracSpecies = source.getSpeciesTotalSortedWeight() != null || needVracSpeciesAliveNotItemized || needVracSpeciesInert || needVracSpeciesAliveItemized;
        boolean needVracBenthosAliveNotItemized = source.getBenthosTotalLivingNotItemizedWeight() != null;
        boolean needVracBenthosInert = source.getBenthosTotalInertWeight() != null;
        boolean needVracBenthosAliveItemized = false;
        boolean needVracBenthos = source.getBenthosTotalSortedWeight() != null || needVracBenthosAliveNotItemized || needVracBenthosInert || needVracBenthosAliveItemized;
        boolean needVrac = source.getCatchTotalSortedCarousselWeight() != null || source.getCatchTotalSortedTremisWeight() != null || needVracSpecies || needVracBenthos;
        boolean needHorsVracSpecies = false;
        boolean needHorsVracBenthos = false;
        boolean needHorsVracMarineLitter = source.getMarineLitterTotalWeight() != null;
        boolean needHorsVrac = needHorsVracSpecies || needHorsVracBenthos || needHorsVracMarineLitter;
        boolean bl = needUnsorted = source.getCatchTotalRejectedWeight() != null;
        if (needVrac) {
            SortingBatch vracBatch = this.batchHelper.getOrCreateVracBatch(target, source.getCatchTotalSortedCarousselWeight(), source.getCatchTotalSortedTremisWeight());
            if (needVracSpecies) {
                SortingBatch speciesBatch = this.batchHelper.getOrCreateSpeciesVracRootBatch(target, vracBatch, source.getSpeciesTotalSortedWeight());
                if (needVracSpeciesAliveNotItemized) {
                    this.batchHelper.getOrCreateSpeciesVracAliveNotItemizeRootBatch(target, speciesBatch, source.getSpeciesTotalLivingNotItemizedWeight());
                }
                if (needVracSpeciesInert) {
                    this.batchHelper.getOrCreateSpeciesVracInertRootBatch(target, speciesBatch, source.getSpeciesTotalInertWeight());
                }
                if (needVracSpeciesAliveItemized) {
                    this.batchHelper.getOrCreateSpeciesVracAliveItemizeRootBatch(target, speciesBatch);
                }
            }
            if (needVracBenthos) {
                SortingBatch benthosBatch = this.batchHelper.getOrCreateBenthosVracRootBatch(target, vracBatch, source.getBenthosTotalSortedWeight());
                if (needVracBenthosAliveNotItemized) {
                    this.batchHelper.getOrCreateBenthosVracAliveNotItemizeRootBatch(target, benthosBatch, source.getBenthosTotalLivingNotItemizedWeight());
                }
                if (needVracBenthosInert) {
                    this.batchHelper.getOrCreateBenthosVracInertRootBatch(target, benthosBatch, source.getBenthosTotalInertWeight());
                }
                if (needVracBenthosAliveItemized) {
                    this.batchHelper.getOrCreateBenthosVracAliveItemizeRootBatch(target, benthosBatch);
                }
            }
        }
        if (needHorsVrac) {
            SortingBatch horsVracBatch = this.batchHelper.getOrCreateHorsVracBatch(target);
            if (needHorsVracSpecies) {
                this.batchHelper.getOrCreateSpeciesHorsVracRootBatch(target, horsVracBatch);
            }
            if (needHorsVracBenthos) {
                this.batchHelper.getOrCreateBenthosHorsVracRootBatch(target, horsVracBatch);
            }
            if (needHorsVracMarineLitter) {
                this.batchHelper.getOrCreateMarineLitterRootBatch(target, horsVracBatch, source.getMarineLitterTotalWeight());
            }
        }
        if (needUnsorted) {
            this.batchHelper.getOrCreateRejectedBatch(target, source.getCatchTotalRejectedWeight());
        }
    }
}

