/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.mapping;

import java.io.File;
import java.io.FileReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.common.ResourceUtils;
import org.andromda.core.common.XmlObjectFactory;
import org.andromda.core.mapping.Mapping;
import org.andromda.core.mapping.MappingsException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Mappings {
    private final Map mappings = new LinkedHashMap();
    private static final Map logicalMappings = new LinkedHashMap();
    private URL resource;
    private String name = null;
    private String extendsUri;
    private final Map completePaths = new LinkedHashMap();
    static /* synthetic */ Class class$org$andromda$core$mapping$Mappings;

    public static Mappings getInstance(String mappingsUri) {
        mappingsUri = StringUtils.trimToEmpty((String)mappingsUri);
        ExceptionUtils.checkEmpty("mappingsUri", mappingsUri);
        try {
            Mappings mappings = (Mappings)logicalMappings.get(mappingsUri);
            if (mappings == null) {
                try {
                    mappings = Mappings.getInstance(new URL(mappingsUri));
                }
                catch (MalformedURLException exception) {
                    throw new MappingsException("The given URI --> '" + mappingsUri + "' is invalid", exception);
                }
            }
            return Mappings.getInheritedMappings(mappings);
        }
        catch (Throwable throwable) {
            throw new MappingsException(throwable);
        }
    }

    private static Mappings getInheritedMappings(Mappings mappings) throws Exception {
        return Mappings.getInheritedMappings(mappings, false);
    }

    private static Mappings getInheritedMappings(Mappings mappings, boolean ignoreInheritanceFailure) throws Exception {
        if (mappings != null && StringUtils.isNotBlank((String)mappings.extendsUri)) {
            Mappings parentMappings;
            block5: {
                parentMappings = (Mappings)logicalMappings.get(mappings.extendsUri);
                if (parentMappings == null) {
                    try {
                        parentMappings = Mappings.getInstance(new File(mappings.getCompletePath(mappings.extendsUri)));
                    }
                    catch (Exception exception) {
                        if (ignoreInheritanceFailure) break block5;
                        throw exception;
                    }
                }
            }
            if (parentMappings != null) {
                Mappings.mergeWithoutOverriding(parentMappings, mappings);
            }
        }
        return mappings;
    }

    public static Mappings getInstance(URL mappingsUri) {
        return Mappings.getInstance(mappingsUri, false);
    }

    private static Mappings getInstance(URL mappingsUri, boolean ignoreInheritanceFailure) {
        ExceptionUtils.checkNull("mappingsUri", mappingsUri);
        try {
            Mappings mappings = (Mappings)XmlObjectFactory.getInstance(class$org$andromda$core$mapping$Mappings == null ? (class$org$andromda$core$mapping$Mappings = Mappings.class$("org.andromda.core.mapping.Mappings")) : class$org$andromda$core$mapping$Mappings).getObject(mappingsUri);
            mappings.resource = mappingsUri;
            return Mappings.getInheritedMappings(mappings, ignoreInheritanceFailure);
        }
        catch (Throwable throwable) {
            throw new MappingsException(throwable);
        }
    }

    private static Mappings getInstance(File mappingsFile) throws Exception {
        Mappings mappings = (Mappings)XmlObjectFactory.getInstance(class$org$andromda$core$mapping$Mappings == null ? (class$org$andromda$core$mapping$Mappings = Mappings.class$("org.andromda.core.mapping.Mappings")) : class$org$andromda$core$mapping$Mappings).getObject(new FileReader(mappingsFile));
        mappings.resource = mappingsFile.toURI().toURL();
        return mappings;
    }

    public static void initializeLogicalMappings() {
        HashMap unprocessedMappings = new HashMap(logicalMappings);
        LinkedHashMap<String, Mappings> processedMappings = new LinkedHashMap<String, Mappings>();
        boolean processed = true;
        while (processed) {
            processed = false;
            Iterator iterator = unprocessedMappings.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry logicalMapping = iterator.next();
                String name = (String)logicalMapping.getKey();
                Mappings mappings = (Mappings)logicalMapping.getValue();
                if (mappings.extendsUri == null) {
                    processedMappings.put(name, mappings);
                    iterator.remove();
                    processed = true;
                    continue;
                }
                if (!processedMappings.containsKey(mappings.extendsUri)) continue;
                Mappings parentMappings = (Mappings)processedMappings.get(mappings.extendsUri);
                if (parentMappings != null) {
                    Mappings.mergeWithoutOverriding(parentMappings, mappings);
                }
                processedMappings.put(name, mappings);
                iterator.remove();
                processed = true;
            }
        }
        if (!unprocessedMappings.isEmpty()) {
            throw new MappingsException("Logical mappings cannot be initialized due to invalid inheritance: " + unprocessedMappings.keySet());
        }
        logicalMappings.putAll(processedMappings);
    }

    public static void clearLogicalMappings() {
        logicalMappings.clear();
    }

    public String getName() {
        String methodName = "Mappings.getName";
        if (StringUtils.isEmpty((String)this.name)) {
            throw new MappingsException("Mappings.getName - name can not be null or empty");
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExtendsUri(String extendsUri) {
        this.extendsUri = extendsUri;
    }

    public void addMapping(Mapping mapping) {
        ExceptionUtils.checkNull("mapping", mapping);
        Collection fromTypes = mapping.getFroms();
        ExceptionUtils.checkNull("mapping.fromTypes", fromTypes);
        Iterator typeIterator = fromTypes.iterator();
        while (typeIterator.hasNext()) {
            mapping.setMappings(this);
            this.mappings.put(typeIterator.next(), mapping);
        }
    }

    public void addMappings(Mappings mappings) {
        if (mappings != null && mappings.mappings != null) {
            this.mappings.putAll(mappings.mappings);
        }
    }

    private static void mergeWithoutOverriding(Mappings sourceMappings, Mappings targetMappings) {
        LinkedHashMap allMappings = new LinkedHashMap(targetMappings.mappings.size() + sourceMappings.mappings.size());
        allMappings.putAll(sourceMappings.mappings);
        allMappings.putAll(targetMappings.mappings);
        targetMappings.mappings.clear();
        targetMappings.mappings.putAll(allMappings);
    }

    public String getTo(String from) {
        String initialFrom = from = StringUtils.trimToEmpty((String)from);
        String to = null;
        Mapping mapping = this.getMapping(from);
        if (mapping != null) {
            to = mapping.getTo();
        }
        if (to == null) {
            to = initialFrom;
        }
        return StringUtils.trimToEmpty((String)to);
    }

    public static void addLogicalMappings(URL mappingsUri) {
        Mappings mappings = Mappings.getInstance(mappingsUri, true);
        logicalMappings.put(mappings.getName(), mappings);
    }

    public boolean containsFrom(String from) {
        return this.getMapping(from) != null;
    }

    public URL getResource() {
        return this.resource;
    }

    public Collection getMappings() {
        return this.mappings.values();
    }

    public Mapping getMapping(String from) {
        return (Mapping)this.mappings.get(StringUtils.trimToEmpty((String)from));
    }

    final String getCompletePath(String relativePath) {
        String completePath = (String)this.completePaths.get(relativePath);
        if (completePath == null) {
            URL resource;
            StringBuffer path = new StringBuffer();
            if (this.mappings != null && (resource = this.getResource()) != null) {
                String rootPath = resource.getFile().replace('\\', '/');
                rootPath = rootPath.substring(0, rootPath.lastIndexOf(47) + 1);
                path.append(rootPath);
            }
            if (relativePath != null) {
                path.append(StringUtils.trimToEmpty((String)relativePath));
            }
            completePath = path.toString();
            this.completePaths.put(relativePath, completePath);
        }
        return ResourceUtils.unescapeFilePath(completePath);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

