package fr.ifremer.tutti.ui.swing.util.table;

/*
 * #%L
 * Tutti :: UI
 * $Id: MoveToPreviousEditableCellAction.java 30 2012-12-06 17:03:05Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/table/MoveToPreviousEditableCellAction.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.JTable;
import java.awt.event.ActionEvent;

/**
 * Action to select previous editable cell in a table.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class MoveToPreviousEditableCellAction<M extends AbstractTuttiTableModel> extends AbstractSelectTableAction<M> {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(MoveToPreviousEditableCellAction.class);

    public static <M extends AbstractTuttiTableModel> MoveToPreviousEditableCellAction<M> newAction(M model, JTable table) {
        return new MoveToPreviousEditableCellAction<M>(model, table);
    }

    protected MoveToPreviousEditableCellAction(M model, JTable table) {
        super(model, table);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int currentRow = getSelectedRow();
        int currentColumn = getSelectedColumn();

        if (log.isDebugEnabled()) {
            log.debug("Move to previous editable cell, " +
                      getCellCoordinate(currentRow, currentColumn));
        }

        int columnCount = getColumnCount();

        while (currentRow > 0 || currentColumn > 0) {

            // go to next cell
            currentColumn--;

            // select next cell
            if (currentColumn < 0) {

                currentColumn = columnCount - 1;
                currentRow--;
            }

            if (isCellEditable(currentRow, currentColumn)) {
                doSelectCell(currentRow, currentColumn);
                break;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Cell not editable at " +
                              getCellCoordinate(currentRow, currentColumn));
                }
            }
        }
    }
}