/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.service.protocol.TuttiProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportAllCaracteristicAction
extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    private static final Log log = LogFactory.getLog(ExportAllCaracteristicAction.class);
    protected File file;

    public ExportAllCaracteristicAction(EditProtocolUIHandler handler) {
        super(handler, true);
    }

    @Override
    protected boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = TuttiUIUtil.saveFile("tuttiProtocol-" + ((EditProtocolUIModel)((Object)this.getModel())).getName() + "-allCaracteristics.csv", this.getContext().getMainUI(), I18n._((String)"tutti.editProtocol.title.choose.caracteristicExportFile", (Object[])new Object[0]), I18n._((String)"tutti.editProtocol.action.chooseProtocolCaracteristicFile", (Object[])new Object[0]), "^.*\\.csv", I18n._((String)"tutti.common.file.csv", (Object[])new Object[0]));
            if (this.file == null) {
                doAction = false;
            } else {
                this.file = TuttiIOUtil.addExtensionIfMissing((File)this.file, (String)".csv");
                doAction = ((EditProtocolUIHandler)this.getHandler()).askOverwriteFile(this.file);
            }
        }
        return doAction;
    }

    @Override
    protected void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    protected void doAction() throws Exception {
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export all caracteristic to file: " + this.file));
        }
        TuttiProtocolImportExportService service = this.getContext().getTuttiProtocolImportExportService();
        service.exportAllCaracteristic(this.file, ((EditProtocolUIModel)((Object)this.getModel())).getAllCaracteristic());
        this.sendMessage(I18n._((String)"tutti.flash.info.all.caractristic.exported", (Object[])new Object[]{this.file}));
    }
}

