package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.TableViewMode;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.editor.TuttiComputedOrNotDataEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static fr.ifremer.tutti.ui.swing.util.TuttiUIUtil.getWeightStringValue;
import static org.nuiton.i18n.I18n._;

public class BenthosBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<BenthosBatchUIModel, BenthosBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BENTHOS_TOTAL_INERT_WEIGHT_FIELD_BEAN = "benthosTotalInertWeightField.bean";
    public static final String BINDING_BENTHOS_TOTAL_INERT_WEIGHT_FIELD_MODEL = "benthosTotalInertWeightField.model";
    public static final String BINDING_BENTHOS_TOTAL_INERT_WEIGHT_FIELD_NUMBER_PATTERN = "benthosTotalInertWeightField.numberPattern";
    public static final String BINDING_BENTHOS_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_BEAN = "benthosTotalLivingNotItemizedWeightField.bean";
    public static final String BINDING_BENTHOS_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_MODEL = "benthosTotalLivingNotItemizedWeightField.model";
    public static final String BINDING_BENTHOS_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_NUMBER_PATTERN = "benthosTotalLivingNotItemizedWeightField.numberPattern";
    public static final String BINDING_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_TEXT = "benthosTotalSampleSortedWeightField.text";
    public static final String BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_BEAN = "benthosTotalSortedWeightField.bean";
    public static final String BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_MODEL = "benthosTotalSortedWeightField.model";
    public static final String BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_NUMBER_PATTERN = "benthosTotalSortedWeightField.numberPattern";
    public static final String BINDING_BENTHOS_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT = "benthosTotalUnsortedWeightField.text";
    public static final String BINDING_BENTHOS_TOTAL_WEIGHT_FIELD_TEXT = "benthosTotalWeightField.text";
    public static final String BINDING_CREATE_BENTHOS_BATCH_BUTTON_ENABLED = "createBenthosBatchButton.enabled";
    public static final String BINDING_FILTER_BENTHOS_BATCH_ALL_BUTTON_SELECTED = "filterBenthosBatchAllButton.selected";
    public static final String BINDING_FILTER_BENTHOS_BATCH_LEAF_BUTTON_SELECTED = "filterBenthosBatchLeafButton.selected";
    public static final String BINDING_FILTER_BENTHOS_BATCH_ROOT_BUTTON_SELECTED = "filterBenthosBatchRootButton.selected";
    public static final String BINDING_FILTER_BENTHOS_BATCH_ROOT_BUTTON_TEXT = "filterBenthosBatchRootButton.text";
    public static final String BINDING_REMOVE_BENTHOS_BATCH_MENU_ENABLED = "removeBenthosBatchMenu.enabled";
    public static final String BINDING_REMOVE_BENTHOS_SUB_BATCH_MENU_ENABLED = "removeBenthosSubBatchMenu.enabled";
    public static final String BINDING_RENAME_BENTHOS_BATCH_MENU_ENABLED = "renameBenthosBatchMenu.enabled";
    public static final String BINDING_SPLIT_BENTHOS_BATCH_MENU_ENABLED = "splitBenthosBatchMenu.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(BenthosBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiComputedOrNotDataEditor benthosTotalInertWeightField;
    protected JLabel benthosTotalInertWeightLabel;
    protected TuttiComputedOrNotDataEditor benthosTotalLivingNotItemizedWeightField;
    protected JLabel benthosTotalLivingNotItemizedWeightLabel;
    protected JTextField benthosTotalSampleSortedWeightField;
    protected JLabel benthosTotalSampleSortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "benthosTotalSortedWeight",  editorName = "benthosTotalSortedWeightField")
    protected TuttiComputedOrNotDataEditor benthosTotalSortedWeightField;
    protected JLabel benthosTotalSortedWeightLabel;
    protected JTextField benthosTotalUnsortedWeightField;
    protected JLabel benthosTotalUnsortedWeightLabel;
    protected JTextField benthosTotalWeightField;
    protected JLabel benthosTotalWeightLabel;
    protected TuttiHelpBroker broker;
    protected JButton createBenthosBatchButton;
    protected JMenuItem createSpeciesMelagMenu;
    protected BenthosBatchUI editBenthosBatchTopPanel = this;
    protected JRadioButton filterBenthosBatchAllButton;
    protected JLabel filterBenthosBatchLabel;
    protected JRadioButton filterBenthosBatchLeafButton;
    protected JAXXButtonGroup filterBenthosBatchMode;
    protected JRadioButton filterBenthosBatchRootButton;
    protected JPanel filterTablePane;
    protected Table form;
    protected BenthosBatchUIHandler handler;
    protected BenthosBatchUIModel model;
    protected JMenuItem removeBenthosBatchMenu;
    protected JMenuItem removeBenthosSubBatchMenu;
    protected JMenuItem renameBenthosBatchMenu;
    protected JMenuItem splitBenthosBatchMenu;
    protected JXTable table;
    protected JPopupMenu tablePopup;
    protected JScrollPane tableScrollPane;
    protected JPanel tableToolbar;
    @Validator( validatorId = "validator")
    protected SwingValidator<BenthosBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BenthosBatchUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            BenthosBatchUIHandler handler = new BenthosBatchUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public BenthosBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BenthosBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BenthosBatchUI() {
        $initialize();
    }

    public BenthosBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BenthosBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public BenthosBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BenthosBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public BenthosBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__createBenthosBatchButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.createBatch();
    }

    public void doActionPerformed__on__filterBenthosBatchAllButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setTableViewMode(TableViewMode.ALL);
    }

    public void doActionPerformed__on__filterBenthosBatchLeafButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setTableViewMode(TableViewMode.LEAF);
    }

    public void doActionPerformed__on__filterBenthosBatchRootButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setTableViewMode(TableViewMode.ROOT);
    }

    public void doActionPerformed__on__splitBenthosBatchMenu(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.splitBatch();
    }

    public void doKeyPressed__on__table(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openRowMenu(event, tablePopup);
    }

    public void doMouseClicked__on__table(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.autoSelectRowInTable(event, tablePopup);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiComputedOrNotDataEditor getBenthosTotalInertWeightField() {
        return benthosTotalInertWeightField;
    }

    public JLabel getBenthosTotalInertWeightLabel() {
        return benthosTotalInertWeightLabel;
    }

    public TuttiComputedOrNotDataEditor getBenthosTotalLivingNotItemizedWeightField() {
        return benthosTotalLivingNotItemizedWeightField;
    }

    public JLabel getBenthosTotalLivingNotItemizedWeightLabel() {
        return benthosTotalLivingNotItemizedWeightLabel;
    }

    public JTextField getBenthosTotalSampleSortedWeightField() {
        return benthosTotalSampleSortedWeightField;
    }

    public JLabel getBenthosTotalSampleSortedWeightLabel() {
        return benthosTotalSampleSortedWeightLabel;
    }

    public TuttiComputedOrNotDataEditor getBenthosTotalSortedWeightField() {
        return benthosTotalSortedWeightField;
    }

    public JLabel getBenthosTotalSortedWeightLabel() {
        return benthosTotalSortedWeightLabel;
    }

    public JTextField getBenthosTotalUnsortedWeightField() {
        return benthosTotalUnsortedWeightField;
    }

    public JLabel getBenthosTotalUnsortedWeightLabel() {
        return benthosTotalUnsortedWeightLabel;
    }

    public JTextField getBenthosTotalWeightField() {
        return benthosTotalWeightField;
    }

    public JLabel getBenthosTotalWeightLabel() {
        return benthosTotalWeightLabel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCreateBenthosBatchButton() {
        return createBenthosBatchButton;
    }

    public JMenuItem getCreateSpeciesMelagMenu() {
        return createSpeciesMelagMenu;
    }

    public JRadioButton getFilterBenthosBatchAllButton() {
        return filterBenthosBatchAllButton;
    }

    public JLabel getFilterBenthosBatchLabel() {
        return filterBenthosBatchLabel;
    }

    public JRadioButton getFilterBenthosBatchLeafButton() {
        return filterBenthosBatchLeafButton;
    }

    public JAXXButtonGroup getFilterBenthosBatchMode() {
        return filterBenthosBatchMode;
    }

    public JRadioButton getFilterBenthosBatchRootButton() {
        return filterBenthosBatchRootButton;
    }

    public JPanel getFilterTablePane() {
        return filterTablePane;
    }

    public Table getForm() {
        return form;
    }

    public BenthosBatchUIHandler getHandler() {
        return handler;
    }

    public BenthosBatchUIModel getModel() {
        return model;
    }

    public JMenuItem getRemoveBenthosBatchMenu() {
        return removeBenthosBatchMenu;
    }

    public JMenuItem getRemoveBenthosSubBatchMenu() {
        return removeBenthosSubBatchMenu;
    }

    public JMenuItem getRenameBenthosBatchMenu() {
        return renameBenthosBatchMenu;
    }

    public JMenuItem getSplitBenthosBatchMenu() {
        return splitBenthosBatchMenu;
    }

    public JXTable getTable() {
        return table;
    }

    public JPopupMenu getTablePopup() {
        return tablePopup;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public JPanel getTableToolbar() {
        return tableToolbar;
    }

    public SwingValidator<BenthosBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditBenthosBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(form, BorderLayout.NORTH);
        add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToFilterBenthosBatchAllButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterBenthosBatchMode; filterBenthosBatchAllButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterBenthosBatchAllButton); }
    }

    protected void addChildrenToFilterBenthosBatchLeafButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterBenthosBatchMode; filterBenthosBatchLeafButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterBenthosBatchLeafButton); }
    }

    protected void addChildrenToFilterBenthosBatchRootButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterBenthosBatchMode; filterBenthosBatchRootButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterBenthosBatchRootButton); }
    }

    protected void addChildrenToFilterTablePane() {
        if (!allComponentsCreated) {
            return;
        }
        filterTablePane.add(filterBenthosBatchLabel);
        filterTablePane.add(filterBenthosBatchAllButton);
        filterTablePane.add(filterBenthosBatchLeafButton);
        filterTablePane.add(filterBenthosBatchRootButton);
    }

    protected void addChildrenToForm() {
        if (!allComponentsCreated) {
            return;
        }
        form.add(benthosTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalWeightField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalSortedWeightLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(benthosTotalSortedWeightField), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalSampleSortedWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalSampleSortedWeightField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalUnsortedWeightLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalUnsortedWeightField, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalInertWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalInertWeightField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalLivingNotItemizedWeightLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(benthosTotalLivingNotItemizedWeightField, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(tableToolbar, new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToTablePopup() {
        if (!allComponentsCreated) {
            return;
        }
        tablePopup.add(splitBenthosBatchMenu);
        tablePopup.add(removeBenthosBatchMenu);
        tablePopup.add(removeBenthosSubBatchMenu);
        tablePopup.add(renameBenthosBatchMenu);
        tablePopup.add(createSpeciesMelagMenu);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToTableToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        tableToolbar.add($JPanel0, BorderLayout.WEST);
        tableToolbar.add(filterTablePane, BorderLayout.CENTER);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createBenthosTotalInertWeightField() {
        $objectMap.put("benthosTotalInertWeightField", benthosTotalInertWeightField = new TuttiComputedOrNotDataEditor(this));
        
        benthosTotalInertWeightField.setName("benthosTotalInertWeightField");
        benthosTotalInertWeightField.setDecimalNumber(3);
        benthosTotalInertWeightField.setUseFloat(true);
        benthosTotalInertWeightField.setShowReset(true);
        benthosTotalInertWeightField.putClientProperty("selectOnFocus", true);
    }

    protected void createBenthosTotalInertWeightLabel() {
        $objectMap.put("benthosTotalInertWeightLabel", benthosTotalInertWeightLabel = new JLabel());
        
        benthosTotalInertWeightLabel.setName("benthosTotalInertWeightLabel");
        benthosTotalInertWeightLabel.setText(_("tutti.editBenthosBatch.field.benthosTotalInertWeight"));
        benthosTotalInertWeightLabel.setToolTipText(_("tutti.editBenthosBatch.field.benthosTotalInertWeight.tip"));
        benthosTotalInertWeightLabel.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalInertWeight.help");
    }

    protected void createBenthosTotalLivingNotItemizedWeightField() {
        $objectMap.put("benthosTotalLivingNotItemizedWeightField", benthosTotalLivingNotItemizedWeightField = new TuttiComputedOrNotDataEditor(this));
        
        benthosTotalLivingNotItemizedWeightField.setName("benthosTotalLivingNotItemizedWeightField");
        benthosTotalLivingNotItemizedWeightField.setDecimalNumber(3);
        benthosTotalLivingNotItemizedWeightField.setUseFloat(true);
        benthosTotalLivingNotItemizedWeightField.setShowReset(true);
        benthosTotalLivingNotItemizedWeightField.putClientProperty("selectOnFocus", true);
    }

    protected void createBenthosTotalLivingNotItemizedWeightLabel() {
        $objectMap.put("benthosTotalLivingNotItemizedWeightLabel", benthosTotalLivingNotItemizedWeightLabel = new JLabel());
        
        benthosTotalLivingNotItemizedWeightLabel.setName("benthosTotalLivingNotItemizedWeightLabel");
        benthosTotalLivingNotItemizedWeightLabel.setText(_("tutti.editBenthosBatch.field.benthosTotalLivingNotItemizedWeight"));
        benthosTotalLivingNotItemizedWeightLabel.setToolTipText(_("tutti.editBenthosBatch.field.benthosTotalLivingNotItemizedWeight.tip"));
        benthosTotalLivingNotItemizedWeightLabel.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalLivingNotItemizedWeight.help");
    }

    protected void createBenthosTotalSampleSortedWeightField() {
        $objectMap.put("benthosTotalSampleSortedWeightField", benthosTotalSampleSortedWeightField = new JTextField());
        
        benthosTotalSampleSortedWeightField.setName("benthosTotalSampleSortedWeightField");
        benthosTotalSampleSortedWeightField.setColumns(15);
        benthosTotalSampleSortedWeightField.putClientProperty("computed", true);
    }

    protected void createBenthosTotalSampleSortedWeightLabel() {
        $objectMap.put("benthosTotalSampleSortedWeightLabel", benthosTotalSampleSortedWeightLabel = new JLabel());
        
        benthosTotalSampleSortedWeightLabel.setName("benthosTotalSampleSortedWeightLabel");
        benthosTotalSampleSortedWeightLabel.setText(_("tutti.editBenthosBatch.field.benthosTotalSampleSortedWeight"));
        benthosTotalSampleSortedWeightLabel.setToolTipText(_("tutti.editBenthosBatch.field.benthosTotalSampleSortedWeight.tip"));
        benthosTotalSampleSortedWeightLabel.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalSampleSortedWeight.help");
    }

    protected void createBenthosTotalSortedWeightField() {
        $objectMap.put("benthosTotalSortedWeightField", benthosTotalSortedWeightField = new TuttiComputedOrNotDataEditor(this));
        
        benthosTotalSortedWeightField.setName("benthosTotalSortedWeightField");
        benthosTotalSortedWeightField.setDecimalNumber(3);
        benthosTotalSortedWeightField.setUseFloat(true);
        benthosTotalSortedWeightField.setShowReset(true);
        benthosTotalSortedWeightField.putClientProperty("selectOnFocus", true);
    }

    protected void createBenthosTotalSortedWeightLabel() {
        $objectMap.put("benthosTotalSortedWeightLabel", benthosTotalSortedWeightLabel = new JLabel());
        
        benthosTotalSortedWeightLabel.setName("benthosTotalSortedWeightLabel");
        benthosTotalSortedWeightLabel.setText(_("tutti.editBenthosBatch.field.benthosTotalSortedWeight"));
        benthosTotalSortedWeightLabel.setToolTipText(_("tutti.editBenthosBatch.field.benthosTotalSortedWeight.tip"));
        benthosTotalSortedWeightLabel.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalSortedWeight.help");
    }

    protected void createBenthosTotalUnsortedWeightField() {
        $objectMap.put("benthosTotalUnsortedWeightField", benthosTotalUnsortedWeightField = new JTextField());
        
        benthosTotalUnsortedWeightField.setName("benthosTotalUnsortedWeightField");
        benthosTotalUnsortedWeightField.setColumns(15);
        benthosTotalUnsortedWeightField.putClientProperty("computed", true);
    }

    protected void createBenthosTotalUnsortedWeightLabel() {
        $objectMap.put("benthosTotalUnsortedWeightLabel", benthosTotalUnsortedWeightLabel = new JLabel());
        
        benthosTotalUnsortedWeightLabel.setName("benthosTotalUnsortedWeightLabel");
        benthosTotalUnsortedWeightLabel.setText(_("tutti.editBenthosBatch.field.benthosTotalUnsortedWeight"));
        benthosTotalUnsortedWeightLabel.setToolTipText(_("tutti.editBenthosBatch.field.benthosTotalUnsortedWeight.tip"));
        benthosTotalUnsortedWeightLabel.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalUnsortedWeight.help");
    }

    protected void createBenthosTotalWeightField() {
        $objectMap.put("benthosTotalWeightField", benthosTotalWeightField = new JTextField());
        
        benthosTotalWeightField.setName("benthosTotalWeightField");
        benthosTotalWeightField.setColumns(15);
        benthosTotalWeightField.putClientProperty("computed", true);
    }

    protected void createBenthosTotalWeightLabel() {
        $objectMap.put("benthosTotalWeightLabel", benthosTotalWeightLabel = new JLabel());
        
        benthosTotalWeightLabel.setName("benthosTotalWeightLabel");
        benthosTotalWeightLabel.setText(_("tutti.editBenthosBatch.field.benthosTotalWeight"));
        benthosTotalWeightLabel.setToolTipText(_("tutti.editBenthosBatch.field.benthosTotalWeight.tip"));
        benthosTotalWeightLabel.putClientProperty("help", "tutti.editBenthosBatch.field.benthosTotalWeight.help");
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editBenthosBatch.help"));
    }

    protected void createCreateBenthosBatchButton() {
        $objectMap.put("createBenthosBatchButton", createBenthosBatchButton = new JButton());
        
        createBenthosBatchButton.setName("createBenthosBatchButton");
        createBenthosBatchButton.setText(_("tutti.editBenthosBatch.action.createBatch"));
        createBenthosBatchButton.setToolTipText(_("tutti.editBenthosBatch.action.createBatch.tip"));
        createBenthosBatchButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createBenthosBatchButton"));
        createBenthosBatchButton.putClientProperty("help", "tutti.editBenthosBatch.action.createBatch.help");
    }

    protected void createCreateSpeciesMelagMenu() {
        $objectMap.put("createSpeciesMelagMenu", createSpeciesMelagMenu = new JMenuItem());
        
        createSpeciesMelagMenu.setName("createSpeciesMelagMenu");
    }

    protected void createFilterBenthosBatchAllButton() {
        $objectMap.put("filterBenthosBatchAllButton", filterBenthosBatchAllButton = new JRadioButton());
        
        filterBenthosBatchAllButton.setName("filterBenthosBatchAllButton");
        filterBenthosBatchAllButton.setText(_("tutti.editBenthosBatch.filterBatch.mode.all"));
        { filterBenthosBatchAllButton.putClientProperty("$value", "all");  Object $buttonGroup = filterBenthosBatchAllButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterBenthosBatchAllButton.setToolTipText(_("tutti.editBenthosBatch.filterBatch.mode.all.tip"));
        filterBenthosBatchAllButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterBenthosBatchAllButton"));
    }

    protected void createFilterBenthosBatchLabel() {
        $objectMap.put("filterBenthosBatchLabel", filterBenthosBatchLabel = new JLabel());
        
        filterBenthosBatchLabel.setName("filterBenthosBatchLabel");
        filterBenthosBatchLabel.setText(_("tutti.editBenthosBatch.filterBatch"));
        filterBenthosBatchLabel.setToolTipText(_("tutti.editBenthosBatch.filterBatch.tip"));
        filterBenthosBatchLabel.putClientProperty("help", "tutti.editBenthosBatch.filterBatch.help");
        filterBenthosBatchLabel.putClientProperty("strongStyle", true);
    }

    protected void createFilterBenthosBatchLeafButton() {
        $objectMap.put("filterBenthosBatchLeafButton", filterBenthosBatchLeafButton = new JRadioButton());
        
        filterBenthosBatchLeafButton.setName("filterBenthosBatchLeafButton");
        filterBenthosBatchLeafButton.setText(_("tutti.editBenthosBatch.filterBatch.mode.leaf"));
        { filterBenthosBatchLeafButton.putClientProperty("$value", "leaf");  Object $buttonGroup = filterBenthosBatchLeafButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterBenthosBatchLeafButton.setToolTipText(_("tutti.editBenthosBatch.filterBatch.mode.leaf.tip"));
        filterBenthosBatchLeafButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterBenthosBatchLeafButton"));
    }

    protected void createFilterBenthosBatchMode() {
        $objectMap.put("filterBenthosBatchMode", filterBenthosBatchMode = new JAXXButtonGroup());
    }

    protected void createFilterBenthosBatchRootButton() {
        $objectMap.put("filterBenthosBatchRootButton", filterBenthosBatchRootButton = new JRadioButton());
        
        filterBenthosBatchRootButton.setName("filterBenthosBatchRootButton");
        { filterBenthosBatchRootButton.putClientProperty("$value", "root");  Object $buttonGroup = filterBenthosBatchRootButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterBenthosBatchRootButton.setToolTipText(_("tutti.editBenthosBatch.filterBatch.mode.root.tip"));
        filterBenthosBatchRootButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterBenthosBatchRootButton"));
    }

    protected void createFilterTablePane() {
        $objectMap.put("filterTablePane", filterTablePane = new JPanel());
        
        filterTablePane.setName("filterTablePane");
    }

    protected void createForm() {
        $objectMap.put("form", form = new Table());
        
        form.setName("form");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(BenthosBatchUIHandler.class));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(BenthosBatchUIModel.class));
    }

    protected void createRemoveBenthosBatchMenu() {
        $objectMap.put("removeBenthosBatchMenu", removeBenthosBatchMenu = new JMenuItem());
        
        removeBenthosBatchMenu.setName("removeBenthosBatchMenu");
        removeBenthosBatchMenu.setText(_("tutti.editBenthosBatch.action.removeBatch"));
        removeBenthosBatchMenu.setToolTipText(_("tutti.editBenthosBatch.action.removeBatch.tip"));
        removeBenthosBatchMenu.putClientProperty("help", "tutti.editBenthosBatch.action.removeBatch.help");
        removeBenthosBatchMenu.putClientProperty("tuttiAction", RemoveBenthosBatchAction.class);
    }

    protected void createRemoveBenthosSubBatchMenu() {
        $objectMap.put("removeBenthosSubBatchMenu", removeBenthosSubBatchMenu = new JMenuItem());
        
        removeBenthosSubBatchMenu.setName("removeBenthosSubBatchMenu");
        removeBenthosSubBatchMenu.setText(_("tutti.editBenthosBatch.action.removeSubBatch"));
        removeBenthosSubBatchMenu.setToolTipText(_("tutti.editBenthosBatch.action.removeSubBatch.tip"));
        removeBenthosSubBatchMenu.putClientProperty("help", "tutti.editBenthosBatch.action.removeSubBatch.help");
        removeBenthosSubBatchMenu.putClientProperty("tuttiAction", RemoveBenthosSubBatchAction.class);
    }

    protected void createRenameBenthosBatchMenu() {
        $objectMap.put("renameBenthosBatchMenu", renameBenthosBatchMenu = new JMenuItem());
        
        renameBenthosBatchMenu.setName("renameBenthosBatchMenu");
        renameBenthosBatchMenu.setText(_("tutti.editBenthosBatch.action.renameBatch"));
        renameBenthosBatchMenu.setToolTipText(_("tutti.editBenthosBatch.action.renameBatch.tip"));
        renameBenthosBatchMenu.putClientProperty("help", "tutti.editBenthosBatch.action.renameBatch.help");
        renameBenthosBatchMenu.putClientProperty("tuttiAction", RenameBenthosBatchAction.class);
    }

    protected void createSplitBenthosBatchMenu() {
        $objectMap.put("splitBenthosBatchMenu", splitBenthosBatchMenu = new JMenuItem());
        
        splitBenthosBatchMenu.setName("splitBenthosBatchMenu");
        splitBenthosBatchMenu.setText(_("tutti.editBenthosBatch.action.splitBatch"));
        splitBenthosBatchMenu.setToolTipText(_("tutti.editBenthosBatch.action.splitBatch.tip"));
        splitBenthosBatchMenu.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__splitBenthosBatchMenu"));
        splitBenthosBatchMenu.putClientProperty("help", "tutti.editBenthosBatch.action.splitBatch.help");
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
        table.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyPressed", this, "doKeyPressed__on__table"));
        table.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__table"));
    }

    protected void createTablePopup() {
        $objectMap.put("tablePopup", tablePopup = new JPopupMenu());
        
        tablePopup.setName("tablePopup");
        tablePopup.setLabel("tutti.editBenthosBatch.title.batchActions");
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createTableToolbar() {
        $objectMap.put("tableToolbar", tableToolbar = new JPanel());
        
        tableToolbar.setName("tableToolbar");
        tableToolbar.setLayout(new BorderLayout());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(BenthosBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditBenthosBatchTopPanel();
        addChildrenToValidator();
        addChildrenToTablePopup();
        addChildrenToForm();
        addChildrenToTableToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createBenthosBatchButton);
        addChildrenToFilterTablePane();
        addChildrenToFilterBenthosBatchAllButton();
        addChildrenToFilterBenthosBatchLeafButton();
        addChildrenToFilterBenthosBatchRootButton();
        addChildrenToTableScrollPane();
        
        // apply 21 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 33 property setters
        splitBenthosBatchMenu.setIcon(SwingUtil.createActionIcon("batch-split"));
        splitBenthosBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editBenthosBatch.action.splitBatch.mnemonic"),'Z'));
        removeBenthosBatchMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeBenthosBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editBenthosBatch.action.removeBatch.mnemonic"),'Z'));
        removeBenthosSubBatchMenu.setIcon(SwingUtil.createActionIcon("batch-delete"));
        removeBenthosSubBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editBenthosBatch.action.removeSubBatch.mnemonic"),'Z'));
        renameBenthosBatchMenu.setIcon(SwingUtil.createActionIcon("batch-rename"));
        renameBenthosBatchMenu.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editBenthosBatch.action.renameBatch.mnemonic"),'Z'));
        benthosTotalWeightLabel.setLabelFor(benthosTotalWeightField);
        benthosTotalSortedWeightLabel.setLabelFor(benthosTotalSortedWeightField);
        benthosTotalSortedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        benthosTotalSortedWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        benthosTotalSortedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        benthosTotalSampleSortedWeightLabel.setLabelFor(benthosTotalSampleSortedWeightField);
        benthosTotalUnsortedWeightLabel.setLabelFor(benthosTotalUnsortedWeightField);
        benthosTotalInertWeightLabel.setLabelFor(benthosTotalInertWeightField);
        benthosTotalInertWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        benthosTotalInertWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        benthosTotalInertWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        benthosTotalLivingNotItemizedWeightLabel.setLabelFor(benthosTotalLivingNotItemizedWeightField);
        benthosTotalLivingNotItemizedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        benthosTotalLivingNotItemizedWeightField.setComputedDataColor(handler.getConfig().getColorComputedWeights());
        benthosTotalLivingNotItemizedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        createBenthosBatchButton.setIcon(SwingUtil.createActionIcon("batch-create"));
        createBenthosBatchButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editBenthosBatch.action.createBatch.mnemonic"),'Z'));
        filterTablePane.setBorder(new TitledBorder(null, ""));
        filterBenthosBatchLabel.setIcon(SwingUtil.createActionIcon("filter"));
        table.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editBenthosBatchTopPanel, "tutti.editBenthosBatch.help");
        registerHelpId(_broker, splitBenthosBatchMenu, "tutti.editBenthosBatch.action.splitBatch.help");
        registerHelpId(_broker, removeBenthosBatchMenu, "tutti.editBenthosBatch.action.removeBatch.help");
        registerHelpId(_broker, removeBenthosSubBatchMenu, "tutti.editBenthosBatch.action.removeSubBatch.help");
        registerHelpId(_broker, renameBenthosBatchMenu, "tutti.editBenthosBatch.action.renameBatch.help");
        registerHelpId(_broker, benthosTotalWeightLabel, "tutti.editBenthosBatch.field.benthosTotalWeight.help");
        registerHelpId(_broker, benthosTotalSortedWeightLabel, "tutti.editBenthosBatch.field.benthosTotalSortedWeight.help");
        registerHelpId(_broker, benthosTotalSampleSortedWeightLabel, "tutti.editBenthosBatch.field.benthosTotalSampleSortedWeight.help");
        registerHelpId(_broker, benthosTotalUnsortedWeightLabel, "tutti.editBenthosBatch.field.benthosTotalUnsortedWeight.help");
        registerHelpId(_broker, benthosTotalInertWeightLabel, "tutti.editBenthosBatch.field.benthosTotalInertWeight.help");
        registerHelpId(_broker, benthosTotalLivingNotItemizedWeightLabel, "tutti.editBenthosBatch.field.benthosTotalLivingNotItemizedWeight.help");
        registerHelpId(_broker, createBenthosBatchButton, "tutti.editBenthosBatch.action.createBatch.help");
        registerHelpId(_broker, filterBenthosBatchLabel, "tutti.editBenthosBatch.filterBatch.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("editBenthosBatchTopPanel", editBenthosBatchTopPanel);
        createHandler();
        createModel();
        createValidator();
        createBroker();
        createTablePopup();
        createSplitBenthosBatchMenu();
        createRemoveBenthosBatchMenu();
        createRemoveBenthosSubBatchMenu();
        createRenameBenthosBatchMenu();
        createCreateSpeciesMelagMenu();
        createForm();
        createBenthosTotalWeightLabel();
        createBenthosTotalWeightField();
        createBenthosTotalSortedWeightLabel();
        createBenthosTotalSortedWeightField();
        createBenthosTotalSampleSortedWeightLabel();
        createBenthosTotalSampleSortedWeightField();
        createBenthosTotalUnsortedWeightLabel();
        createBenthosTotalUnsortedWeightField();
        createBenthosTotalInertWeightLabel();
        createBenthosTotalInertWeightField();
        createBenthosTotalLivingNotItemizedWeightLabel();
        createBenthosTotalLivingNotItemizedWeightField();
        createTableToolbar();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCreateBenthosBatchButton();
        createFilterTablePane();
        createFilterBenthosBatchLabel();
        createFilterBenthosBatchAllButton();
        createFilterBenthosBatchLeafButton();
        createFilterBenthosBatchRootButton();
        createTableScrollPane();
        createTable();
        createFilterBenthosBatchMode();
        // inline creation of editBenthosBatchTopPanel
        setName("editBenthosBatchTopPanel");
        setLayout(new BorderLayout());
        editBenthosBatchTopPanel.putClientProperty("help", "tutti.editBenthosBatch.help");
        
        // registers 21 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 21 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPLIT_BENTHOS_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("splitBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    splitBenthosBatchMenu.setEnabled(model.isTableViewModeAll() && model.isSplitBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("splitBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_BENTHOS_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("removeBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeBenthosBatchMenu.setEnabled(model.isTableViewModeAll() && model.isRemoveBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("removeBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_BENTHOS_SUB_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("removeSubBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    removeBenthosSubBatchMenu.setEnabled(model.isTableViewModeAll() && model.isRemoveSubBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("removeSubBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RENAME_BENTHOS_BATCH_MENU_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("renameBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    renameBenthosBatchMenu.setEnabled(model.isTableViewModeAll() && model.isRenameBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("renameBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(benthosTotalWeightField, getWeightStringValue(model.getBenthosTotalComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalSortedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalSortedWeightField.setModel(model.getBenthosTotalSortedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalSortedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalSortedComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalSortedWeightField.setBean(model.getBenthosTotalSortedComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalSortedComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_NUMBER_PATTERN, true ,"DECIMAL3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                benthosTotalSortedWeightField.setNumberPattern(DECIMAL3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalSampleSortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(benthosTotalSampleSortedWeightField, getWeightStringValue(model.getBenthosTotalSampleSortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalSampleSortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalUnsortedComputedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(benthosTotalUnsortedWeightField, getWeightStringValue(model.getBenthosTotalUnsortedComputedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalUnsortedComputedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_INERT_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalInertWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalInertWeightField.setModel(model.getBenthosTotalInertWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalInertWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_INERT_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalInertComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalInertWeightField.setBean(model.getBenthosTotalInertComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalInertComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BENTHOS_TOTAL_INERT_WEIGHT_FIELD_NUMBER_PATTERN, true ,"DECIMAL3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                benthosTotalInertWeightField.setNumberPattern(DECIMAL3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalLivingNotItemizedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalLivingNotItemizedWeightField.setModel(model.getBenthosTotalLivingNotItemizedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalLivingNotItemizedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_BEAN, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalLivingNotItemizedComputedOrNotWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalLivingNotItemizedWeightField.setBean(model.getBenthosTotalLivingNotItemizedComputedOrNotWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalLivingNotItemizedComputedOrNotWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BENTHOS_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_FIELD_NUMBER_PATTERN, true ,"DECIMAL3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                benthosTotalLivingNotItemizedWeightField.setNumberPattern(DECIMAL3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CREATE_BENTHOS_BATCH_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("createBatchEnabled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    createBenthosBatchButton.setEnabled(model.isCreateBatchEnabled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("createBatchEnabled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_BENTHOS_BATCH_ALL_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeAll", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterBenthosBatchAllButton.setSelected(model.isTableViewModeAll());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeAll", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_BENTHOS_BATCH_LEAF_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeLeaf", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterBenthosBatchLeafButton.setSelected(model.isTableViewModeLeaf());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeLeaf", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_BENTHOS_BATCH_ROOT_BUTTON_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("rootNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterBenthosBatchRootButton.setText(_(handler.getFilterBenthosBatchRootButtonText(model.getRootNumber())));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("rootNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_BENTHOS_BATCH_ROOT_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("tableViewModeRoot", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterBenthosBatchRootButton.setSelected(model.isTableViewModeRoot());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("tableViewModeRoot", this);
                }
            }
        });
    }

}