package fr.ifremer.tutti.ui.swing.content.home;

/*
 * #%L
 * Tutti :: UI
 * $Id: ExportCruiseAction.java 846 2013-04-22 08:42:40Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/home/ExportCruiseAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.service.export.TuttiExportService;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.File;

import static org.nuiton.i18n.I18n._;

/**
 * To export a selected cruise.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.0
 */
public class ExportCruiseAction extends AbstractTuttiAction<SelectCruiseUIModel, SelectCruiseUI, SelectCruiseUIHandler> {

    /** Logger. */
    private static final Log log = LogFactory.getLog(ExportCruiseAction.class);

    protected File file;

    public ExportCruiseAction(SelectCruiseUIHandler handler) {
        super(handler, true);
    }

    @Override
    protected boolean prepareAction() throws Exception {

        boolean doAction = super.prepareAction();

        if (doAction) {

            Cruise cruise = getModel().getCruise();

            // choose file to export
            file = TuttiUIUtil.saveFile(
                    "exportCruise-" + cruise.getName() + ".zip",
                    getContext().getMainUI(),
                    _("tutti.selectCruise.title.choose.exportCruiseFile"),
                    _("tutti.selectCruise.action.chooseCruiseExportFile"),
                    "^.+\\.zip$", _("tutti.common.file.zip")
            );
            doAction = file != null;
            if (doAction) {
                file = TuttiIOUtil.addExtensionIfMissing(file, ".zip");

                // ask user to confirm overwrite.
                doAction = getHandler().askOverwriteFile(file);
            }
        }
        return doAction;
    }

    @Override
    protected void releaseAction() {
        file = null;
        super.releaseAction();
    }

    @Override
    protected void doAction() throws Exception {
        Cruise cruise = getModel().getCruise();
        Preconditions.checkNotNull(cruise);
        Preconditions.checkNotNull(file);

        if (log.isInfoEnabled()) {
            log.info("Will save cruise " + cruise.getId() +
                     " to file: " + file);
        }

        ProgressionModel progressionModel = new ProgressionModel();
        setProgressionModel(progressionModel);
        // check cruise / export cruise / operation / parameter / catches / zip
        progressionModel.setTotal(6);

        TuttiExportService service = getContext().getTuttiExportService();
        service.exportCruise(cruise.getId(), file, progressionModel);

        getHandler().resetEditCruiseAction();
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        Cruise cruise = getModel().getCruise();
        sendMessage(_("tutti.exportCruise.action.success",
                      cruise.getName(), file.getName()));
    }
}
