/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.attachment;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import fr.ifremer.tutti.ui.swing.util.attachment.ButtonAttachment;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import java.awt.Color;
import java.awt.Component;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AttachmentCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AttachmentCellEditor.class);
    protected JTable table;
    protected AbstractTuttiTableModel<AbstractTuttiBeanUIModel> tableModel;
    protected Integer rowIndex;
    protected Integer columnIndex;
    protected final ButtonAttachment editorButton;

    public static TableCellEditor newEditor(TuttiUI ui) {
        return new AttachmentCellEditor(((AbstractTuttiUIHandler)ui.getHandler()).getContext());
    }

    public AttachmentCellEditor(TuttiUIContext context) {
        this.editorButton = new ButtonAttachment(context, null);
        this.editorButton.setBorder(new LineBorder(Color.BLACK));
        this.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                AttachmentCellEditor.this.editorButton.setSelected(false);
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                AttachmentCellEditor.this.editorButton.setSelected(false);
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.tableModel = (AbstractTuttiTableModel)table.getModel();
        this.rowIndex = row;
        this.columnIndex = column;
        AttachmentModelAware model = (AttachmentModelAware)((Object)this.tableModel.getEntry(row));
        this.editorButton.init(model);
        return this.editorButton;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return false;
    }

    @Override
    public Object getCellEditorValue() {
        AttachmentModelAware model = this.editorButton.getBean();
        Preconditions.checkNotNull((Object)model, (Object)"No model found in editor.");
        List<Attachment> result = model.getAttachment();
        if (log.isInfoEnabled()) {
            log.info((Object)("editor value: " + result));
        }
        return result;
    }

    @Override
    public boolean stopCellEditing() {
        boolean b = super.stopCellEditing();
        if (b) {
            this.editorButton.setBean(null);
        }
        return b;
    }

    @Override
    public void cancelCellEditing() {
        this.editorButton.setBean(null);
        super.cancelCellEditing();
    }
}

