/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches;

import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.pupitri.TuttiPupitriImportExportService;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.ImportPupitriPopupUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import java.io.File;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ImportPupitriAction
extends AbstractTuttiAction<EditCatchesUIModel, EditCatchesUI, EditCatchesUIHandler> {
    private Log log = LogFactory.getLog(ImportPupitriAction.class);
    protected File importedTrunkFile;
    protected File importedCarrouselFile;
    protected ImportPupitriPopupUI importPupitriDialog;
    protected TuttiProtocol currentProtocol;
    protected PersistenceService persistenceService = this.getContext().getPersistenceService();
    protected EditFishingOperationAction editAction;

    public ImportPupitriAction(EditCatchesUIHandler handler) {
        super(handler, false);
        this.importPupitriDialog = new ImportPupitriPopupUI(handler.getContext());
    }

    public EditFishingOperationAction getEditAction() {
        if (this.editAction == null) {
            this.editAction = TuttiActionHelper.createLogicAction(((EditCatchesUIHandler)this.getHandler()).getParentHandler(), EditFishingOperationAction.class);
        }
        return this.editAction;
    }

    @Override
    protected boolean prepareAction() throws Exception {
        boolean result = true;
        this.currentProtocol = this.getDataContext().getProtocol();
        SpeciesBatchUIModel speciesBatchUIModel = ((EditCatchesUI)this.getUI()).getSpeciesTabContent().getModel();
        if (speciesBatchUIModel.getRowCount() > 0) {
            String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n._((String)"tutti.editCatchBatch.action.importPupitri.existingData.message", (Object[])new Object[0]), I18n._((String)"tutti.editCatchBatch.action.importPupitri.existingData.help", (Object[])new Object[0]));
            int answer = JOptionPane.showConfirmDialog(this.getContext().getActionUI(), htmlMessage, I18n._((String)"tutti.editCatchBatch.action.importPupitri.existingData.title", (Object[])new Object[0]), 2, 2);
            boolean bl = result = answer == 0;
        }
        if (result) {
            this.importPupitriDialog.open();
            this.importedTrunkFile = this.importPupitriDialog.getTrunkFile().getSelectedFile();
            this.importedCarrouselFile = this.importPupitriDialog.getCarrouselFile().getSelectedFile();
            result = this.importedTrunkFile != null && this.importedCarrouselFile != null;
        }
        return result;
    }

    @Override
    protected void doAction() throws Exception {
        TuttiPupitriImportExportService pupitriImportExportService = this.getContext().getTuttiPupitriImportExportService();
        EditCatchesUIModel model = (EditCatchesUIModel)this.getModel();
        FishingOperation operation = model.getFishingOperation();
        CatchBatch catchBatch = model.getCatchBatch();
        int rejectedSpeciesNb = pupitriImportExportService.importPupitri(this.importedTrunkFile, this.importedCarrouselFile, operation, catchBatch);
        String fishingOperationText = this.getEditAction().getFishingOperationTitle(operation);
        this.getEditAction().loadCatchBatch(operation, fishingOperationText, true);
        this.sendMessage(I18n._((String)"tutti.editCatchBatch.action.importPupitri.success", (Object[])new Object[]{((EditCatchesUI)this.getUI()).getSpeciesTabContent().getModel().getRootNumber(), rejectedSpeciesNb}));
    }

    @Override
    protected void releaseAction() {
        super.releaseAction();
        this.importedTrunkFile = null;
        this.importedCarrouselFile = null;
        this.currentProtocol = null;
    }
}

