/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator.swing;

import com.google.common.collect.Sets;
import java.util.HashSet;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import jaxx.runtime.validator.swing.SwingListValidatorDataLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.validator.bean.list.BeanListValidator;

public class SwingListValidatorTableEditorModelListener<O>
implements TableModelListener {
    private static final Log log = LogFactory.getLog(SwingListValidatorTableEditorModelListener.class);
    private final SwingListValidatorDataLocator<O> dataLocator;
    private BeanListValidator<O> validator;

    public SwingListValidatorTableEditorModelListener(BeanListValidator<O> validator, SwingListValidatorDataLocator<O> dataLocator) {
        this.dataLocator = dataLocator;
        this.validator = validator;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        O bean;
        int i;
        if (e.getType() == 1) {
            int firstRow = e.getFirstRow();
            int lastRow = e.getLastRow();
            for (i = firstRow; i <= lastRow; ++i) {
                TableModel model = (TableModel)e.getSource();
                bean = this.dataLocator.locateBean(model, i);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Add a bean to validator " + bean));
                }
                this.validator.addBean(bean);
            }
        }
        if (e.getType() == -1) {
            TableModel model = (TableModel)e.getSource();
            HashSet beans = Sets.newHashSet((Iterable)this.validator.getBeans());
            int max = model.getRowCount();
            for (i = 0; i < max; ++i) {
                bean = this.dataLocator.locateBean(model, i);
                beans.remove(bean);
            }
            for (Object bean2 : beans) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Remove a bean to validator " + bean2));
                }
                this.validator.removeBean(bean2);
            }
        }
    }
}

